/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.service;

import cloud.celonis.saprfc.domain.SapRfcRequest;
import cloud.celonis.saprfc.domain.error.RfcExecutionErrorResponse;
import cloud.celonis.saprfc.exception.JCoLoadingException;
import cloud.celonis.saprfc.exception.rfc.execution.RfcExecutionException;
import cloud.celonis.saprfc.mapper.RfmParameterMapper;
import cloud.celonis.saprfc.model.bapi.BapiFunctions;
import cloud.celonis.saprfc.model.bapi.BapiTransactionHandling;
import cloud.celonis.saprfc.model.rfc.execution.error.RfcExecutionErrorKey;
import cloud.celonis.saprfc.service.RfmMetadataService;
import cloud.celonis.saprfc.system.JCoLoader;
import cloud.celonis.saprfc.system.RfcDestinationProvider;
import cloud.celonis.saprfc.system.SapRfcDestinationProperties;
import cloud.celonis.saprfc.util.error.RfcExecutionErrorUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoTable;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapRfcExecutionService {
    private static final Logger log = LoggerFactory.getLogger(SapRfcExecutionService.class);
    private final JCoLoader jCoLoader;
    private final ObjectMapper agentObjectMapper;
    @VisibleForTesting
    protected static final String STRING_CLASS_PATH = "java.lang.String";

    public SapRfcExecutionService(JCoLoader jCoLoader, ObjectMapper agentObjectMapper) {
        this.jCoLoader = jCoLoader;
        this.agentObjectMapper = agentObjectMapper;
    }

    protected Object execute(SapRfcRequest request) {
        JCoFunction function;
        JCoDestination destination;
        boolean isMetadataRequest = false;
        RfcDestinationProvider dataProvider = this.jCoLoader.getDestinationProvider();
        try {
            destination = dataProvider.getDestination(new SapRfcDestinationProperties(request.getDestinationParameters()));
            boolean bl = isMetadataRequest = request.getRfmName().equals("RFC_METADATA_GET") || request.isMetadataRequest();
            if (isMetadataRequest) {
                return RfmMetadataService.handleMetadataRequest(request, destination.getRepository());
            }
            if (request.isCacheInvalidationRequest()) {
                return RfmMetadataService.invalidateCache(request.getRfmName(), destination.getRepository());
            }
            function = destination.getRepository().getFunction(request.getRfmName());
        }
        catch (JCoException jCoException) {
            if (isMetadataRequest) {
                log.error("Function metadata retrieval failed with error '{}'", (Object)jCoException.toString());
            } else {
                log.error("Execution failed with error '{}'.", (Object)jCoException.toString());
            }
            log.debug("Error details:", (Throwable)jCoException);
            return RfcExecutionErrorUtils.buildErrorResponse(jCoException);
        }
        catch (JCoLoadingException e) {
            this.jCoLoader.addError(e.getMessage());
            return new RfcExecutionErrorResponse(RfcExecutionErrorKey.JCO_NOT_LOADED.name(), "Agent not fully configured for SAP automations.", "See agent logs for more details.");
        }
        RfcExecutionErrorResponse errorResponse = this.prepareFunction(request, function);
        if (errorResponse != null) {
            return errorResponse;
        }
        errorResponse = this.executeFunction(destination, function, request.getBapiTransactionHandling());
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            return RfmParameterMapper.asJson(RfmParameterMapper.getParameterListMap(function), this.agentObjectMapper);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return new RfcExecutionErrorResponse(RfcExecutionErrorKey.RESPONSE_PARSING_ERROR.name(), "Failed to parse response parameters of " + request.getRfmName(), "See agent logs for more details");
        }
    }

    @VisibleForTesting
    @Nullable
    protected RfcExecutionErrorResponse executeFunction(JCoDestination destination, JCoFunction function, BapiTransactionHandling bapiTransactionHandling) {
        if (bapiTransactionHandling == null || bapiTransactionHandling == BapiTransactionHandling.NONE) {
            try {
                log.debug("Executing {}...", (Object)function.getName());
                function.execute(destination);
                log.debug("{} executed successfully.", (Object)function.getName());
            }
            catch (JCoException jCoException) {
                log.error("{} execution failed with error '{}'.", (Object)function.getName(), (Object)jCoException.toString());
                log.debug("Error details:", (Throwable)jCoException);
                return RfcExecutionErrorUtils.buildErrorResponse(jCoException);
            }
        } else {
            try {
                return this.prepareAndExecuteSequence(destination, function, bapiTransactionHandling);
            }
            catch (JCoException jCoException) {
                log.error("Something went wrong handling transaction: {}", (Object)jCoException.toString());
                log.debug("Error details:", (Throwable)jCoException);
                return RfcExecutionErrorUtils.buildErrorResponse(jCoException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    protected RfcExecutionErrorResponse prepareAndExecuteSequence(JCoDestination destination, JCoFunction function, BapiTransactionHandling bapiTransactionHandling) throws JCoException {
        JCoFunction bapiTransactionRollback = null;
        try {
            JCoFunction bapiTransactionCommit = destination.getRepository().getFunction(BapiFunctions.BAPI_TRANSACTION_COMMIT.name());
            if (bapiTransactionHandling == BapiTransactionHandling.COMMIT_AND_WAIT) {
                bapiTransactionCommit.getImportParameterList().setValue("WAIT", "X");
            }
            bapiTransactionRollback = destination.getRepository().getFunction(BapiFunctions.BAPI_TRANSACTION_ROLLBACK.name());
            JCoContext.begin((JCoDestination)destination);
            this.executeSequence(destination, function, bapiTransactionHandling, bapiTransactionRollback, bapiTransactionCommit);
        }
        catch (JCoException jCoException) {
            if (JCoContext.isStateful((JCoDestination)destination)) {
                log.error("{} execution failed with error '{}'. Rolling back...", (Object)function.getName(), (Object)jCoException.toString());
                this.rollbackTransaction(bapiTransactionRollback, destination);
            } else {
                log.error("{} execution failed with error '{}'.", (Object)function.getName(), (Object)jCoException.toString());
            }
            log.debug("Error details:", (Throwable)jCoException);
            RfcExecutionErrorResponse rfcExecutionErrorResponse = RfcExecutionErrorUtils.buildErrorResponse(jCoException);
            return rfcExecutionErrorResponse;
        }
        finally {
            if (JCoContext.isStateful((JCoDestination)destination)) {
                JCoContext.end((JCoDestination)destination);
            }
        }
        return null;
    }

    @VisibleForTesting
    protected void executeSequence(JCoDestination destination, JCoFunction function, BapiTransactionHandling bapiTransactionHandling, JCoFunction bapiTransactionRollback, JCoFunction bapiTransactionCommit) throws JCoException {
        log.debug("Executing {}...", (Object)function.getName());
        function.execute(destination);
        if (this.hasErrors(function)) {
            log.error("Found errors in the response. Rolling back...");
            this.rollbackTransaction(bapiTransactionRollback, destination);
        } else {
            log.debug("Function {} executed successfully. Performing {}...", (Object)function.getName(), (Object)bapiTransactionHandling);
            if (bapiTransactionCommit == null) {
                log.error("Unable to commit - No '{}' function found.", (Object)BapiFunctions.BAPI_TRANSACTION_COMMIT);
            } else {
                bapiTransactionCommit.execute(destination);
                log.debug("{} finished successfully.", (Object)bapiTransactionHandling);
            }
        }
    }

    @VisibleForTesting
    protected boolean hasErrors(JCoFunction function) {
        JCoTable response = RfmParameterMapper.getTableParameter("RETURN", function);
        if (response != null) {
            JCoTable returnTable = response;
            for (int i = 0; i < returnTable.getNumRows(); ++i) {
                returnTable.setRow(i);
                if (!this.hasErrorType((JCoRecord)returnTable)) continue;
                log.debug("Found error in 'RETURN' table");
                return true;
            }
        }
        if ((response = RfmParameterMapper.getStructureParameter("RETURN", function)) != null && this.hasErrorType((JCoRecord)response)) {
            log.debug("Found error in 'RETURN' structure");
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected boolean hasErrorType(JCoRecord record) {
        JCoField type = record.getField("TYPE");
        if (type != null) {
            if (type.getClassNameOfValue().equals(STRING_CLASS_PATH)) {
                return type.getString().equals("E");
            }
            log.error("Failed to validate field 'TYPE', expected String, got '{}'.", (Object)type.getClassNameOfValue());
        }
        return false;
    }

    private void rollbackTransaction(JCoFunction bapiTransactionRollback, JCoDestination destination) throws JCoException {
        if (bapiTransactionRollback == null) {
            log.error("Unable to rollback - No '{}' function found.", (Object)BapiFunctions.BAPI_TRANSACTION_ROLLBACK);
        } else {
            bapiTransactionRollback.execute(destination);
            log.debug("Rollback successful.");
        }
    }

    @Nullable
    private RfcExecutionErrorResponse prepareFunction(SapRfcRequest request, JCoFunction function) {
        if (function == null) {
            String errorMessage = "Could not find RFM named " + request.getRfmName();
            log.error(errorMessage);
            return new RfcExecutionErrorResponse(RfcExecutionErrorKey.RFM_NOT_FOUND.name(), errorMessage);
        }
        try {
            RfmParameterMapper.mapAllParameters(request.getRfmParams(), function);
        }
        catch (RfcExecutionException rfcExecutionException) {
            log.error("Execution failed. {}", (Object)rfcExecutionException.getMessage());
            log.debug("Error details:", (Throwable)rfcExecutionException);
            return new RfcExecutionErrorResponse(rfcExecutionException.getKey(), rfcExecutionException.getMessage(), rfcExecutionException.getDetails());
        }
        return null;
    }
}

