/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.system;

import cloud.celonis.agent.common.loader.AgentLoaderProperties;
import cloud.celonis.saprfc.exception.JCoLoadingException;
import cloud.celonis.saprfc.system.JCoNativeLibraryLoader;
import cloud.celonis.saprfc.system.RfcDestinationProvider;
import cloud.celonis.saprfc.system.SapDestinationManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCoLoader {
    private static final Logger log = LoggerFactory.getLogger(JCoLoader.class);
    private final AgentLoaderProperties loaderProperties;
    private final JCoNativeLibraryLoader jcoNativeLibraryLoader;
    private final List<String> errors = new ArrayList<String>();
    private RfcDestinationProvider rfcDestinationProvider;
    @VisibleForTesting
    protected static String jcoClassProbe = "com.sap.conn.jco.JCo";

    public JCoLoader(AgentLoaderProperties loaderProperties, JCoNativeLibraryLoader jcoNativeLibraryLoader) {
        this.loaderProperties = loaderProperties;
        this.jcoNativeLibraryLoader = jcoNativeLibraryLoader;
        this.setUp();
    }

    public synchronized RfcDestinationProvider getDestinationProvider() {
        return this.rfcDestinationProvider;
    }

    public boolean hasErrors(boolean shouldLog) {
        if (shouldLog && !this.errors.isEmpty()) {
            log.info("Execution Failed. JCo has not been loaded, please fix the following issues and then try again");
            this.errors.forEach(arg_0 -> ((Logger)log).error(arg_0));
        }
        return !this.errors.isEmpty();
    }

    public void addError(String errorMessage) {
        this.errors.add(errorMessage);
    }

    private void setUp() {
        try {
            log.info("Checking if sapjco3 is on the class path");
            this.loadClassProbe();
            log.info("Checking if the native JCo library has been provided");
            this.checkIfNativeLibraryExistsAndSetPath();
            if (!this.hasErrors(false)) {
                log.info("Creating JCo destination provider");
                this.createDestinationProvider();
            }
            if (this.hasErrors(false)) {
                log.error("Failed to load JCo. SAP Automations will not be possible.");
            } else {
                log.info("JCo successfully loaded");
            }
        }
        catch (Exception e) {
            log.error("Unexpected error {}", (Object)e.getMessage());
            this.errors.add(e.getMessage());
            log.error("Failed to load JCo. SAP Automations will not be possible.");
        }
    }

    private void loadClassProbe() {
        try {
            Class.forName(jcoClassProbe, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                this.addErrorAndLog(String.format("SAP JCo not found on classpath, ensure 'sapjco3.jar' exists in '%s'", new File(this.loaderProperties.getJCoPath()).getCanonicalPath()));
            }
            catch (IOException ioException) {
                log.debug("Error encountered when logging canonical path", (Throwable)ioException);
                this.addErrorAndLog(String.format("SAP JCo not found on classpath, ensure 'sapjco3.jar' exists in '%s'", new File(this.loaderProperties.getJCoPath()).getAbsolutePath()));
            }
        }
    }

    private void checkIfNativeLibraryExistsAndSetPath() {
        try {
            this.jcoNativeLibraryLoader.checkIfLibraryExistsAndSetPath(this.loaderProperties.getJCoPath());
        }
        catch (JCoLoadingException e) {
            this.addErrorAndLog(e.getMessage());
        }
    }

    private void createDestinationProvider() {
        try {
            this.rfcDestinationProvider = new RfcDestinationProvider(new SapDestinationManager());
        }
        catch (ExceptionInInitializerError e) {
            this.addErrorAndLog(e.getMessage());
        }
    }

    private void addErrorAndLog(String errorMessage) {
        log.error(errorMessage);
        this.errors.add(errorMessage);
    }

    @VisibleForTesting
    protected int getErrorsSize() {
        return this.errors.size();
    }
}

