/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.system;

import cloud.celonis.saprfc.exception.JCoLoadingException;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="connectors.sap-rfc", name={"enabled"}, havingValue="true")
public class JCoNativeLibraryLoader {
    private static final Logger log = LoggerFactory.getLogger(JCoNativeLibraryLoader.class);
    @VisibleForTesting
    protected boolean isWindows = SystemUtils.IS_OS_WINDOWS;
    @VisibleForTesting
    protected boolean isLinux = SystemUtils.IS_OS_LINUX;
    @VisibleForTesting
    protected boolean isMacOs = SystemUtils.IS_OS_MAC;
    private static final String MAC_LIB = "libsapjco3.dylib";
    private static final String WINDOWS_LIB = "sapjco3.dll";
    private static final String LINUX_LIB = "libsapjco3.so";

    public void checkIfLibraryExistsAndSetPath(String jCoLoaderPath) throws JCoLoadingException {
        log.info("Loading native SAP library..");
        String expectedLibName = this.getExpectedLibName();
        File libDir = new File(jCoLoaderPath);
        File expectedLibFile = new File(libDir, expectedLibName);
        log.info("Checking if JCo native library '{}' exists", (Object)expectedLibFile);
        if (!expectedLibFile.exists()) {
            try {
                throw new JCoLoadingException(String.format("SAP JCo native library not found in: '%s'", expectedLibFile.getCanonicalPath()));
            }
            catch (IOException e) {
                log.debug("Encountered error when logging canonical path", (Throwable)e);
                throw new JCoLoadingException(String.format("SAP JCo native library not found in '%s'", expectedLibFile.getAbsolutePath()));
            }
        }
        System.setProperty("java.library.path", libDir.getAbsolutePath());
        log.info("Java library path set to '{}'", (Object)libDir.getAbsolutePath());
    }

    private String getExpectedLibName() throws JCoLoadingException {
        if (this.isWindows) {
            log.info("Windows detected");
            return WINDOWS_LIB;
        }
        if (this.isLinux) {
            log.info("Linux detected");
            return LINUX_LIB;
        }
        if (this.isMacOs) {
            log.info("macOS detected");
            return MAC_LIB;
        }
        throw new JCoLoadingException("Unsupported operating system for SAP JCo native library: " + SystemUtils.OS_NAME);
    }
}

