/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.system;

import cloud.celonis.commons.exception.NotImplementedException;
import cloud.celonis.saprfc.exception.JCoLoadingException;
import cloud.celonis.saprfc.system.CachedRfcDestination;
import cloud.celonis.saprfc.system.SapDestinationManager;
import cloud.celonis.saprfc.system.SapRfcDestinationProperties;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RfcDestinationProvider
implements DestinationDataProvider {
    private static final Logger log = LoggerFactory.getLogger(RfcDestinationProvider.class);
    private static final String JCO_SELECTED_LANGUAGE_NOT_INSTALLED = "171";
    private DestinationDataEventListener destinationDataEventListener;
    private final SapDestinationManager sapDestinationManager;
    private final LoadingCache<String, CachedRfcDestination> destinations = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.DAYS).removalListener(notification -> {
        log.debug("Destination '{}' removed from cache after not being used for 2 days", notification.getKey());
        this.destinationDataEventListener.deleted((String)notification.getKey());
    }).build((CacheLoader)new CacheLoader<String, CachedRfcDestination>(){

        public CachedRfcDestination load(@NotNull String ignored) {
            throw new NotImplementedException();
        }
    });

    public RfcDestinationProvider(SapDestinationManager sapDestinationManager) {
        this.sapDestinationManager = sapDestinationManager;
        JCo.setMiddlewareProperty((String)"jrfc.client_connect_timeout", (String)"60");
        if (!Environment.isDestinationDataProviderRegistered()) {
            Environment.registerDestinationDataProvider((DestinationDataProvider)this);
        }
    }

    public Properties getDestinationProperties(String destinationName) {
        CachedRfcDestination cachedRfcDestination = (CachedRfcDestination)this.destinations.getIfPresent((Object)destinationName);
        if (cachedRfcDestination == null) {
            throw new IllegalArgumentException(String.format("Destination '%s' not found", destinationName));
        }
        return cachedRfcDestination.getProperties();
    }

    public boolean supportsEvents() {
        return true;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener destinationDataEventListener) {
        this.destinationDataEventListener = destinationDataEventListener;
    }

    public synchronized JCoDestination getDestination(SapRfcDestinationProperties connectionProperties) throws JCoException, JCoLoadingException {
        CachedRfcDestination existing = (CachedRfcDestination)this.destinations.getIfPresent((Object)connectionProperties.getEncodedName());
        if (existing != null) {
            log.debug("Returning a cached destination for '{}'", (Object)connectionProperties.getEncodedName());
            return existing.getDestination();
        }
        log.debug("Creating a cached destination for '{}'", (Object)connectionProperties.getEncodedName());
        CachedRfcDestination cachedRfcDestination = new CachedRfcDestination(connectionProperties.getProperties());
        try {
            this.putDestination(cachedRfcDestination, connectionProperties);
            cachedRfcDestination.getDestination().ping();
        }
        catch (JCoException e) {
            if (JCO_SELECTED_LANGUAGE_NOT_INSTALLED.equals(e.getMessageNumber())) {
                connectionProperties.removeProperty("jco.client.lang");
                this.putDestination(cachedRfcDestination, connectionProperties);
                return cachedRfcDestination.getDestination();
            }
            throw e;
        }
        return cachedRfcDestination.getDestination();
    }

    private void putDestination(CachedRfcDestination cachedRfcDestination, SapRfcDestinationProperties connectionProperties) throws JCoException, JCoLoadingException {
        try {
            this.destinations.put((Object)connectionProperties.getEncodedName(), (Object)cachedRfcDestination);
            cachedRfcDestination.setDestination(this.sapDestinationManager.getDestination(connectionProperties));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.destinations.invalidate((Object)connectionProperties.getEncodedName());
            throw new JCoLoadingException("Visual 2013 C++ Redistributable Package is required to run Celonis Agent. Please install it on your agent server");
        }
        catch (JCoException jCoException) {
            this.destinations.invalidate((Object)connectionProperties.getEncodedName());
            throw jCoException;
        }
    }
}

