/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.system;

import cloud.celonis.saprfc.domain.RfcDestinationParameters;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SapRfcDestinationProperties {
    private final Properties properties = new Properties();
    private final String encodedName;

    public SapRfcDestinationProperties(RfcDestinationParameters destinationParams) {
        this.properties.setProperty("jco.client.client", destinationParams.getClient());
        this.properties.setProperty("jco.client.user", destinationParams.getUser());
        this.properties.setProperty("jco.client.passwd", destinationParams.getPassword());
        this.properties.setProperty("jco.destination.peak_limit", destinationParams.getConnectionLimit());
        if (destinationParams.isUseConnectionPooling()) {
            this.properties.setProperty("jco.destination.pool_capacity", destinationParams.getPoolCapacity());
        }
        if (StringUtils.isNotBlank((CharSequence)destinationParams.getSapRouter())) {
            this.properties.setProperty("jco.client.saprouter", destinationParams.getSapRouter());
        }
        if (StringUtils.isNotBlank((CharSequence)destinationParams.getSystemId())) {
            this.properties.setProperty("jco.client.r3name", destinationParams.getSystemId());
        }
        if (StringUtils.isNotBlank((CharSequence)destinationParams.getLang())) {
            this.properties.setProperty("jco.client.lang", destinationParams.getLang());
        }
        if (destinationParams.isUsePiPo()) {
            this.properties.setProperty("jco.client.type", "E");
            this.properties.setProperty("jco.client.gwhost", destinationParams.getGatewayServerHost());
            this.properties.setProperty("jco.client.gwserv", destinationParams.getGatewayServerPort());
            this.properties.setProperty("jco.client.tpname", destinationParams.getProgramId());
        } else if (destinationParams.isUseLogonGroups()) {
            this.properties.setProperty("jco.client.mshost", destinationParams.getMessageServerHost());
            this.properties.setProperty("jco.client.msserv", destinationParams.getMessageServerPort());
            this.properties.setProperty("jco.client.group", destinationParams.getGroup());
        } else {
            this.properties.setProperty("jco.client.ashost", destinationParams.getApplicationServerHost());
            this.properties.setProperty("jco.client.sysnr", destinationParams.getSystemNumber());
        }
        if (destinationParams.isUseSnc()) {
            if (StringUtils.isNotBlank((CharSequence)destinationParams.getSncLibraryPath())) {
                this.properties.setProperty("jco.client.snc_lib", destinationParams.getSncLibraryPath());
            } else {
                this.properties.setProperty("jco.client.snc_lib", System.getenv("SNC_LIB"));
            }
            this.properties.setProperty("jco.client.snc_mode", "1");
            this.properties.setProperty("jco.client.snc_qop", "9");
            this.properties.setProperty("jco.client.snc_partnername", destinationParams.getSncPartnerName());
            this.properties.setProperty("jco.client.snc_sso", "0");
            if (StringUtils.isNotBlank((CharSequence)destinationParams.getSncMyName())) {
                this.properties.setProperty("jco.client.snc_myname", destinationParams.getSncMyName());
            }
        }
        String propertiesString = this.properties.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining("-"));
        String propertiesHash = Hashing.sha256().hashString((CharSequence)propertiesString, StandardCharsets.UTF_8).toString();
        this.encodedName = String.format("[%s]-[%s]-[%s]-[%s]-[%s]", this.properties.getOrDefault((Object)"jco.client.ashost", this.properties.getOrDefault((Object)"jco.client.mshost", "jco.client.gwhost")), this.properties.getOrDefault((Object)"jco.client.sysnr", this.properties.getOrDefault((Object)"jco.client.group", "jco.client.tpname")), this.properties.get("jco.client.client"), this.properties.get("jco.client.user"), propertiesHash);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getEncodedName() {
        return this.encodedName;
    }

    public void removeProperty(Object key) {
        this.properties.remove(key);
    }
}

