/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.util.error;

import cloud.celonis.saprfc.domain.error.RfcExecutionErrorResponse;
import com.sap.conn.jco.JCoException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RfcExecutionErrorUtils {
    private static final String PARAM_SEPARATOR = ", ";
    private static final String KEY_SEPARATOR = ": ";

    private RfcExecutionErrorUtils() {
    }

    public static RfcExecutionErrorResponse buildErrorResponse(JCoException jCoException) {
        RfcExecutionErrorResponse errorResponse = new RfcExecutionErrorResponse();
        errorResponse.setKey(RfcExecutionErrorUtils.buildErrorKey(jCoException));
        if (errorResponse.getKey() == null) {
            errorResponse.setKey(jCoException.getKey());
        }
        if (jCoException.getCause() != null && StringUtils.isNotBlank((CharSequence)jCoException.getCause().getMessage())) {
            errorResponse.setMessage(jCoException.getCause().getMessage());
        } else {
            errorResponse.setMessage(jCoException.getMessage());
        }
        errorResponse.setDetails(jCoException.toString());
        return errorResponse;
    }

    private static String buildErrorKey(JCoException jCoException) {
        String parameters;
        String errorKey = jCoException.getKey();
        if (jCoException.getMessageParameters() != null && ArrayUtils.isNotEmpty((Object[])jCoException.getMessageParameters()) && StringUtils.isNotBlank((CharSequence)(parameters = Arrays.stream(jCoException.getMessageParameters()).filter(StringUtils::isNotBlank).collect(Collectors.joining(PARAM_SEPARATOR))))) {
            errorKey = String.join((CharSequence)KEY_SEPARATOR, errorKey, parameters);
        }
        return errorKey;
    }
}

