/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.filedownloader.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.filedownloader.config.FileDownloaderConfig;
import cloud.celonis.filedownloader.exception.FailedReadingFileException;
import cloud.celonis.filedownloader.model.FileDownloaderRequest;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="file-downloader")
@ConditionalOnProperty(prefix="connectors.file-downloader", name={"enabled"}, havingValue="true")
public class FileDownloaderConnector
extends ConnectorBase<FileDownloaderRequest> {
    private static final Logger log = LoggerFactory.getLogger(FileDownloaderConnector.class);
    private static final String WHITELISTING_GUIDE = "To whitelist, add the full path or only the parent directory to the 'connectors.file-downloader.config.paths' configuration in the application.yml. Restart is necessary after changing the configuration.";
    private final FileDownloaderConfig fileDownloaderConfig;

    public FileDownloaderConnector(FileDownloaderConfig fileDownloaderConfig) {
        this.fileDownloaderConfig = fileDownloaderConfig;
    }

    protected ResponseEntity<String> execute(FileDownloaderRequest fileDownloaderRequest) {
        if (this.fileDownloaderConfig.getPaths().isEmpty()) {
            log.info("No paths have been whitelisted. {}", (Object)WHITELISTING_GUIDE);
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        Path filePath = Paths.get(fileDownloaderRequest.getPath(), new String[0]);
        return this.downloadContentFromFiles(filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseEntity<String> downloadContentFromFiles(Path path) {
        ArrayList<String> fileContent = new ArrayList<String>();
        try (Stream<Path> fileStreams = Files.walk(Paths.get("", new String[0]), new FileVisitOption[0]);){
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s", SystemUtils.IS_OS_WINDOWS ? StringUtils.replace((String)path.toString(), (String)File.separator, (String)"/") : path));
            List<File> files = fileStreams.filter(filePath -> pathMatcher.matches((Path)filePath) && this.verifyPath(filePath.normalize(), this.fileDownloaderConfig.getPaths())).map(Path::toFile).collect(Collectors.toList());
            if (files.isEmpty()) {
                log.info(String.format("No files found for: %s.", path));
                ResponseEntity responseEntity = ResponseEntity.notFound().build();
                return responseEntity;
            }
            this.readLinesFromFiles(files, fileContent);
        }
        catch (Exception exception) {
            log.error("Something went wrong while downloading files. " + exception);
            return ResponseEntity.badRequest().body((Object)exception.getMessage());
        }
        log.info("Content has been downloaded successfully!");
        return ResponseEntity.ok((Object)String.join((CharSequence)"\n", fileContent));
    }

    private void readLinesFromFiles(List<File> files, List<String> fileContent) {
        Collections.sort(files);
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    this.readLinesFromFiles(Lists.newArrayList((Object[])file.listFiles((dir, name) -> true)), fileContent);
                    continue;
                }
                fileContent.addAll(Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
            }
            catch (IOException exception) {
                log.error("Something went wrong while reading file " + file.getName());
                throw new FailedReadingFileException(file.getPath(), exception);
            }
        }
    }

    private boolean verifyPath(Path child, List<String> filePaths) {
        boolean isWhiteListed = filePaths.stream().anyMatch(parentText -> {
            Path parent = Paths.get(parentText, new String[0]).normalize();
            return child.startsWith(parent);
        });
        if (!isWhiteListed) {
            log.warn("Path '{}' is not whitelisted. {}", (Object)child, (Object)WHITELISTING_GUIDE);
        }
        return isWhiteListed;
    }
}

