/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.secret.resolver.system;

import cloud.celonis.secret.resolver.system.SecretProviderLoaderProperties;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretProviderJarLoader {
    private static final Logger log = LoggerFactory.getLogger(SecretProviderJarLoader.class);
    private final SecretProviderLoaderProperties loaderProperties;
    private final List<String> errors = new ArrayList<String>();
    private final String secretProviderClassProbe;
    private final String secretProviderName;
    private final String secretProviderJarName;

    public SecretProviderJarLoader(SecretProviderLoaderProperties loaderProperties, String secretProviderClassProbe, String secretProviderName, String secretProviderJarName) {
        this.loaderProperties = loaderProperties;
        this.secretProviderClassProbe = secretProviderClassProbe;
        this.secretProviderName = secretProviderName;
        this.secretProviderJarName = secretProviderJarName;
        this.setUp();
    }

    private void setUp() {
        log.info("Checking if {} class for {} provider is on the class path", (Object)this.secretProviderClassProbe, (Object)this.secretProviderName);
        this.loadClassProbe();
        if (this.hasErrors(false)) {
            log.error("Failed to load {}. Automations with {} will not be possible.", (Object)this.secretProviderClassProbe, (Object)this.secretProviderName);
        } else {
            log.info("{} class for {} provider successfully loaded", (Object)this.secretProviderClassProbe, (Object)this.secretProviderName);
        }
    }

    private void loadClassProbe() {
        try {
            Class.forName(this.secretProviderClassProbe, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                this.addErrorAndLog(String.format("%s class for %s not found on classpath, ensure '%s' exists in '%s'", this.secretProviderClassProbe, this.secretProviderName, this.secretProviderJarName, new File(this.loaderProperties.getSecretResolversAndProvidersPath()).getCanonicalPath()));
            }
            catch (IOException ioException) {
                log.debug("Error encountered when logging canonical path", (Throwable)ioException);
                this.addErrorAndLog(String.format("%s class for %s provider not found on classpath, ensure '%s' exists in '%s'", this.secretProviderClassProbe, this.secretProviderName, this.secretProviderJarName, new File(this.loaderProperties.getSecretResolversAndProvidersPath()).getAbsolutePath()));
            }
        }
    }

    private void addErrorAndLog(String errorMessage) {
        log.error(errorMessage);
        this.errors.add(errorMessage);
    }

    public boolean hasErrors(boolean shouldLog) {
        if (shouldLog && !this.errors.isEmpty()) {
            log.info("Execution Failed. {} class for {} provider has not been loaded, please fix the following issues and then try again", (Object)this.secretProviderClassProbe, (Object)this.secretProviderName);
            this.errors.forEach(arg_0 -> ((Logger)log).error(arg_0));
        }
        return !this.errors.isEmpty();
    }

    @VisibleForTesting
    protected int getErrorsSize() {
        return this.errors.size();
    }
}

