/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.secret.resolver.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Component;

@Component
public class SecretProviderLoaderProperties {
    private static final Logger log = LoggerFactory.getLogger(SecretProviderLoaderProperties.class);
    private String secretResolversAndProvidersPath;

    @PostConstruct
    public void init() throws IOException {
        Properties properties;
        File file = new File("loader.properties");
        if (file.exists()) {
            properties = new Properties();
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
        } else {
            properties = PropertiesLoaderUtils.loadAllProperties((String)"loader.properties");
            PropertySourcesPlaceholderConfigurer propertiesConfigurer = new PropertySourcesPlaceholderConfigurer();
            propertiesConfigurer.setProperties(properties);
        }
        String[] paths = properties.getProperty("loader.path").split(",");
        this.secretResolversAndProvidersPath = paths[2];
        log.info("'secretResolversLoaderPath' and 'secretProvidersLoaderPath' are set to '{}'", (Object)this.secretResolversAndProvidersPath);
    }

    public String getSecretResolversAndProvidersPath() {
        return this.secretResolversAndProvidersPath;
    }
}

