/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher.setup;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.CrawlSetupException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import androidx.test.tools.crawler.launcher.setup.ExternalCrawlSetup;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class CrawlSetupProvider {
    public static CrawlSetup getCrawlSetup() {
        Logger.setConsoleMode(true);
        String internalWorkingDirectory = "";
        try {
            Process checkInternalRun = Runtime.getRuntime().exec(new String[]{"g4", "g4d"}, null, new File(System.getProperty("user.dir")));
            try (BufferedReader inputStreamReader = new BufferedReader(new InputStreamReader(checkInternalRun.getInputStream(), StandardCharsets.UTF_8));){
                String line = inputStreamReader.readLine();
                if (line != null && line.trim().startsWith("/google/src/")) {
                    internalWorkingDirectory = line.trim();
                }
            }
            checkInternalRun.waitFor();
        }
        catch (Exception e) {
            Logger.atDebug().withCause(e).log("Exception while detecting the run mode, defaulting to external mode", new Object[0]);
        }
        Logger.atDebug().log("isInternalRun = %s", !internalWorkingDirectory.isEmpty());
        return internalWorkingDirectory.isEmpty() ? new ExternalCrawlSetup() : CrawlSetupProvider.createInternalCrawlSetup(internalWorkingDirectory);
    }

    private static CrawlSetup createInternalCrawlSetup(String internalWorkingDirectory) {
        try {
            return Class.forName("com.google.android.apps.mtaas.crawler.launcher.setup.internal.InternalCrawlSetup").asSubclass(CrawlSetup.class).getDeclaredConstructor(String.class).newInstance(internalWorkingDirectory);
        }
        catch (Exception e) {
            throw new CrawlSetupException("Failed to create internal crawl setup", e);
        }
    }
}

