/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.postprocessing.logcat;

import androidx.test.tools.crawler.postprocessing.logcat.AutoValue_LogcatFinding;
import androidx.test.tools.crawler.postprocessing.logcat.TestCaseTiming;
import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import org.joda.time.Duration;
import org.joda.time.Instant;

@AutoValue
public abstract class LogcatFinding {
    private static final Optional<Duration> NO_START_TIME = Optional.absent();
    private static final Optional<String> NO_STACK_TRACE = Optional.absent();
    private static final Optional<ImmutableList<TestCaseTiming>> NO_INSTRUMENTATION_TIMELINE = Optional.absent();
    private static final Optional<String> NO_NON_SDK_API_SIGNATURE = Optional.absent();
    private static final Optional<String> NO_NON_SDK_API_CALLER = Optional.absent();

    public static LogcatFinding createCrashFinding(LogcatFindingType type, int pid, Optional<String> packageName, String message, String stacktrace, Instant timestamp, int lineNumber) {
        return new AutoValue_LogcatFinding(type, pid, packageName, message, timestamp, lineNumber, Optional.of(stacktrace), NO_START_TIME, NO_INSTRUMENTATION_TIMELINE, NO_NON_SDK_API_SIGNATURE, NO_NON_SDK_API_CALLER);
    }

    public static LogcatFinding createStartupTimeFinding(LogcatFindingType type, int pid, String message, Instant timestamp, int lineNumber, Duration startupTime) {
        return new AutoValue_LogcatFinding(type, pid, Optional.absent(), message, timestamp, lineNumber, NO_STACK_TRACE, Optional.of(startupTime), NO_INSTRUMENTATION_TIMELINE, NO_NON_SDK_API_SIGNATURE, NO_NON_SDK_API_CALLER);
    }

    public static LogcatFinding createRoboTestFinding(LogcatFindingType type, Instant timestamp, int lineNumber) {
        return new AutoValue_LogcatFinding(type, 0, Optional.absent(), "", timestamp, lineNumber, NO_STACK_TRACE, NO_START_TIME, NO_INSTRUMENTATION_TIMELINE, NO_NON_SDK_API_SIGNATURE, NO_NON_SDK_API_CALLER);
    }

    public static LogcatFinding createInstrumentationTimelineFinding(LogcatFindingType type, int pid, Instant runStartTimestamp, int runStartLineNumber, ImmutableList<TestCaseTiming> instrumentationTimeline) {
        return new AutoValue_LogcatFinding(type, pid, Optional.absent(), "", runStartTimestamp, runStartLineNumber, NO_STACK_TRACE, NO_START_TIME, Optional.of(instrumentationTimeline), NO_NON_SDK_API_SIGNATURE, NO_NON_SDK_API_CALLER);
    }

    public static LogcatFinding createNonSdkApiUsedFinding(int pid, String message, String stacktrace, Instant timestamp, int lineNumber, String apiSignature, Optional<String> caller) {
        return new AutoValue_LogcatFinding(LogcatFindingType.NON_SDK_API_USED, pid, Optional.absent(), message, timestamp, lineNumber, Optional.of(stacktrace), NO_START_TIME, NO_INSTRUMENTATION_TIMELINE, Optional.of(apiSignature), caller);
    }

    public static LogcatFinding createStartProcFinding(int pid, String packageName, Instant timestamp, int lineNumber) {
        return new AutoValue_LogcatFinding(LogcatFindingType.START_PROC, pid, Optional.of(packageName), "", timestamp, lineNumber, NO_STACK_TRACE, NO_START_TIME, NO_INSTRUMENTATION_TIMELINE, NO_NON_SDK_API_SIGNATURE, NO_NON_SDK_API_CALLER);
    }

    public abstract LogcatFindingType type();

    public abstract int pid();

    public abstract Optional<String> packageName();

    public abstract String message();

    public abstract Instant timestamp();

    public abstract int lineNumber();

    public abstract Optional<String> stacktrace();

    public abstract Optional<Duration> startupTime();

    public abstract Optional<ImmutableList<TestCaseTiming>> instrumentationTimeline();

    public abstract Optional<String> nonSdkApiSignature();

    public abstract Optional<String> nonSdkApiCaller();

    public static enum LogcatFindingType {
        FATAL_EXCEPTION,
        NATIVE_CRASH,
        MONITORING_INSTR_EXCEPTION,
        STARTUP_TIME_DEFAULT,
        STARTUP_TIME_FULLY_DRAWN,
        ROBO_TEST_COMPLETED,
        LOW_MEMORY_KILLED,
        INSTRUMENTATION_TIMELINE,
        NON_SDK_API_USED,
        START_PROC;

    }
}

