/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CommandNotFoundException;
import com.android.cts.UnknownCommandException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandParser {
    private HashMap<String, String> mValues = new HashMap();
    private String mAction;
    private ArrayList<String> mActionValues = new ArrayList();
    private int mArgLength;
    private static final String COMMAND_PARSE_EXPRESSION = "(((\\\\\\s)|[\\S&&[^\"]])+|\".+\")";
    private static Set<String> sOptionsSet = new HashSet<String>(Arrays.asList("--config", "--package", "--plan", "--device", "--result", "-e", "--session", "--test", "--derivedplan"));
    private static HashMap<String, String> sOptionMap = new HashMap();

    public static CommandParser parse(String line) throws UnknownCommandException, CommandNotFoundException {
        ArrayList<String> arglist = new ArrayList<String>();
        Pattern p = Pattern.compile(COMMAND_PARSE_EXPRESSION);
        Matcher m = p.matcher(line);
        while (m.find()) {
            arglist.add(m.group(1));
        }
        CommandParser cp = new CommandParser();
        if (arglist.size() == 0) {
            throw new CommandNotFoundException("No command");
        }
        cp.parse(arglist);
        return cp;
    }

    private void parse(ArrayList<String> arglist) throws UnknownCommandException {
        this.mArgLength = arglist.size();
        int currentArgIndex = 0;
        this.mAction = arglist.get(currentArgIndex).toLowerCase();
        String originalOption = null;
        String option = null;
        while (++currentArgIndex < arglist.size()) {
            originalOption = arglist.get(currentArgIndex).trim();
            if (originalOption.startsWith("-")) {
                if (this.isNumber(originalOption)) {
                    this.mActionValues.add(originalOption);
                    continue;
                }
                --currentArgIndex;
                break;
            }
            this.mActionValues.add(originalOption);
        }
        while (++currentArgIndex < arglist.size()) {
            String value;
            originalOption = arglist.get(currentArgIndex).trim().toLowerCase();
            option = originalOption;
            if (!option.startsWith("-")) {
                throw new UnknownCommandException("Option should start with '-'");
            }
            if (!sOptionsSet.contains(option = this.inputToOption(option))) {
                throw new UnknownCommandException("Unknown option :" + originalOption);
            }
            if (this.mValues.containsKey(option)) {
                throw new UnknownCommandException("Duplicate option: " + originalOption);
            }
            if (currentArgIndex + 1 == arglist.size()) {
                this.mValues.put(option, "");
                continue;
            }
            if ((value = arglist.get(++currentArgIndex).trim()).startsWith("-") && !this.isNumber(value)) {
                value = "";
                --currentArgIndex;
            }
            this.mValues.put(option, value);
        }
    }

    private String inputToOption(String option) throws UnknownCommandException {
        String op = sOptionMap.get(option);
        if (op == null) {
            throw new UnknownCommandException("Unknow option " + option);
        }
        return op;
    }

    private boolean isNumber(String option) {
        try {
            Integer.parseInt(option);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getArgSize() {
        return this.mArgLength;
    }

    public String getAction() {
        return this.mAction;
    }

    public int getOptionSize() {
        return this.mValues.size();
    }

    public String getValue(String key) {
        if (this.mValues.containsKey(key)) {
            return this.mValues.get(key);
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.mValues.containsKey(key);
    }

    public Set<String> getOptionKeys() {
        return this.mValues.keySet();
    }

    public ArrayList<String> getActionValues() {
        return this.mActionValues;
    }

    public void removeKey(String key) {
        this.mValues.remove(key);
    }

    static {
        String[] keys = new String[]{"--config", "-p", "--package", "--plan", "-d", "--device", "-r", "--result", "-e", "-s", "--session", "-t", "--test", "--derivedplan"};
        String[] values = new String[]{"--config", "--package", "--package", "--plan", "--device", "--device", "--result", "--result", "-e", "--session", "--session", "--test", "--test", "--derivedplan"};
        for (int i = 0; i < keys.length; ++i) {
            sOptionMap.put(keys[i], values[i]);
        }
    }
}

