/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.InvalidTestResultStringException;
import java.util.Enumeration;
import java.util.HashMap;
import junit.framework.TestFailure;
import junit.framework.TestResult;

public class CtsTestResult {
    private int mResultCode;
    private String mFailedMessage;
    private String mStackTrace;
    public static final int CODE_INIT = -1;
    public static final int CODE_NOT_EXECUTED = 0;
    public static final int CODE_PASS = 1;
    public static final int CODE_FAIL = 2;
    public static final int CODE_ERROR = 3;
    public static final int CODE_TIMEOUT = 4;
    public static final int CODE_OMITTED = 5;
    public static final int CODE_FIRST = -1;
    public static final int CODE_LAST = 5;
    public static final String STR_ERROR = "error";
    public static final String STR_TIMEOUT = "timeout";
    public static final String STR_NOT_EXECUTED = "notExecuted";
    public static final String STR_OMITTED = "omitted";
    public static final String STR_FAIL = "fail";
    public static final String STR_PASS = "pass";
    private static HashMap<Integer, String> sCodeToResultMap = new HashMap();
    private static HashMap<String, Integer> sResultToCodeMap;

    public CtsTestResult(int resCode) {
        this.mResultCode = resCode;
    }

    public CtsTestResult(int resCode, String failedMessage, String stackTrace) {
        this.mResultCode = resCode;
        this.mFailedMessage = failedMessage;
        this.mStackTrace = stackTrace;
    }

    public CtsTestResult(String result, String failedMessage, String stackTrace) throws InvalidTestResultStringException {
        if (!sResultToCodeMap.containsKey(result)) {
            throw new InvalidTestResultStringException(result);
        }
        this.mResultCode = sResultToCodeMap.get(result);
        this.mFailedMessage = failedMessage;
        this.mStackTrace = stackTrace;
    }

    public boolean isFail() {
        return this.mResultCode == 2;
    }

    public boolean isPass() {
        return this.mResultCode == 1;
    }

    public boolean isNotExecuted() {
        return this.mResultCode == 0;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public String getFailedMessage() {
        return this.mFailedMessage;
    }

    public String getStackTrace() {
        return this.mStackTrace;
    }

    public void setResult(TestResult testResult) {
        int resCode = 1;
        String failedMessage = null;
        String stackTrace = null;
        if (testResult != null && (testResult.failureCount() > 0 || testResult.errorCount() > 0)) {
            resCode = 2;
            Enumeration failures = testResult.failures();
            while (failures.hasMoreElements()) {
                TestFailure failure = (TestFailure)failures.nextElement();
                failedMessage = failedMessage + failure.exceptionMessage();
                stackTrace = stackTrace + failure.trace();
            }
            Enumeration errors = testResult.errors();
            while (errors.hasMoreElements()) {
                TestFailure failure = (TestFailure)errors.nextElement();
                failedMessage = failedMessage + failure.exceptionMessage();
                stackTrace = stackTrace + failure.trace();
            }
        }
        this.mResultCode = resCode;
        this.mFailedMessage = failedMessage;
        this.mStackTrace = stackTrace;
    }

    public void reverse() {
        if (this.isPass()) {
            this.mResultCode = 2;
        } else if (this.isFail()) {
            this.mResultCode = 1;
        }
    }

    public String getResultString() {
        return sCodeToResultMap.get(this.mResultCode);
    }

    public static boolean isValidResultType(String resultType) {
        return sResultToCodeMap.containsKey(resultType);
    }

    static {
        sCodeToResultMap.put(0, STR_NOT_EXECUTED);
        sCodeToResultMap.put(1, STR_PASS);
        sCodeToResultMap.put(2, STR_FAIL);
        sCodeToResultMap.put(3, STR_ERROR);
        sCodeToResultMap.put(4, STR_TIMEOUT);
        sCodeToResultMap.put(5, STR_OMITTED);
        sResultToCodeMap = new HashMap();
        for (int code : sCodeToResultMap.keySet()) {
            sResultToCodeMap.put(sCodeToResultMap.get(code), code);
        }
    }
}

