/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.Log;
import java.util.Timer;
import java.util.TimerTask;

public class HostTimer {
    private static final int INIT = 0;
    private static final int RUNNING = 1;
    private static final int CANCELLED = 2;
    private static final int TIMEOUT = 3;
    private boolean mIsNotified;
    private int mStatus;
    private int mDelay;
    private TimerTask mTimerTask;
    private Timer mTimer;

    public HostTimer(TimerTask task, int delay) {
        this.mDelay = delay;
        this.mTimerTask = task;
        this.mStatus = 0;
        this.mIsNotified = false;
        this.mTimer = null;
    }

    public void setNotified() {
        this.mIsNotified = true;
    }

    public boolean isNotified() {
        return this.mIsNotified;
    }

    public void resetNotified() {
        this.mIsNotified = false;
    }

    public void waitOn() throws InterruptedException {
        Log.d("HostTimer.waitOn(): mIsNotified=" + this.mIsNotified + ", this=" + this);
        if (!this.mIsNotified) {
            this.wait();
        }
        this.mIsNotified = false;
    }

    public void setDelay(int delay) {
        this.mDelay = delay;
    }

    public void setTimerTask(TimerTask task) {
        this.mTimerTask = task;
    }

    public boolean isTimeOut() {
        return this.mStatus == 3;
    }

    public void start() {
        this.mTimer = new Timer();
        this.mTimer.schedule(this.mTimerTask, this.mDelay);
        this.mStatus = 1;
    }

    public void restart(TimerTask task, int delay) {
        this.mTimer.cancel();
        this.mTimerTask = task;
        this.mDelay = delay;
        this.start();
    }

    public void sendNotify() {
        Log.d("HostTimer.sendNotify(): mIsNotified=" + this.mIsNotified + ", this=" + this);
        this.mIsNotified = true;
        this.notify();
    }

    public void cancel(boolean timeout) {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        if (this.mStatus == 1) {
            this.mStatus = timeout ? 3 : 2;
        }
    }
}

