/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.ADBServerNeedRestartException;
import com.android.cts.CUIOutputStream;
import com.android.cts.CtsTestResult;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceObserver;
import com.android.cts.HostConfig;
import com.android.cts.HostTimer;
import com.android.cts.Log;
import com.android.cts.ProgressObserver;
import com.android.cts.TestCase;
import com.android.cts.TestController;
import com.android.cts.TestDevice;
import com.android.cts.TestPackage;
import com.android.cts.TestSession;
import com.android.cts.TestSuite;
import java.util.TimerTask;

public class Test
implements DeviceObserver {
    public static final String METHOD_SEPARATOR = "#";
    private TestController mTestController;
    private TestCase mParentCase;
    private String mName;
    private String mType;
    private String mKnownFailure;
    private long mStartTime;
    private long mEndTime;
    protected boolean mTestStop;
    protected TestDevice mDevice;
    protected HostTimer mTimeOutTimer;
    protected ProgressObserver mProgressObserver;
    protected CtsTestResult mResult;

    public Test(TestCase parentCase, String name, String type, String knownFailure, int resCode) {
        this.mParentCase = parentCase;
        this.mName = name;
        this.mType = type;
        this.mKnownFailure = knownFailure;
        this.mResult = new CtsTestResult(resCode);
        this.mTestController = null;
        this.mProgressObserver = null;
        this.mTestStop = false;
    }

    public boolean isKnownFailure() {
        return this.mKnownFailure != null;
    }

    public String getKnownFailure() {
        return this.mKnownFailure;
    }

    public void setTestController(TestController testController) {
        this.mTestController = testController;
    }

    public TestController getTestController() {
        return this.mTestController;
    }

    public String getInstrumentationRunner() {
        TestPackage pkg = this.mParentCase.getParent().getParent();
        return pkg.getInstrumentationRunner();
    }

    public String getName() {
        return this.mName;
    }

    public String getType() {
        return this.mType;
    }

    public TestCase getTestCase() {
        return this.mParentCase;
    }

    public TestSuite getTestSuite() {
        return this.mParentCase.getParent();
    }

    public TestPackage getTestPackage() {
        return this.mParentCase.getParent().getParent();
    }

    public String getAppNameSpace() {
        TestPackage pkg = this.mParentCase.getParent().getParent();
        return pkg.getAppNameSpace();
    }

    public String getFullName() {
        TestSuite suite = this.mParentCase.getParent();
        return suite.getFullName() + "." + this.mParentCase.getName() + METHOD_SEPARATOR + this.mName;
    }

    public void setResult(CtsTestResult result) {
        if (this.isKnownFailure()) {
            result.reverse();
        }
        this.mResult = result;
        CUIOutputStream.println("(" + this.mResult.getResultString() + ")");
        if (!this.mResult.isPass()) {
            String failedMessage = result.getFailedMessage();
            String stackTrace = result.getStackTrace();
            if (failedMessage != null) {
                CUIOutputStream.println(failedMessage);
            }
            if (stackTrace != null) {
                CUIOutputStream.println(stackTrace);
            }
        }
        this.setEndTime(System.currentTimeMillis());
        TestSession.ResultObserver.getInstance().notifyUpdate();
    }

    public void addResult(CtsTestResult result) {
        if (this.isKnownFailure()) {
            result.reverse();
        }
        this.mResult = result;
    }

    public CtsTestResult getResult() {
        return this.mResult;
    }

    public void setStartTime(long time) {
        this.mStartTime = time;
    }

    public void setEndTime(long time) {
        this.mEndTime = time;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    protected void print(String msg) {
        if (!this.mTestStop) {
            CUIOutputStream.print(msg);
        }
    }

    private void killDeviceProcess(String packageName) {
        this.mDevice.killProcess(packageName);
    }

    public void setTestStopped(boolean testStopped) {
        this.mTestStop = testStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestDevice device) throws DeviceDisconnectedException, ADBServerNeedRestartException {
        if (this.getName() == null || this.getName().length() == 0) {
            return;
        }
        if (TestSession.exceedsMaxCount()) {
            throw new ADBServerNeedRestartException("Test count reached overflow point");
        }
        TestSession.incTestCount();
        this.mTestStop = false;
        this.mDevice = device;
        this.mTimeOutTimer = new HostTimer(new TimeOutTask(this), HostConfig.Ints.individualStartTimeoutMs.value());
        this.mTimeOutTimer.start();
        this.mProgressObserver = new ProgressObserver();
        this.mProgressObserver.start();
        this.setStartTime(System.currentTimeMillis());
        String testFullName = this.getFullName();
        this.print(testFullName + "...");
        this.runImpl();
        HostTimer hostTimer = this.mTimeOutTimer;
        synchronized (hostTimer) {
            if (!this.mTestStop) {
                try {
                    this.mTimeOutTimer.waitOn();
                }
                catch (InterruptedException e) {
                    Log.d("time out object interrupted");
                }
            }
            this.mProgressObserver.stop();
            if (this.mTimeOutTimer.isTimeOut()) {
                return;
            }
            this.mTimeOutTimer.cancel(false);
        }
        this.setResult(this.mResult);
    }

    protected void runImpl() throws DeviceDisconnectedException {
        this.mDevice.runTest(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResult(CtsTestResult result) {
        Log.d("Test.notifyResult() is called. (Test.getFullName()=" + this.getFullName());
        this.mResult = result;
        if (this.mTimeOutTimer != null) {
            HostTimer hostTimer = this.mTimeOutTimer;
            synchronized (hostTimer) {
                this.mResult = result;
                Log.d("notifyUpdateResult() detects that it needs to cancel mTimeOutTimer");
                if (this.mTimeOutTimer != null) {
                    this.mTimeOutTimer.sendNotify();
                }
            }
        }
    }

    public void notifyInstallingComplete(int resultCode) {
    }

    public void notifyUninstallingComplete(int resultCode) {
    }

    public void notifyInstallingTimeout(TestDevice testDevice) {
    }

    public void notifyUninstallingTimeout(TestDevice testDevice) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTestingDeviceDisconnected() {
        Log.d("Test.notifyTestingDeviceDisconnected() is called");
        if (this.mProgressObserver != null) {
            this.mProgressObserver.stop();
        }
        if (this.mTimeOutTimer != null) {
            HostTimer hostTimer = this.mTimeOutTimer;
            synchronized (hostTimer) {
                this.mTimeOutTimer.cancel(false);
                this.mTimeOutTimer.sendNotify();
            }
        }
    }

    class TimeOutTask
    extends TimerTask {
        private Test mTest;

        public TimeOutTask(Test testResult) {
            this.mTest = testResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Test.this.mProgressObserver.stop();
            HostTimer hostTimer = Test.this.mTimeOutTimer;
            synchronized (hostTimer) {
                Test.this.mTimeOutTimer.cancel(true);
                Test.this.mTimeOutTimer.sendNotify();
            }
            Log.d("mTimeOutTimer timed out");
            if (!Test.this.mTestStop) {
                this.mTest.setResult(new CtsTestResult(4, null, null));
            }
            Test.this.killDeviceProcess(this.mTest.getAppNameSpace());
        }
    }
}

