/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.ADBServerNeedRestartException;
import com.android.cts.CUIOutputStream;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.HostConfig;
import com.android.cts.IllegalTestNameException;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.SessionObserver;
import com.android.cts.Test;
import com.android.cts.TestDevice;
import com.android.cts.TestNotFoundException;
import com.android.cts.TestPackage;
import com.android.cts.TestSessionLog;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSession {
    private SessionObserver mSessionObserver;
    private TestSessionLog mSessionLog;
    private TestDevice mDevice;
    private int mId;
    private STATUS mStatus = STATUS.INIT;
    private static int sIdCounter = 0;
    private int mRequiredDeviceNumber;
    private boolean mTestStop;
    private TestSessionThread mTestThread;
    private boolean mNeedRestartAdbServer = false;
    private static boolean mADBServerRestartedMode;
    private static long mTestCount;

    public TestSession(TestSessionLog sessionLog, int requiredDeviceNum) {
        mADBServerRestartedMode = false;
        mTestCount = 0L;
        this.mSessionLog = sessionLog;
        this.mDevice = null;
        this.mRequiredDeviceNumber = requiredDeviceNum;
        this.mTestStop = false;
        this.mId = sIdCounter++;
    }

    public static int getLastSessionId() {
        return sIdCounter - 1;
    }

    public static void setADBServerRestartedMode() {
        mADBServerRestartedMode = true;
    }

    public static void resetADBServerRestartedMode() {
        mADBServerRestartedMode = false;
    }

    public static boolean isADBServerRestartedMode() {
        return mADBServerRestartedMode;
    }

    public static void incTestCount() {
        ++mTestCount;
    }

    public static void resetTestCount() {
        mTestCount = 0L;
    }

    public static long getTestCount() {
        return mTestCount;
    }

    public static boolean exceedsMaxCount() {
        long maxTestCount = HostConfig.getMaxTestCount();
        return maxTestCount > 0L && mTestCount >= maxTestCount;
    }

    public STATUS getStatus() {
        return this.mStatus;
    }

    public String getDeviceId() {
        if (this.mDevice == null) {
            return null;
        }
        return this.mDevice.getSerialNumber();
    }

    public TestDevice getDevice() {
        return this.mDevice;
    }

    public int getNumOfRequiredDevices() {
        return this.mRequiredDeviceNumber;
    }

    public int getId() {
        return this.mId;
    }

    public void start(String testFullName) throws TestNotFoundException, IllegalTestNameException, ADBServerNeedRestartException {
        if (testFullName == null || testFullName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!testFullName.matches("(\\w+.)+\\w+")) {
            throw new IllegalTestNameException(testFullName);
        }
        Test test = null;
        TestPackage pkg = null;
        if (-1 != testFullName.indexOf("#")) {
            test = this.searchTest(testFullName);
            if (test == null) {
                throw new TestNotFoundException("The specific test does not exist: " + testFullName);
            }
            this.mTestThread = new TestSessionThread(this, test);
            CUIOutputStream.println("start test " + testFullName);
        } else {
            pkg = this.searchTestPackage(testFullName);
            if (pkg == null) {
                throw new TestNotFoundException("The specific test package does not exist: " + testFullName);
            }
            this.mTestThread = new TestSessionThread(this, pkg, testFullName);
            CUIOutputStream.println("start java package " + testFullName);
        }
        this.mStatus = STATUS.STARTED;
        this.startImpl();
    }

    private void startImpl() throws ADBServerNeedRestartException {
        String resultPath = this.mSessionLog.getResultPath();
        if (resultPath == null || resultPath.length() == 0) {
            this.mSessionLog.setStartTime(System.currentTimeMillis());
        }
        TestSession.resetTestCount();
        this.mTestThread.start();
        try {
            this.mTestThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.mNeedRestartAdbServer && HostConfig.getMaxTestCount() > 0) {
            throw new ADBServerNeedRestartException("Need restart ADB server");
        }
    }

    public void resume() throws ADBServerNeedRestartException {
        this.mStatus = STATUS.RESUMED;
        this.mTestThread = new TestSessionThread(this);
        if (!TestSession.isADBServerRestartedMode()) {
            CUIOutputStream.println("resume test plan " + this.getSessionLog().getTestPlanName() + " (session id = " + this.mId + ")");
        }
        this.startImpl();
    }

    private Test searchTest(String testFullName) {
        TestPackage pkg;
        Test test = null;
        Iterator<TestPackage> i$ = this.mSessionLog.getTestPackages().iterator();
        while (i$.hasNext() && (test = (pkg = i$.next()).searchTest(testFullName)) == null) {
        }
        return test;
    }

    private TestPackage searchTestPackage(String javaPkgName) {
        for (TestPackage pkg : this.mSessionLog.getTestPackages()) {
            Collection<Test> tests = pkg.getTests();
            for (Test test : tests) {
                String testFullName = test.getFullName();
                if (!testFullName.startsWith(javaPkgName)) continue;
                if (testFullName.charAt(javaPkgName.length()) != '.') {
                    javaPkgName = javaPkgName.substring(0, javaPkgName.lastIndexOf("."));
                }
                return pkg;
            }
        }
        return null;
    }

    public void start() throws ADBServerNeedRestartException {
        this.mStatus = STATUS.STARTED;
        this.mSessionLog.setStartTime(System.currentTimeMillis());
        this.mTestThread = new TestSessionThread(this);
        CUIOutputStream.println("start test plan " + this.getSessionLog().getTestPlanName());
        this.startImpl();
    }

    public void setObserver(SessionObserver so) {
        this.mSessionObserver = so;
    }

    private void println(String msg) {
        if (!this.mTestStop) {
            CUIOutputStream.println(msg);
        }
    }

    public void setTestDevice(TestDevice device) {
        this.mDevice = device;
    }

    public TestSessionLog getSessionLog() {
        return this.mSessionLog;
    }

    public Collection<TestPackage> getTestPackages() {
        return this.mSessionLog.getTestPackages();
    }

    static class ResultObserver {
        private static boolean mFinished = false;
        private static boolean mNotified = false;
        private static boolean mNeedUpdate = true;
        private static TestSessionLog mSessionLog;
        static final ResultObserver sInstance;
        private Observer mObserver;

        ResultObserver() {
        }

        public static final ResultObserver getInstance() {
            return sInstance;
        }

        public void setTestSessionLog(TestSessionLog log) {
            mSessionLog = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyUpdate() {
            if (this.mObserver != null) {
                Observer observer = this.mObserver;
                synchronized (observer) {
                    mNotified = true;
                    this.mObserver.notify();
                }
            }
        }

        public void start() {
            mFinished = false;
            mNeedUpdate = true;
            this.mObserver = new Observer();
            this.mObserver.start();
        }

        public void finish() {
            mFinished = true;
            mNeedUpdate = false;
            this.notifyUpdate();
            try {
                this.mObserver.join();
                this.mObserver = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        static {
            sInstance = new ResultObserver();
        }

        class Observer
        extends Thread {
            Observer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!mFinished) {
                    try {
                        Observer observer = this;
                        synchronized (observer) {
                            if (!mNotified && !mFinished) {
                                this.wait();
                            }
                            mNotified = false;
                        }
                        if (!mNeedUpdate || mSessionLog == null) continue;
                        mSessionLog.sessionComplete();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    class TestSessionThread
    extends Thread {
        private final int MSEC_PER_SECOND = 1000;
        private TestSession mTestSession;
        private Test mTest;
        private TestPackage mTestPackage;
        private String mJavaPackageName;
        private ResultObserver mResultObserver;

        public TestSessionThread(TestSession ts) {
            this.mTestSession = ts;
            this.mResultObserver = ResultObserver.getInstance();
        }

        public TestSessionThread(TestSession ts, Test test) {
            this.mTestSession = ts;
            this.mResultObserver = ResultObserver.getInstance();
            this.mTest = test;
        }

        public TestSessionThread(TestSession ts, TestPackage pkg, String javaPkgName) {
            this.mTestSession = ts;
            this.mResultObserver = ResultObserver.getInstance();
            this.mTestPackage = pkg;
            this.mJavaPackageName = javaPkgName;
        }

        public void run() {
            Log.d("Start a test session.");
            TestSession.this.mNeedRestartAdbServer = false;
            this.mResultObserver.setTestSessionLog(TestSession.this.getSessionLog());
            this.mResultObserver.start();
            try {
                if (this.mTest != null) {
                    TestPackage pkg = this.mTest.getTestPackage();
                    pkg.setSessionThread(this);
                    pkg.runTest(TestSession.this.mDevice, this.mTest);
                } else if (this.mTestPackage != null) {
                    this.mTestPackage.setSessionThread(this);
                    this.mTestPackage.run(TestSession.this.mDevice, this.mJavaPackageName, TestSession.this.mSessionLog);
                } else {
                    for (TestPackage pkg : TestSession.this.mSessionLog.getTestPackages()) {
                        if (pkg.isAllTestsRun()) continue;
                        pkg.setSessionThread(this);
                        pkg.run(TestSession.this.mDevice, null, TestSession.this.mSessionLog);
                        if (!this.isAllTestsRun()) {
                            if (HostConfig.getMaxTestCount() <= 0) continue;
                            this.markNeedRestartADBServer();
                            return;
                        }
                        Log.d("All tests have been run.");
                        break;
                    }
                    TestSession.this.mNeedRestartAdbServer = false;
                    this.displayTestResultSummary();
                }
            }
            catch (IOException e) {
                Log.e("Got exception when running the package", e);
            }
            catch (DeviceDisconnectedException e) {
                Log.e("Device " + e.getMessage() + " disconnected ", null);
            }
            catch (ADBServerNeedRestartException e) {
                Log.d(e.getMessage());
                if (this.mTest == null) {
                    this.markNeedRestartADBServer();
                    return;
                }
            }
            catch (InvalidApkPathException e) {
                Log.e(e.getMessage(), null);
            }
            catch (InvalidNameSpaceException e) {
                Log.e(e.getMessage(), null);
            }
            long startTime = TestSession.this.getSessionLog().getStartTime().getTime();
            this.displayTimeInfo(startTime, System.currentTimeMillis());
            TestSession.this.mStatus = STATUS.FINISHED;
            this.mTestSession.getSessionLog().setEndTime(System.currentTimeMillis());
            TestSession.this.mSessionObserver.notifyFinished(this.mTestSession);
            this.notifyResultObserver();
        }

        private void markNeedRestartADBServer() {
            Log.d("mark mNeedRestartAdbServer to true");
            TestSession.this.mNeedRestartAdbServer = true;
            TestSession.this.mStatus = STATUS.FINISHED;
            this.notifyResultObserver();
        }

        private void notifyResultObserver() {
            this.mResultObserver.notifyUpdate();
            this.mResultObserver.finish();
        }

        private boolean isAllTestsRun() {
            Collection<TestPackage> pkgs = TestSession.this.getTestPackages();
            for (TestPackage pkg : pkgs) {
                if (pkg.isAllTestsRun()) continue;
                return false;
            }
            return true;
        }

        private void displayTestResultSummary() {
            int passNum = TestSession.this.mSessionLog.getTestList(1).size();
            int failNum = TestSession.this.mSessionLog.getTestList(2).size();
            int omittedNum = TestSession.this.mSessionLog.getTestList(5).size();
            int notExecutedNum = TestSession.this.mSessionLog.getTestList(0).size();
            int timeOutNum = TestSession.this.mSessionLog.getTestList(4).size();
            int total = passNum + failNum + omittedNum + notExecutedNum + timeOutNum;
            TestSession.this.println("Test summary:   pass=" + passNum + "   fail=" + failNum + "   timeOut=" + timeOutNum + "   omitted=" + omittedNum + "   notExecuted=" + notExecutedNum + "   Total=" + total);
        }

        private void displayTimeInfo(long startTime, long endTime) {
            long diff = endTime - startTime;
            long seconds = diff / 1000L;
            long millisec = diff % 1000L;
            TestSession.this.println("Time: " + seconds + "." + millisec + "s\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STATUS {
        INIT,
        STARTED,
        INSTALLING,
        RUNNING,
        PAUSED,
        RESUMED,
        STOPPED,
        FINISHED;

    }
}

