/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.aadb;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.testtype.DeviceTestCase;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TestDeviceFuncTest
extends DeviceTestCase {
    private static final String LOG_TAG = "TestDeviceFuncTest";
    private ITestDevice mTestDevice;
    private static final int mMinBugreportBytes = 0x100000;

    protected void setUp() throws Exception {
        super.setUp();
        this.mTestDevice = this.getDevice();
    }

    public void testBugreport() throws Exception {
        String string = StreamUtil.getStringFromStream((InputStream)this.mTestDevice.getBugreport().createInputStream());
        TestDeviceFuncTest.assertTrue((String)String.format("Expected at least %d characters; only saw %d", 0x100000, string.length()), (string.length() >= 0x100000 ? 1 : 0) != 0);
    }

    public void testExecuteShellCommand() throws IOException, DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)"testExecuteShellCommand");
        this.assertSimpleShellCommand();
    }

    private void assertSimpleShellCommand() throws DeviceNotAvailableException {
        String string = this.mTestDevice.executeShellCommand("ls");
        TestDeviceFuncTest.assertTrue((boolean)string.contains("data"));
        TestDeviceFuncTest.assertTrue((boolean)string.contains("system"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPushPull_normal() throws IOException, DeviceNotAvailableException {
        String string;
        block5: {
            Log.i((String)LOG_TAG, (String)"testPushPull");
            File file = null;
            File file2 = null;
            string = null;
            try {
                file = this.createTempTestFile(null);
                String string2 = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
                TestDeviceFuncTest.assertNotNull((Object)string2);
                string = String.format("%s/%s", string2, "tmp_testPushPull.txt");
                this.mTestDevice.executeShellCommand(String.format("rm %s", string));
                TestDeviceFuncTest.assertFalse((String)String.format("%s exists", string), (boolean)this.mTestDevice.doesFileExist(string));
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.pushFile(file, string));
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.doesFileExist(string));
                file2 = FileUtil.createTempFile((String)"tmp", (String)"txt");
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.pullFile(string, file2));
                TestDeviceFuncTest.assertTrue((boolean)this.compareFiles(file, file2));
                if (file2 == null) break block5;
                file2.delete();
            }
            catch (Throwable throwable) {
                if (file2 != null) {
                    file2.delete();
                }
                if (string != null) {
                    this.mTestDevice.executeShellCommand(String.format("rm %s", string));
                }
                throw throwable;
            }
        }
        if (string != null) {
            this.mTestDevice.executeShellCommand(String.format("rm %s", string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPushPull_extStorageVariable() throws IOException, DeviceNotAvailableException {
        String string;
        File file;
        block7: {
            Log.i((String)LOG_TAG, (String)"testPushPull");
            File file2 = null;
            File file3 = null;
            file = null;
            string = null;
            try {
                file2 = this.createTempTestFile(null);
                String string2 = "${EXTERNAL_STORAGE}";
                TestDeviceFuncTest.assertNotNull((Object)string2);
                string = String.format("%s/%s", string2, "tmp_testPushPull.txt");
                this.mTestDevice.executeShellCommand(String.format("rm %s", string));
                TestDeviceFuncTest.assertFalse((String)String.format("%s exists", string), (boolean)this.mTestDevice.doesFileExist(string));
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.pushFile(file2, string));
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.doesFileExist(string));
                file3 = FileUtil.createTempFile((String)"tmp", (String)"txt");
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.pullFile(string, file3));
                TestDeviceFuncTest.assertTrue((boolean)this.compareFiles(file2, file3));
                file = this.mTestDevice.pullFileFromExternal("tmp_testPushPull.txt");
                TestDeviceFuncTest.assertNotNull((Object)file);
                TestDeviceFuncTest.assertTrue((boolean)this.compareFiles(file2, file));
                if (file3 == null) break block7;
                file3.delete();
            }
            catch (Throwable throwable) {
                if (file3 != null) {
                    file3.delete();
                }
                if (file != null) {
                    file.delete();
                }
                if (string != null) {
                    this.mTestDevice.executeShellCommand(String.format("rm %s", string));
                }
                throw throwable;
            }
        }
        if (file != null) {
            file.delete();
        }
        if (string != null) {
            this.mTestDevice.executeShellCommand(String.format("rm %s", string));
        }
    }

    public void testPull_noexist() throws IOException, DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)"testPull_noexist");
        String string = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
        TestDeviceFuncTest.assertNotNull((Object)string);
        String string2 = String.format("%s/%s", string, "thisfiledoesntexist");
        TestDeviceFuncTest.assertFalse((String)String.format("%s exists", string2), (boolean)this.mTestDevice.doesFileExist(string2));
        TestDeviceFuncTest.assertNull((Object)this.mTestDevice.pullFile(string2));
    }

    private File createTempTestFile(File file) throws IOException {
        File file2 = null;
        try {
            file2 = FileUtil.createTempFile((String)"tmp", (String)".txt", (File)file);
            FileUtil.writeToFile((String)"this is the test file contents", (File)file2);
            return file2;
        }
        catch (IOException iOException) {
            if (file2 != null) {
                file2.delete();
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareFiles(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
            boolean bl = false;
            while (!bl) {
                int n2;
                n = bufferedInputStream.read();
                if (n != (n2 = bufferedInputStream2.read())) {
                    boolean bl2 = false;
                    return bl2;
                }
                bl = n == -1;
            }
            n = 1;
            return n != 0;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (bufferedInputStream2 != null) {
                bufferedInputStream2.close();
            }
        }
    }

    public void testSyncFiles_normal() throws Exception {
        this.doTestSyncFiles(this.mTestDevice.getMountPoint("EXTERNAL_STORAGE"));
    }

    public void testSyncFiles_extStorageVariable() throws Exception {
        this.doTestSyncFiles("${EXTERNAL_STORAGE}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestSyncFiles(String string) throws Exception {
        File file;
        block3: {
            String string2 = null;
            file = FileUtil.createTempDir((String)"tmp");
            try {
                File file2 = this.createTempTestFile(file);
                file2.setLastModified(System.currentTimeMillis() - 600000L);
                TestDeviceFuncTest.assertNotNull((Object)string);
                string2 = String.format("%s/%s/%s", string, file.getName(), file2.getName());
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.syncFiles(file, string));
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.doesFileExist(string2));
                String string3 = this.mTestDevice.executeShellCommand(String.format("ls -l %s", string2));
                File file3 = this.createTempTestFile(file);
                file3.setLastModified(System.currentTimeMillis() - 600000L);
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.syncFiles(file, string));
                String string4 = String.format("%s/%s/%s", string, file.getName(), file3.getName());
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.doesFileExist(string4));
                String string5 = this.mTestDevice.executeShellCommand(String.format("ls -l %s", string2));
                TestDeviceFuncTest.assertEquals((String)string3, (String)string5);
                String string6 = "blah";
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(string6.getBytes());
                fileOutputStream.close();
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.syncFiles(file, string));
                String string7 = this.mTestDevice.executeShellCommand(String.format("cat %s", string2));
                TestDeviceFuncTest.assertTrue((boolean)string7.contains(string6));
                if (string2 == null || string == null) break block3;
            }
            catch (Throwable throwable) {
                if (string2 != null && string != null) {
                    this.mTestDevice.executeShellCommand(String.format("rm -r %s", string2));
                }
                FileUtil.recursiveDelete((File)file);
                throw throwable;
            }
            this.mTestDevice.executeShellCommand(String.format("rm -r %s", string2));
        }
        FileUtil.recursiveDelete((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPushDir() throws IOException, DeviceNotAvailableException {
        File file;
        block3: {
            String string = null;
            String string2 = null;
            file = FileUtil.createTempDir((String)"tmp");
            try {
                File file2 = FileUtil.createTempDir((String)"tmp", (File)file);
                File file3 = this.createTempTestFile(file2);
                string2 = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
                TestDeviceFuncTest.assertNotNull((Object)string2);
                string = String.format("%s/%s/%s", string2, file2.getName(), file3.getName());
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.pushDir(file, string2));
                TestDeviceFuncTest.assertTrue((boolean)this.mTestDevice.doesFileExist(string));
                if (string == null || string2 == null) break block3;
            }
            catch (Throwable throwable) {
                if (string != null && string2 != null) {
                    this.mTestDevice.executeShellCommand(String.format("rm -r %s/%s", string2, string));
                }
                FileUtil.recursiveDelete((File)file);
                throw throwable;
            }
            this.mTestDevice.executeShellCommand(String.format("rm -r %s/%s", string2, string));
        }
        FileUtil.recursiveDelete((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetScreenshot() throws DeviceNotAvailableException, IOException {
        LogUtil.CLog.i((String)LOG_TAG, (Object[])new Object[]{"testGetScreenshot"});
        InputStreamSource inputStreamSource = this.getDevice().getScreenshot();
        TestDeviceFuncTest.assertNotNull((Object)inputStreamSource);
        File file = FileUtil.createTempFile((String)"screenshot", (String)".png");
        try {
            FileUtil.writeToFile((InputStream)inputStreamSource.createInputStream(), (File)file);
            LogUtil.CLog.i((String)"Created file at %s", (Object[])new Object[]{file.getAbsolutePath()});
            TestDeviceFuncTest.assertTrue((String)"Saved png file is less than 16K - is it invalid?", (file.length() > 16384L ? 1 : 0) != 0);
        }
        finally {
            FileUtil.deleteFile((File)file);
            inputStreamSource.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLogcat_size() throws DeviceNotAvailableException, IOException {
        int n;
        LogUtil.CLog.i((String)LOG_TAG, (Object[])new Object[]{"testGetLogcat_size"});
        for (n = 0; n < 100; ++n) {
            this.getDevice().executeShellCommand(String.format("log testGetLogcat_size log dump %d", n));
        }
        n = 0;
        int n2 = 0;
        while (n == 0) {
            RunUtil.getDefault().sleep(10L);
            InputStreamSource inputStreamSource = this.getDevice().getLogcat(102400);
            TestDeviceFuncTest.assertNotNull((Object)inputStreamSource);
            File file = FileUtil.createTempFile((String)"logcat", (String)".txt");
            try {
                FileUtil.writeToFile((InputStream)inputStreamSource.createInputStream(), (File)file);
                LogUtil.CLog.i((String)"Created file at %s", (Object[])new Object[]{file.getAbsolutePath()});
                String string = FileUtil.readStringFromFile((File)file);
                if (string.contains("testGetLogcat_size log dump 99")) {
                    n = 1;
                }
            }
            finally {
                FileUtil.deleteFile((File)file);
                inputStreamSource.cancel();
            }
            if (++n2 <= 100 || n != 0) continue;
            TestDeviceFuncTest.fail((String)"last log message is not in captured logcat");
        }
    }
}

