/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.aadb;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.testtype.DeviceTestCase;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class TestDeviceStressTest
extends DeviceTestCase {
    private int mIterations = 50;
    private static final String LOG_TAG = "TestDeviceStressTest";
    private static final int TEST_FILE_COUNT = 200;
    private ITestDevice mTestDevice;

    protected void setUp() throws Exception {
        super.setUp();
        this.mTestDevice = this.getDevice();
    }

    private File createTempTestFiles() throws IOException {
        File file = null;
        File file2 = null;
        file = FileUtil.createTempDir((String)"testDir");
        for (int i = 0; i < 200; ++i) {
            file2 = FileUtil.createTempFile((String)String.format("tmp_%d", i), (String)".txt", (File)file);
            FileUtil.writeToFile((String)"this is the test file contents", (File)file2);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPushFolderWithManyFiles() throws IOException, DeviceNotAvailableException {
        String string;
        block4: {
            File file = null;
            string = null;
            String string2 = this.mTestDevice.getMountPoint("EXTERNAL_STORAGE");
            TestDeviceStressTest.assertNotNull((Object)string2);
            string = String.format("%s/%s", string2, "testDir");
            try {
                file = this.createTempTestFiles();
                for (int i = 0; i < this.mIterations; ++i) {
                    this.mTestDevice.executeShellCommand(String.format("rm -r %s", string));
                    TestDeviceStressTest.assertFalse((String)String.format("%s exists", string), (boolean)this.mTestDevice.doesFileExist(string));
                    TestDeviceStressTest.assertTrue((boolean)this.mTestDevice.pushDir(file, string));
                    TestDeviceStressTest.assertTrue((boolean)this.mTestDevice.doesFileExist(string));
                }
                if (file == null) break block4;
            }
            catch (Throwable throwable) {
                if (file != null) {
                    FileUtil.recursiveDelete((File)file);
                }
                this.mTestDevice.executeShellCommand(String.format("rm -r %s", string));
                TestDeviceStressTest.assertFalse((String)String.format("%s exists", string), (boolean)this.mTestDevice.doesFileExist(string));
                throw throwable;
            }
            FileUtil.recursiveDelete((File)file);
        }
        this.mTestDevice.executeShellCommand(String.format("rm -r %s", string));
        TestDeviceStressTest.assertFalse((String)String.format("%s exists", string), (boolean)this.mTestDevice.doesFileExist(string));
    }
}

