/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.appsecurity;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.InstrumentationResultParser;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.DeviceTestCase;
import com.android.tradefed.testtype.IBuildReceiver;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;

public class AppSecurityTests
extends DeviceTestCase
implements IBuildReceiver {
    private static final String SHARED_UI_APK = "CtsSharedUidInstall.apk";
    private static final String SHARED_UI_PKG = "com.android.cts.shareuidinstall";
    private static final String SHARED_UI_DIFF_CERT_APK = "CtsSharedUidInstallDiffCert.apk";
    private static final String SHARED_UI_DIFF_CERT_PKG = "com.android.cts.shareuidinstalldiffcert";
    private static final String SIMPLE_APP_APK = "CtsSimpleAppInstall.apk";
    private static final String SIMPLE_APP_PKG = "com.android.cts.simpleappinstall";
    private static final String SIMPLE_APP_DIFF_CERT_APK = "CtsSimpleAppInstallDiffCert.apk";
    private static final String APP_WITH_DATA_APK = "CtsAppWithData.apk";
    private static final String APP_WITH_DATA_PKG = "com.android.cts.appwithdata";
    private static final String APP_WITH_DATA_CLASS = "com.android.cts.appwithdata.CreatePrivateDataTest";
    private static final String APP_WITH_DATA_CREATE_METHOD = "testCreatePrivateData";
    private static final String APP_WITH_DATA_CHECK_NOEXIST_METHOD = "testEnsurePrivateDataNotExist";
    private static final String APP_ACCESS_DATA_APK = "CtsAppAccessData.apk";
    private static final String APP_ACCESS_DATA_PKG = "com.android.cts.appaccessdata";
    private static final String EXTERNAL_STORAGE_APP_APK = "CtsExternalStorageApp.apk";
    private static final String EXTERNAL_STORAGE_APP_PKG = "com.android.cts.externalstorageapp";
    private static final String EXTERNAL_STORAGE_APP_CLASS = "com.android.cts.externalstorageapp.ExternalStorageTest";
    private static final String WRITE_EXTERNAL_STORAGE_APP_APK = "CtsWriteExternalStorageApp.apk";
    private static final String WRITE_EXTERNAL_STORAGE_APP_PKG = "com.android.cts.writeexternalstorageapp";
    private static final String WRITE_EXTERNAL_STORAGE_APP_CLASS = "com.android.cts.writeexternalstorageapp.WriteExternalStorageTest";
    private static final String TARGET_INSTRUMENT_APK = "CtsTargetInstrumentationApp.apk";
    private static final String TARGET_INSTRUMENT_PKG = "com.android.cts.targetinstrumentationapp";
    private static final String INSTRUMENT_DIFF_CERT_APK = "CtsInstrumentationAppDiffCert.apk";
    private static final String INSTRUMENT_DIFF_CERT_PKG = "com.android.cts.instrumentationdiffcertapp";
    private static final String DECLARE_PERMISSION_APK = "CtsPermissionDeclareApp.apk";
    private static final String DECLARE_PERMISSION_PKG = "com.android.cts.permissiondeclareapp";
    private static final String DECLARE_PERMISSION_COMPAT_APK = "CtsPermissionDeclareAppCompat.apk";
    private static final String DECLARE_PERMISSION_COMPAT_PKG = "com.android.cts.permissiondeclareappcompat";
    private static final String PERMISSION_DIFF_CERT_APK = "CtsUsePermissionDiffCert.apk";
    private static final String PERMISSION_DIFF_CERT_PKG = "com.android.cts.usespermissiondiffcertapp";
    private static final String READ_EXTERNAL_STORAGE = "android.permission.READ_EXTERNAL_STORAGE";
    private static final String MULTIUSER_STORAGE_APK = "CtsMultiUserStorageApp.apk";
    private static final String MULTIUSER_STORAGE_PKG = "com.android.cts.multiuserstorageapp";
    private static final String MULTIUSER_STORAGE_CLASS = "com.android.cts.multiuserstorageapp.MultiUserStorageTest";
    private static final String LOG_TAG = "AppSecurityTests";
    private CtsBuildHelper mCtsBuild;

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mCtsBuild = CtsBuildHelper.createBuildHelper((IBuildInfo)iBuildInfo);
    }

    private File getTestAppFile(String string) throws FileNotFoundException {
        return this.mCtsBuild.getTestApp(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        AppSecurityTests.assertNotNull((Object)this.mCtsBuild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedUidDifferentCerts() throws Exception {
        Log.i((String)LOG_TAG, (String)"installing apks with shared uid, but different certs");
        try {
            this.getDevice().uninstallPackage(SHARED_UI_PKG);
            this.getDevice().uninstallPackage(SHARED_UI_DIFF_CERT_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(SHARED_UI_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install shared uid app, Reason: %s", string), (Object)string);
            string = this.getDevice().installPackage(this.getTestAppFile(SHARED_UI_DIFF_CERT_APK), false, new String[0]);
            AppSecurityTests.assertNotNull((String)"shared uid app with different cert than existing app installed successfully", (Object)string);
            AppSecurityTests.assertEquals((String)"INSTALL_FAILED_SHARED_USER_INCOMPATIBLE", (String)string);
        }
        finally {
            this.getDevice().uninstallPackage(SHARED_UI_PKG);
            this.getDevice().uninstallPackage(SHARED_UI_DIFF_CERT_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppUpgradeDifferentCerts() throws Exception {
        Log.i((String)LOG_TAG, (String)"installing app upgrade with different certs");
        try {
            this.getDevice().uninstallPackage(SIMPLE_APP_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(SIMPLE_APP_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install simple app. Reason: %s", string), (Object)string);
            string = this.getDevice().installPackage(this.getTestAppFile(SIMPLE_APP_DIFF_CERT_APK), true, new String[0]);
            AppSecurityTests.assertNotNull((String)"app upgrade with different cert than existing app installed successfully", (Object)string);
            AppSecurityTests.assertEquals((String)"INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES", (String)string);
        }
        finally {
            this.getDevice().uninstallPackage(SIMPLE_APP_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppFailAccessPrivateData() throws Exception {
        Log.i((String)LOG_TAG, (String)"installing app that attempts to access another app's private data");
        try {
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
            this.getDevice().uninstallPackage(APP_ACCESS_DATA_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(APP_WITH_DATA_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install app with data. Reason: %s", string), (Object)string);
            AppSecurityTests.assertTrue((String)"failed to create app's private data", (boolean)this.runDeviceTests(APP_WITH_DATA_PKG, APP_WITH_DATA_CLASS, APP_WITH_DATA_CREATE_METHOD));
            string = this.getDevice().installPackage(this.getTestAppFile(APP_ACCESS_DATA_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install app access data. Reason: %s", string), (Object)string);
            AppSecurityTests.assertTrue((String)"could access app's private data", (boolean)this.runDeviceTests(APP_ACCESS_DATA_PKG));
        }
        finally {
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
            this.getDevice().uninstallPackage(APP_ACCESS_DATA_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadExternalStorageUnenforced() throws Exception {
        try {
            this.getDevice().uninstallPackage(EXTERNAL_STORAGE_APP_PKG);
            this.getDevice().uninstallPackage(WRITE_EXTERNAL_STORAGE_APP_PKG);
            this.getDevice().pushString("CAEK", this.getDevice().getMountPoint("EXTERNAL_STORAGE") + "/meow");
            AppSecurityTests.setPermissionEnforced(this.getDevice(), READ_EXTERNAL_STORAGE, false);
            AppSecurityTests.assertNull((Object)this.getDevice().installPackage(this.getTestAppFile(EXTERNAL_STORAGE_APP_APK), false, new String[0]));
            AppSecurityTests.assertNull((Object)this.getDevice().installPackage(this.getTestAppFile(WRITE_EXTERNAL_STORAGE_APP_APK), false, new String[0]));
            AppSecurityTests.assertTrue((String)"Normal app unable to read external storage", (boolean)this.runDeviceTests(EXTERNAL_STORAGE_APP_PKG, EXTERNAL_STORAGE_APP_CLASS, "testReadExternalStorage"));
            AppSecurityTests.assertTrue((String)"WRITE_EXTERNAL app unable to read external storage", (boolean)this.runDeviceTests(WRITE_EXTERNAL_STORAGE_APP_PKG, WRITE_EXTERNAL_STORAGE_APP_CLASS, "testReadExternalStorage"));
            AppSecurityTests.assertTrue((String)"WRITE_EXTERNAL app unable to write external storage", (boolean)this.runDeviceTests(WRITE_EXTERNAL_STORAGE_APP_PKG, WRITE_EXTERNAL_STORAGE_APP_CLASS, "testWriteExternalStorage"));
        }
        finally {
            this.getDevice().uninstallPackage(EXTERNAL_STORAGE_APP_PKG);
            this.getDevice().uninstallPackage(WRITE_EXTERNAL_STORAGE_APP_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExternalStorageLegacyPaths() throws Exception {
        try {
            this.getDevice().uninstallPackage(WRITE_EXTERNAL_STORAGE_APP_PKG);
            AppSecurityTests.assertNull((Object)this.getDevice().installPackage(this.getTestAppFile(WRITE_EXTERNAL_STORAGE_APP_APK), false, new String[0]));
            AppSecurityTests.assertTrue((String)"Failed to verify legacy filesystem paths", (boolean)this.runDeviceTests(WRITE_EXTERNAL_STORAGE_APP_PKG, WRITE_EXTERNAL_STORAGE_APP_CLASS, "testLegacyPaths"));
        }
        finally {
            this.getDevice().uninstallPackage(WRITE_EXTERNAL_STORAGE_APP_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUninstallRemovesData() throws Exception {
        Log.i((String)LOG_TAG, (String)"Uninstalling app, verifying data is removed.");
        try {
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(APP_WITH_DATA_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install app with data. Reason: %s", string), (Object)string);
            AppSecurityTests.assertTrue((String)"failed to create app's private data", (boolean)this.runDeviceTests(APP_WITH_DATA_PKG, APP_WITH_DATA_CLASS, APP_WITH_DATA_CREATE_METHOD));
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
            string = this.getDevice().installPackage(this.getTestAppFile(APP_WITH_DATA_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install app with data second time. Reason: %s", string), (Object)string);
            AppSecurityTests.assertTrue((String)"app's private data still exists after install", (boolean)this.runDeviceTests(APP_WITH_DATA_PKG, APP_WITH_DATA_CLASS, APP_WITH_DATA_CHECK_NOEXIST_METHOD));
        }
        finally {
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstrumentationDiffCert() throws Exception {
        Log.i((String)LOG_TAG, (String)"installing app that attempts to instrument another app");
        try {
            this.getDevice().uninstallPackage(TARGET_INSTRUMENT_PKG);
            this.getDevice().uninstallPackage(INSTRUMENT_DIFF_CERT_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(TARGET_INSTRUMENT_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install target instrumentation app. Reason: %s", string), (Object)string);
            string = this.getDevice().installPackage(this.getTestAppFile(INSTRUMENT_DIFF_CERT_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install instrumentation app with diff cert. Reason: %s", string), (Object)string);
            AppSecurityTests.assertTrue((String)"running instrumentation with diff cert unexpectedly succeeded", (boolean)this.runDeviceTests(INSTRUMENT_DIFF_CERT_PKG));
        }
        finally {
            this.getDevice().uninstallPackage(TARGET_INSTRUMENT_PKG);
            this.getDevice().uninstallPackage(INSTRUMENT_DIFF_CERT_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPermissionDiffCert() throws Exception {
        Log.i((String)LOG_TAG, (String)"installing app that attempts to use permission of another app");
        try {
            this.getDevice().uninstallPackage(DECLARE_PERMISSION_PKG);
            this.getDevice().uninstallPackage(DECLARE_PERMISSION_COMPAT_PKG);
            this.getDevice().uninstallPackage(PERMISSION_DIFF_CERT_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(DECLARE_PERMISSION_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install declare permission app. Reason: %s", string), (Object)string);
            string = this.getDevice().installPackage(this.getTestAppFile(DECLARE_PERMISSION_COMPAT_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install declare permission compat app. Reason: %s", string), (Object)string);
            string = this.getDevice().installPackage(this.getTestAppFile(PERMISSION_DIFF_CERT_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)String.format("failed to install permission app with diff cert. Reason: %s", string), (Object)string);
            TestRunResult testRunResult = this.doRunTests(PERMISSION_DIFF_CERT_PKG, null, null);
            this.assertDeviceTestsPass(testRunResult);
        }
        finally {
            this.getDevice().uninstallPackage(DECLARE_PERMISSION_PKG);
            this.getDevice().uninstallPackage(DECLARE_PERMISSION_COMPAT_PKG);
            this.getDevice().uninstallPackage(PERMISSION_DIFF_CERT_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiUserStorage() throws Exception {
        if (!AppSecurityTests.isMultiUserSupportedOnDevice(this.getDevice())) {
            Log.d((String)LOG_TAG, (String)"Single user device; skipping isolated storage tests");
            return;
        }
        int n = 0;
        int n2 = -1;
        try {
            n2 = AppSecurityTests.createUserOnDevice(this.getDevice());
            this.getDevice().uninstallPackage(MULTIUSER_STORAGE_PKG);
            String string = this.getDevice().installPackage(this.getTestAppFile(MULTIUSER_STORAGE_APK), false, new String[0]);
            AppSecurityTests.assertNull((String)("Failed to install: " + string), (Object)string);
            this.assertDeviceTestsPass(this.doRunTestsAsUser(MULTIUSER_STORAGE_PKG, MULTIUSER_STORAGE_CLASS, "cleanIsolatedStorage", n));
            this.assertDeviceTestsPass(this.doRunTestsAsUser(MULTIUSER_STORAGE_PKG, MULTIUSER_STORAGE_CLASS, "cleanIsolatedStorage", n2));
            this.assertDeviceTestsPass(this.doRunTestsAsUser(MULTIUSER_STORAGE_PKG, MULTIUSER_STORAGE_CLASS, "writeIsolatedStorage", n));
            this.assertDeviceTestsPass(this.doRunTestsAsUser(MULTIUSER_STORAGE_PKG, MULTIUSER_STORAGE_CLASS, "writeIsolatedStorage", n2));
            this.assertDeviceTestsPass(this.doRunTestsAsUser(MULTIUSER_STORAGE_PKG, MULTIUSER_STORAGE_CLASS, "readIsolatedStorage", n));
            this.assertDeviceTestsPass(this.doRunTestsAsUser(MULTIUSER_STORAGE_PKG, MULTIUSER_STORAGE_CLASS, "readIsolatedStorage", n2));
        }
        finally {
            this.getDevice().uninstallPackage(MULTIUSER_STORAGE_PKG);
            if (n2 != -1) {
                AppSecurityTests.removeUserOnDevice(this.getDevice(), n2);
            }
        }
    }

    private void assertDeviceTestsPass(TestRunResult testRunResult) {
        AppSecurityTests.assertFalse((String)String.format("Failed to successfully run device tests for %s. Reason: %s", testRunResult.getName(), testRunResult.getRunFailureMessage()), (boolean)testRunResult.isRunFailure());
        if (testRunResult.hasFailedTests()) {
            StringBuilder stringBuilder = new StringBuilder("on-device tests failed:\n");
            for (Map.Entry entry : testRunResult.getTestResults().entrySet()) {
                if (((TestResult)entry.getValue()).getStatus().equals((Object)TestResult.TestStatus.PASSED)) continue;
                stringBuilder.append(((TestIdentifier)entry.getKey()).toString());
                stringBuilder.append(":\n");
                stringBuilder.append(((TestResult)entry.getValue()).getStackTrace());
            }
            AppSecurityTests.fail((String)stringBuilder.toString());
        }
    }

    private boolean runDeviceTests(String string) throws DeviceNotAvailableException {
        return this.runDeviceTests(string, null, null);
    }

    private boolean runDeviceTests(String string, String string2, String string3) throws DeviceNotAvailableException {
        TestRunResult testRunResult = this.doRunTests(string, string2, string3);
        return !testRunResult.hasFailedTests();
    }

    private TestRunResult doRunTests(String string, String string2, String string3) throws DeviceNotAvailableException {
        RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(string, this.getDevice().getIDevice());
        if (string2 != null && string3 != null) {
            remoteAndroidTestRunner.setMethodName(string2, string3);
        }
        CollectingTestListener collectingTestListener = new CollectingTestListener();
        this.getDevice().runInstrumentationTests((IRemoteAndroidTestRunner)remoteAndroidTestRunner, new ITestRunListener[]{collectingTestListener});
        return collectingTestListener.getCurrentRunResults();
    }

    private static boolean isMultiUserSupportedOnDevice(ITestDevice iTestDevice) throws DeviceNotAvailableException {
        String string = iTestDevice.executeShellCommand("pm get-max-users");
        try {
            return Integer.parseInt(string.substring(string.lastIndexOf(" ")).trim()) > 1;
        }
        catch (NumberFormatException numberFormatException) {
            AppSecurityTests.fail((String)("Failed to parse result: " + string));
            return false;
        }
    }

    private static int createUserOnDevice(ITestDevice iTestDevice) throws DeviceNotAvailableException {
        String string = "CTS_" + System.currentTimeMillis();
        String string2 = iTestDevice.executeShellCommand("pm create-user " + string);
        if (string2.startsWith("Success")) {
            try {
                return Integer.parseInt(string2.substring(string2.lastIndexOf(" ")).trim());
            }
            catch (NumberFormatException numberFormatException) {
                AppSecurityTests.fail((String)("Failed to parse result: " + string2));
            }
        } else {
            AppSecurityTests.fail((String)("Failed to create user: " + string2));
        }
        throw new IllegalStateException();
    }

    private static void removeUserOnDevice(ITestDevice iTestDevice, int n) throws DeviceNotAvailableException {
        String string = iTestDevice.executeShellCommand("pm remove-user " + n);
        if (string.startsWith("Error")) {
            AppSecurityTests.fail((String)("Failed to remove user: " + string));
        }
    }

    private TestRunResult doRunTestsAsUser(String string, String string2, String string3, int n) throws DeviceNotAvailableException {
        String string4 = "am instrument --user " + n + " -w -r -e class " + string2 + "#" + string3 + " " + string + "/android.test.InstrumentationTestRunner";
        Log.i((String)LOG_TAG, (String)("Running " + string4 + " on " + this.getDevice().getSerialNumber()));
        CollectingTestListener collectingTestListener = new CollectingTestListener();
        InstrumentationResultParser instrumentationResultParser = new InstrumentationResultParser(string, (ITestRunListener)collectingTestListener);
        this.getDevice().executeShellCommand(string4, (IShellOutputReceiver)instrumentationResultParser);
        return collectingTestListener.getCurrentRunResults();
    }

    private static void setPermissionEnforced(ITestDevice iTestDevice, String string, boolean bl) throws DeviceNotAvailableException {
        iTestDevice.executeShellCommand("pm set-permission-enforced " + string + " " + Boolean.toString(bl));
    }
}

