/*
 * Decompiled with CFR 0.152.
 */
package com.android.hosttest;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;

public class DeviceConnector {
    private static final int MAX_WAIT_DEVICE_TIME = 5000;

    public IDevice connectToDevice(String string) {
        AndroidDebugBridge.init((boolean)false);
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge();
        for (IDevice iDevice : androidDebugBridge.getDevices()) {
            if (string == null) {
                return iDevice;
            }
            if (!string.equals(iDevice.getSerialNumber())) continue;
            return iDevice;
        }
        System.out.println("Waiting for device...");
        NewDeviceListener newDeviceListener = new NewDeviceListener(string);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)newDeviceListener);
        IDevice iDevice = newDeviceListener.waitForDevice(5000L);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)newDeviceListener);
        if (iDevice == null) {
            throw new IllegalArgumentException("Could not connect to device");
        }
        System.out.println(String.format("Connected to %s", iDevice.getSerialNumber()));
        return iDevice;
    }

    private static class NewDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private IDevice mDevice;
        private String mSerial;

        public NewDeviceListener(String string) {
            this.mSerial = string;
        }

        public void deviceChanged(IDevice iDevice, int n) {
        }

        public void deviceConnected(IDevice iDevice) {
            if (this.mSerial == null) {
                this.setDevice(iDevice);
            } else if (this.mSerial.equals(iDevice.getSerialNumber())) {
                this.setDevice(iDevice);
            }
        }

        private synchronized void setDevice(IDevice iDevice) {
            this.mDevice = iDevice;
            this.notify();
        }

        public void deviceDisconnected(IDevice iDevice) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IDevice waitForDevice(long l) {
            NewDeviceListener newDeviceListener = this;
            synchronized (newDeviceListener) {
                if (this.mDevice == null) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Waiting for device interrupted");
                    }
                }
            }
            return this.mDevice;
        }
    }
}

