/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.runners.model.Statement;

public class FailOnTimeout
extends Statement {
    private final Statement fOriginalStatement;
    private final long fTimeout;

    public FailOnTimeout(Statement statement, long l) {
        this.fOriginalStatement = statement;
        this.fTimeout = l;
    }

    public void evaluate() throws Throwable {
        StatementThread statementThread = this.evaluateStatement();
        if (!statementThread.fFinished) {
            this.throwExceptionForUnfinishedThread(statementThread);
        }
    }

    private StatementThread evaluateStatement() throws InterruptedException {
        StatementThread statementThread = new StatementThread(this.fOriginalStatement);
        statementThread.start();
        statementThread.join(this.fTimeout);
        statementThread.interrupt();
        return statementThread;
    }

    private void throwExceptionForUnfinishedThread(StatementThread statementThread) throws Throwable {
        if (statementThread.fExceptionThrownByOriginalStatement != null) {
            throw statementThread.fExceptionThrownByOriginalStatement;
        }
        this.throwTimeoutException(statementThread);
    }

    private void throwTimeoutException(StatementThread statementThread) throws Exception {
        Exception exception = new Exception(String.format("test timed out after %d milliseconds", this.fTimeout));
        exception.setStackTrace(statementThread.getStackTrace());
        throw exception;
    }

    private static class StatementThread
    extends Thread {
        private final Statement fStatement;
        private boolean fFinished = false;
        private Throwable fExceptionThrownByOriginalStatement = null;

        public StatementThread(Statement statement) {
            this.fStatement = statement;
        }

        public void run() {
            try {
                this.fStatement.evaluate();
                this.fFinished = true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.fExceptionThrownByOriginalStatement = throwable;
            }
        }
    }
}

