/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.io.File;
import java.io.IOException;
import org.junit.rules.ExternalResource;

public class TemporaryFolder
extends ExternalResource {
    private File folder;

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.delete();
    }

    public void create() throws IOException {
        this.folder = this.newFolder();
    }

    public File newFile(String string) throws IOException {
        File file = new File(this.getRoot(), string);
        file.createNewFile();
        return file;
    }

    public File newFile() throws IOException {
        return File.createTempFile("junit", null, this.folder);
    }

    public File newFolder(String ... stringArray) {
        File file = this.getRoot();
        for (String string : stringArray) {
            file = new File(file, string);
            file.mkdir();
        }
        return file;
    }

    public File newFolder() throws IOException {
        File file = File.createTempFile("junit", "", this.folder);
        file.delete();
        file.mkdir();
        return file;
    }

    public File getRoot() {
        if (this.folder == null) {
            throw new IllegalStateException("the temporary folder has not yet been created");
        }
        return this.folder;
    }

    public void delete() {
        this.recursiveDelete(this.folder);
    }

    private void recursiveDelete(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.recursiveDelete(file2);
            }
        }
        file.delete();
    }
}

