/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.rules.RuleFieldValidator;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentRunner<T>
extends Runner
implements Filterable,
Sortable {
    private final TestClass fTestClass;
    private Sorter fSorter = Sorter.NULL;
    private List<T> fFilteredChildren = null;
    private RunnerScheduler fScheduler = new RunnerScheduler(){

        public void schedule(Runnable runnable) {
            runnable.run();
        }

        public void finished() {
        }
    };

    protected ParentRunner(Class<?> clazz) throws InitializationError {
        this.fTestClass = new TestClass(clazz);
        this.validate();
    }

    protected abstract List<T> getChildren();

    protected abstract Description describeChild(T var1);

    protected abstract void runChild(T var1, RunNotifier var2);

    protected void collectInitializationErrors(List<Throwable> list) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, list);
        this.validatePublicVoidNoArgMethods(AfterClass.class, true, list);
        this.validateClassRules(list);
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> clazz, boolean bl, List<Throwable> list) {
        List<FrameworkMethod> list2 = this.getTestClass().getAnnotatedMethods(clazz);
        for (FrameworkMethod frameworkMethod : list2) {
            frameworkMethod.validatePublicVoidNoArg(bl, list);
        }
    }

    private void validateClassRules(List<Throwable> list) {
        RuleFieldValidator.CLASS_RULE_VALIDATOR.validate(this.getTestClass(), list);
    }

    protected Statement classBlock(RunNotifier runNotifier) {
        Statement statement = this.childrenInvoker(runNotifier);
        statement = this.withBeforeClasses(statement);
        statement = this.withAfterClasses(statement);
        statement = this.withClassRules(statement);
        return statement;
    }

    protected Statement withBeforeClasses(Statement statement) {
        List<FrameworkMethod> list = this.fTestClass.getAnnotatedMethods(BeforeClass.class);
        return list.isEmpty() ? statement : new RunBefores(statement, list, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        List<FrameworkMethod> list = this.fTestClass.getAnnotatedMethods(AfterClass.class);
        return list.isEmpty() ? statement : new RunAfters(statement, list, null);
    }

    private Statement withClassRules(Statement statement) {
        List<TestRule> list = this.classRules();
        return list.isEmpty() ? statement : new RunRules(statement, list, this.getDescription());
    }

    protected List<TestRule> classRules() {
        return this.fTestClass.getAnnotatedFieldValues(null, ClassRule.class, TestRule.class);
    }

    protected Statement childrenInvoker(final RunNotifier runNotifier) {
        return new Statement(){

            public void evaluate() {
                ParentRunner.this.runChildren(runNotifier);
            }
        };
    }

    private void runChildren(final RunNotifier runNotifier) {
        for (final T t : this.getFilteredChildren()) {
            this.fScheduler.schedule(new Runnable(){

                public void run() {
                    ParentRunner.this.runChild(t, runNotifier);
                }
            });
        }
        this.fScheduler.finished();
    }

    protected String getName() {
        return this.fTestClass.getName();
    }

    public final TestClass getTestClass() {
        return this.fTestClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runLeaf(Statement statement, Description description, RunNotifier runNotifier) {
        EachTestNotifier eachTestNotifier = new EachTestNotifier(runNotifier, description);
        eachTestNotifier.fireTestStarted();
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            eachTestNotifier.addFailedAssumption(assumptionViolatedException);
        }
        catch (Throwable throwable) {
            eachTestNotifier.addFailure(throwable);
        }
        finally {
            eachTestNotifier.fireTestFinished();
        }
    }

    protected Annotation[] getRunnerAnnotations() {
        return this.fTestClass.getAnnotations();
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.getName(), this.getRunnerAnnotations());
        for (T t : this.getFilteredChildren()) {
            description.addChild(this.describeChild(t));
        }
        return description;
    }

    @Override
    public void run(RunNotifier runNotifier) {
        EachTestNotifier eachTestNotifier = new EachTestNotifier(runNotifier, this.getDescription());
        try {
            Statement statement = this.classBlock(runNotifier);
            statement.evaluate();
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            eachTestNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException stoppedByUserException) {
            throw stoppedByUserException;
        }
        catch (Throwable throwable) {
            eachTestNotifier.addFailure(throwable);
        }
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<T> iterator = this.getFilteredChildren().iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (this.shouldRun(filter, t)) {
                try {
                    filter.apply(t);
                }
                catch (NoTestsRemainException noTestsRemainException) {
                    iterator.remove();
                }
                continue;
            }
            iterator.remove();
        }
        if (this.getFilteredChildren().isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    @Override
    public void sort(Sorter sorter) {
        this.fSorter = sorter;
        for (T t : this.getFilteredChildren()) {
            this.sortChild(t);
        }
        Collections.sort(this.getFilteredChildren(), this.comparator());
    }

    private void validate() throws InitializationError {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        this.collectInitializationErrors(arrayList);
        if (!arrayList.isEmpty()) {
            throw new InitializationError(arrayList);
        }
    }

    private List<T> getFilteredChildren() {
        if (this.fFilteredChildren == null) {
            this.fFilteredChildren = new ArrayList<T>(this.getChildren());
        }
        return this.fFilteredChildren;
    }

    private void sortChild(T t) {
        this.fSorter.apply(t);
    }

    private boolean shouldRun(Filter filter, T t) {
        return filter.shouldRun(this.describeChild(t));
    }

    private Comparator<? super T> comparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return ParentRunner.this.fSorter.compare(ParentRunner.this.describeChild(t), ParentRunner.this.describeChild(t2));
            }
        };
    }

    public void setScheduler(RunnerScheduler runnerScheduler) {
        this.fScheduler = runnerScheduler;
    }
}

