/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.MultipartForm;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueReporter
implements ITestInvocationListener {
    private static final int BUGREPORT_SIZE = 512000;
    private static final String PRODUCT_NAME_KEY = "buildName";
    private static final String BUILD_TYPE_KEY = "build_type";
    private static final String BUILD_ID_KEY = "buildID";
    @Option(name="issue-server", description="Server url to post test failures to.")
    private String mServerUrl;
    private final ExecutorService mReporterService = Executors.newCachedThreadPool();
    private Issue mCurrentIssue;
    private String mBuildId;
    private String mBuildType;
    private String mProductName;

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
        this.mCurrentIssue = new Issue();
        this.mCurrentIssue.mTestName = testIdentifier.toString();
        this.mCurrentIssue.mStackTrace = string;
    }

    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
        if (string.startsWith("bug-")) {
            try {
                this.setBugReport(inputStreamSource);
            }
            catch (IOException iOException) {
                LogUtil.CLog.e((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBugReport(InputStreamSource inputStreamSource) throws IOException {
        if (this.mCurrentIssue != null) {
            InputStream inputStream = null;
            try {
                inputStream = inputStreamSource.createInputStream();
                Issue.access$202(this.mCurrentIssue, IssueReporter.getBytes(inputStream, 512000));
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        } else {
            LogUtil.CLog.e((String)"setBugReport is getting called on an empty issue...");
        }
    }

    static byte[] getBytes(InputStream inputStream, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            gZIPOutputStream.write(byArray, 0, n2);
        }
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
        if (this.mCurrentIssue != null) {
            this.mReporterService.submit(this.mCurrentIssue);
            this.mCurrentIssue = null;
        }
    }

    public void testRunEnded(long l, Map<String, String> map) {
        this.setDeviceMetrics(map);
    }

    private void setDeviceMetrics(Map<String, String> map) {
        if (map.containsKey(BUILD_ID_KEY)) {
            this.mBuildId = map.get(BUILD_ID_KEY);
        }
        if (map.containsKey(BUILD_TYPE_KEY)) {
            this.mBuildType = map.get(BUILD_TYPE_KEY);
        }
        if (map.containsKey(PRODUCT_NAME_KEY)) {
            this.mProductName = map.get(PRODUCT_NAME_KEY);
        }
    }

    public void invocationEnded(long l) {
        try {
            this.mReporterService.shutdown();
            if (!this.mReporterService.awaitTermination(1L, TimeUnit.MINUTES)) {
                LogUtil.CLog.i((String)"Some issues could not be reported...");
            }
        }
        catch (InterruptedException interruptedException) {
            LogUtil.CLog.e((Throwable)interruptedException);
        }
    }

    public void invocationStarted(IBuildInfo iBuildInfo) {
    }

    public void testRunStarted(String string, int n) {
    }

    public void testStarted(TestIdentifier testIdentifier) {
    }

    public void testRunFailed(String string) {
    }

    public void testRunStopped(long l) {
    }

    public void invocationFailed(Throwable throwable) {
    }

    public TestSummary getSummary() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Issue
    implements Callable<Void> {
        private String mTestName;
        private String mStackTrace;
        private byte[] mBugReport;

        Issue() {
        }

        @Override
        public Void call() throws Exception {
            if (this.isEmpty(IssueReporter.this.mServerUrl) || this.isEmpty(IssueReporter.this.mBuildId) || this.isEmpty(IssueReporter.this.mBuildType) || this.isEmpty(IssueReporter.this.mProductName) || this.isEmpty(this.mTestName) || this.isEmpty(this.mStackTrace)) {
                return null;
            }
            new MultipartForm(IssueReporter.this.mServerUrl).addFormValue("productName", IssueReporter.this.mProductName).addFormValue("buildType", IssueReporter.this.mBuildType).addFormValue("buildId", IssueReporter.this.mBuildId).addFormValue("testName", this.mTestName).addFormValue("stackTrace", this.mStackTrace).addFormFile("bugReport", "bugreport.txt.gz", this.mBugReport).submit();
            return null;
        }

        private boolean isEmpty(String string) {
            return string == null || string.trim().isEmpty();
        }

        static /* synthetic */ byte[] access$202(Issue issue, byte[] byArray) {
            issue.mBugReport = byArray;
            return byArray;
        }
    }
}

