/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class MultipartForm {
    private static final String FORM_DATA_BOUNDARY = "C75I55u3R3p0r73r";
    private final String mServerUrl;
    private final Map<String, String> mFormValues = new HashMap<String, String>();
    private String mName;
    private String mFileName;
    private byte[] mData;

    public MultipartForm(String string) {
        this.mServerUrl = string;
    }

    public MultipartForm addFormValue(String string, String string2) {
        this.mFormValues.put(string, string2);
        return this;
    }

    public MultipartForm addFormFile(String string, String string2, byte[] byArray) {
        this.mName = string;
        this.mFileName = string2;
        this.mData = byArray;
        return this;
    }

    public void submit() throws IOException {
        String string = this.submitForm(this.mServerUrl);
        if (string != null) {
            this.submitForm(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String submitForm(String string) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=C75I55u3R3p0r73r");
            byte[] byArray = this.getContentBody();
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
            OutputStream outputStream = httpURLConnection.getOutputStream();
            try {
                outputStream.write(byArray);
            }
            finally {
                outputStream.close();
            }
            InputStream inputStream = httpURLConnection.getInputStream();
            inputStream.close();
            if (httpURLConnection.getResponseCode() == 302) {
                String string2 = httpURLConnection.getHeaderField("Location");
                return string2;
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return null;
    }

    private byte[] getContentBody() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
        printWriter.println();
        for (Map.Entry<String, String> entry : this.mFormValues.entrySet()) {
            this.writeFormField(printWriter, entry.getKey(), entry.getValue());
        }
        if (this.mData != null) {
            this.writeFormFileHeader(printWriter, this.mName, this.mFileName);
            printWriter.flush();
            byteArrayOutputStream.write(this.mData);
            printWriter.println();
        }
        printWriter.append("--").append(FORM_DATA_BOUNDARY).println("--");
        printWriter.flush();
        printWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFormField(PrintWriter printWriter, String string, String string2) {
        printWriter.append("--").println(FORM_DATA_BOUNDARY);
        printWriter.append("Content-Disposition: form-data; name=\"").append(string).println("\"");
        printWriter.println();
        printWriter.println(string2);
    }

    private void writeFormFileHeader(PrintWriter printWriter, String string, String string2) {
        printWriter.append("--").println(FORM_DATA_BOUNDARY);
        printWriter.append("Content-Disposition: form-data; name=\"").append(string);
        printWriter.append("\"; filename=\"").append(string2).println("\"");
        printWriter.println("Content-Type: application/x-gzip");
        printWriter.println("Content-Transfer-Encoding: binary");
        printWriter.println();
    }
}

