/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.TestPackageResult;
import com.android.cts.tradefed.result.TestResultRepo;
import com.android.cts.tradefed.result.TestResults;
import com.android.cts.tradefed.testtype.ITestPackageDef;
import com.android.cts.tradefed.testtype.ITestPlan;
import com.android.cts.tradefed.testtype.TestPackageRepo;
import com.android.cts.tradefed.testtype.TestPlan;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;

public class PlanCreator {
    @Option(name="plan", shortName=112, description="the name of the plan to create", importance=Option.Importance.IF_UNSET)
    private String mPlanName = null;
    @Option(name="session", shortName=115, description="the session id to derive from", importance=Option.Importance.IF_UNSET)
    private Integer mSessionId = null;
    @Option(name="result", shortName=114, description="the result type to filter. One of pass, fail, notExecuted.", importance=Option.Importance.IF_UNSET)
    private String mResultFilterString = null;
    @Option(name="run-known-failures")
    private boolean mIncludeKnownFailures = false;
    private CtsTestStatus mResultFilter = null;
    private TestResults mResult = null;
    private File mPlanFile;

    public PlanCreator() {
    }

    public PlanCreator(String string, int n, CtsTestStatus ctsTestStatus) {
        this.mPlanName = string;
        this.mSessionId = n;
        this.mResultFilterString = ctsTestStatus.getValue();
    }

    public void createAndSerializeDerivedPlan(CtsBuildHelper ctsBuildHelper) throws ConfigurationException {
        ITestPlan iTestPlan = this.createDerivedPlan(ctsBuildHelper);
        if (iTestPlan != null) {
            try {
                iTestPlan.serialize(new BufferedOutputStream(new FileOutputStream(this.mPlanFile)));
            }
            catch (IOException iOException) {
                Log.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"", (String)String.format("Failed to create plan file %s", this.mPlanName));
                LogUtil.CLog.e((Throwable)iOException);
            }
        }
    }

    public ITestPlan createDerivedPlan(CtsBuildHelper ctsBuildHelper) throws ConfigurationException {
        this.checkFields(ctsBuildHelper);
        TestPackageRepo testPackageRepo = new TestPackageRepo(ctsBuildHelper.getTestCasesDir(), this.mIncludeKnownFailures);
        TestPlan testPlan = new TestPlan(this.mPlanName);
        for (TestPackageResult testPackageResult : this.mResult.getPackages()) {
            Collection<TestIdentifier> collection = testPackageResult.getTestsWithStatus(this.mResultFilter);
            if (collection.isEmpty()) continue;
            String string = testPackageResult.getAppPackageName();
            ITestPackageDef iTestPackageDef = testPackageRepo.getTestPackage(string);
            if (iTestPackageDef != null) {
                LinkedHashSet<TestIdentifier> linkedHashSet = new LinkedHashSet<TestIdentifier>(iTestPackageDef.getTests());
                linkedHashSet.removeAll(collection);
                testPlan.addPackage(string);
                testPlan.addExcludedTests(string, linkedHashSet);
                continue;
            }
            LogUtil.CLog.e((String)"Could not find package %s in repository", (Object[])new Object[]{string});
        }
        return testPlan;
    }

    private void checkFields(CtsBuildHelper ctsBuildHelper) throws ConfigurationException {
        if (this.mSessionId == null) {
            throw new ConfigurationException("Missing --session argument");
        }
        TestResultRepo testResultRepo = new TestResultRepo(ctsBuildHelper.getResultsDir());
        this.mResult = testResultRepo.getResult(this.mSessionId);
        if (this.mResult == null) {
            throw new ConfigurationException(String.format("Could not find session with id %d", this.mSessionId));
        }
        if (this.mResultFilterString == null) {
            throw new ConfigurationException("Missing --result argument");
        }
        this.mResultFilter = CtsTestStatus.getStatus(this.mResultFilterString);
        if (this.mResultFilter == null) {
            throw new ConfigurationException("Invalid result argument. Expected one of pass,fail,notExecuted");
        }
        if (this.mPlanName == null) {
            throw new ConfigurationException("Missing --plan argument");
        }
        try {
            this.mPlanFile = ctsBuildHelper.getTestPlanFile(this.mPlanName);
            if (this.mPlanFile.exists()) {
                throw new ConfigurationException(String.format("Test plan %s already exists", this.mPlanName));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException("Could not find plans directory");
        }
    }
}

