/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.cts.tradefed.result.TimeUtil;
import com.android.ddmlib.Log;
import java.io.IOException;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class Test
extends AbstractXmlPullParser {
    static final String TAG = "Test";
    private static final String NAME_ATTR = "name";
    private static final String MESSAGE_ATTR = "message";
    private static final String ENDTIME_ATTR = "endtime";
    private static final String STARTTIME_ATTR = "starttime";
    private static final String RESULT_ATTR = "result";
    private static final String SCENE_TAG = "FailedScene";
    private static final String STACK_TAG = "StackTrace";
    private static final String SUMMARY_TAG = "Summary";
    private static final String DETAILS_TAG = "Details";
    private static final String VALUEARRAY_TAG = "ValueArray";
    private static final String VALUE_TAG = "Value";
    private static final String TARGET_ATTR = "target";
    private static final String SCORETYPE_ATTR = "scoreType";
    private static final String UNIT_ATTR = "unit";
    private static final String SOURCE_ATTR = "source";
    private static final String LOG_SEPARATOR = "\\+\\+\\+";
    private static final String LOG_ELEM_SEPARATOR = "\\|";
    private String mName;
    private CtsTestStatus mResult;
    private String mStartTime;
    private String mEndTime;
    private String mMessage;
    private String mStackTrace;
    private String mSummary;
    private String mDetails;

    public Test() {
    }

    public Test(String string) {
        this.mName = string;
        this.mResult = CtsTestStatus.NOT_EXECUTED;
        this.mStartTime = TimeUtil.getTimestamp();
        this.updateEndTime();
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public CtsTestStatus getResult() {
        return this.mResult;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String string) {
        this.mMessage = string;
    }

    public String getStartTime() {
        return this.mStartTime;
    }

    public String getEndTime() {
        return this.mEndTime;
    }

    public String getStackTrace() {
        return this.mStackTrace;
    }

    public void setStackTrace(String string) {
        this.mStackTrace = Test.sanitizeStackTrace(string);
        this.mMessage = Test.getFailureMessageFromStackTrace(this.mStackTrace);
    }

    public String getSummary() {
        return this.mSummary;
    }

    public void setSummary(String string) {
        this.mSummary = string;
    }

    public String getDetails() {
        return this.mDetails;
    }

    public void setDetails(String string) {
        this.mDetails = string;
    }

    public void updateEndTime() {
        this.mEndTime = TimeUtil.getTimestamp();
    }

    public void setResultStatus(CtsTestStatus ctsTestStatus) {
        this.mResult = ctsTestStatus;
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        PerfResultSummary perfResultSummary;
        kXmlSerializer.startTag(CtsXmlResultReporter.ns, TAG);
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, NAME_ATTR, this.getName());
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, RESULT_ATTR, this.mResult.getValue());
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, STARTTIME_ATTR, this.mStartTime);
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, ENDTIME_ATTR, this.mEndTime);
        if (this.mMessage != null) {
            kXmlSerializer.startTag(CtsXmlResultReporter.ns, SCENE_TAG);
            kXmlSerializer.attribute(CtsXmlResultReporter.ns, MESSAGE_ATTR, this.mMessage);
            if (this.mStackTrace != null) {
                kXmlSerializer.startTag(CtsXmlResultReporter.ns, STACK_TAG);
                kXmlSerializer.text(this.mStackTrace);
                kXmlSerializer.endTag(CtsXmlResultReporter.ns, STACK_TAG);
            }
            kXmlSerializer.endTag(CtsXmlResultReporter.ns, SCENE_TAG);
        }
        if (this.mSummary != null && (perfResultSummary = this.parseSummary(this.mSummary)) != null) {
            kXmlSerializer.startTag(CtsXmlResultReporter.ns, SUMMARY_TAG);
            kXmlSerializer.attribute(CtsXmlResultReporter.ns, MESSAGE_ATTR, perfResultSummary.mMessage);
            if (perfResultSummary.mTarget.length() != 0 && !perfResultSummary.mTarget.equals(" ")) {
                kXmlSerializer.attribute(CtsXmlResultReporter.ns, TARGET_ATTR, perfResultSummary.mTarget);
            }
            kXmlSerializer.attribute(CtsXmlResultReporter.ns, SCORETYPE_ATTR, perfResultSummary.mType);
            kXmlSerializer.attribute(CtsXmlResultReporter.ns, UNIT_ATTR, perfResultSummary.mUnit);
            kXmlSerializer.text(perfResultSummary.mValue);
            kXmlSerializer.endTag(CtsXmlResultReporter.ns, SUMMARY_TAG);
            if (this.mDetails != null) {
                PerfResultDetail[] perfResultDetailArray = this.parseDetails(this.mDetails);
                kXmlSerializer.startTag(CtsXmlResultReporter.ns, DETAILS_TAG);
                for (PerfResultDetail perfResultDetail : perfResultDetailArray) {
                    if (perfResultDetail == null) continue;
                    kXmlSerializer.startTag(CtsXmlResultReporter.ns, VALUEARRAY_TAG);
                    kXmlSerializer.attribute(CtsXmlResultReporter.ns, SOURCE_ATTR, perfResultDetail.mSource);
                    kXmlSerializer.attribute(CtsXmlResultReporter.ns, MESSAGE_ATTR, perfResultDetail.mMessage);
                    kXmlSerializer.attribute(CtsXmlResultReporter.ns, SCORETYPE_ATTR, perfResultDetail.mType);
                    kXmlSerializer.attribute(CtsXmlResultReporter.ns, UNIT_ATTR, perfResultDetail.mUnit);
                    for (String string : perfResultDetail.mValues) {
                        if (string == null) continue;
                        kXmlSerializer.startTag(CtsXmlResultReporter.ns, VALUE_TAG);
                        kXmlSerializer.text(string);
                        kXmlSerializer.endTag(CtsXmlResultReporter.ns, VALUE_TAG);
                    }
                    kXmlSerializer.endTag(CtsXmlResultReporter.ns, VALUEARRAY_TAG);
                }
                kXmlSerializer.endTag(CtsXmlResultReporter.ns, DETAILS_TAG);
            }
        }
        kXmlSerializer.endTag(CtsXmlResultReporter.ns, TAG);
    }

    private PerfResultSummary parseSummary(String string) {
        String[] stringArray = string.split(LOG_ELEM_SEPARATOR);
        PerfResultSummary perfResultSummary = new PerfResultSummary();
        if (stringArray.length < 5) {
            Log.w((String)TAG, (String)("wrong message " + string));
            return null;
        }
        perfResultSummary.mMessage = stringArray[0];
        perfResultSummary.mTarget = stringArray[1];
        perfResultSummary.mType = stringArray[2];
        perfResultSummary.mUnit = stringArray[3];
        perfResultSummary.mValue = stringArray[4];
        return perfResultSummary;
    }

    private PerfResultDetail[] parseDetails(String string) {
        String[] stringArray = string.split(LOG_SEPARATOR);
        PerfResultDetail[] perfResultDetailArray = new PerfResultDetail[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(LOG_ELEM_SEPARATOR);
            if (stringArray2.length < 5) {
                Log.w((String)TAG, (String)("wrong message " + stringArray[i]));
                continue;
            }
            PerfResultDetail perfResultDetail = new PerfResultDetail();
            perfResultDetail.mSource = stringArray2[0];
            perfResultDetail.mMessage = stringArray2[1];
            perfResultDetail.mType = stringArray2[2];
            perfResultDetail.mUnit = stringArray2[3];
            perfResultDetail.mValues = stringArray2[4].split(" ");
            perfResultDetailArray[i] = perfResultDetail;
        }
        return perfResultDetailArray;
    }

    private static String sanitizeStackTrace(String string) {
        if (string != null) {
            return string.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD]", "");
        }
        return null;
    }

    static String getFailureMessageFromStackTrace(String string) {
        int n;
        int n2 = string.indexOf(10);
        if (n2 != -1 && (n = string.indexOf(10, n2 + 1)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(TAG)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", TAG, xmlPullParser.getName()));
        }
        this.setName(this.getAttribute(xmlPullParser, NAME_ATTR));
        this.mResult = CtsTestStatus.getStatus(this.getAttribute(xmlPullParser, RESULT_ATTR));
        this.mStartTime = this.getAttribute(xmlPullParser, STARTTIME_ATTR);
        this.mEndTime = this.getAttribute(xmlPullParser, ENDTIME_ATTR);
        int n = xmlPullParser.next();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals(SCENE_TAG)) {
                this.mMessage = this.getAttribute(xmlPullParser, MESSAGE_ATTR);
            } else if (n == 2 && xmlPullParser.getName().equals(STACK_TAG)) {
                this.mStackTrace = xmlPullParser.nextText();
            } else if (n == 3 && xmlPullParser.getName().equals(TAG)) {
                return;
            }
            n = xmlPullParser.next();
        }
    }

    private class PerfResultDetail
    extends PerfResultCommon {
        public String mSource;
        public String[] mValues;

        private PerfResultDetail() {
        }
    }

    private class PerfResultSummary
    extends PerfResultCommon {
        public String mTarget;
        public String mValue;

        private PerfResultSummary() {
        }
    }

    public static class PerfResultCommon {
        public String mMessage;
        public String mType;
        public String mUnit;
    }
}

