/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.cts.tradefed.result.Test;
import com.android.cts.tradefed.result.TestSuite;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestPackageResult
extends AbstractXmlPullParser {
    static final String TAG = "TestPackage";
    private static final String DIGEST_ATTR = "digest";
    private static final String APP_PACKAGE_NAME_ATTR = "appPackageName";
    private static final String NAME_ATTR = "name";
    private static final String ns = CtsXmlResultReporter.ns;
    private static final String SIGNATURE_TEST_PKG = "android.tests.sigtest";
    private String mAppPackageName;
    private String mName;
    private String mDigest;
    private Map<String, String> mMetrics = new HashMap<String, String>();
    private TestSuite mSuiteRoot = new TestSuite(null);

    TestPackageResult() {
    }

    public void setAppPackageName(String string) {
        this.mAppPackageName = string;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setDigest(String string) {
        this.mDigest = string;
    }

    public String getDigest() {
        return this.mDigest;
    }

    public Collection<TestSuite> getTestSuites() {
        return this.mSuiteRoot.getTestSuites();
    }

    public Test insertTest(TestIdentifier testIdentifier) {
        return this.findTest(testIdentifier, true);
    }

    private Test findTest(TestIdentifier testIdentifier, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Collections.addAll(linkedList, testIdentifier.getClassName().split("\\."));
        if (linkedList.size() <= 0) {
            LogUtil.CLog.e((String)"Unrecognized package name format for test class '%s'", (Object[])new Object[]{testIdentifier.getClassName()});
            linkedList.add("UnknownTestClass");
        }
        String string = (String)linkedList.remove(linkedList.size() - 1);
        return this.mSuiteRoot.findTest(linkedList, string, testIdentifier.getTestName(), bl);
    }

    public Test findTest(TestIdentifier testIdentifier) {
        return this.findTest(testIdentifier, false);
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        kXmlSerializer.startTag(ns, TAG);
        this.serializeAttribute(kXmlSerializer, NAME_ATTR, this.mName);
        this.serializeAttribute(kXmlSerializer, APP_PACKAGE_NAME_ATTR, this.mAppPackageName);
        this.serializeAttribute(kXmlSerializer, DIGEST_ATTR, this.getDigest());
        if (SIGNATURE_TEST_PKG.equals(this.mName)) {
            kXmlSerializer.attribute(ns, "signatureCheck", "true");
        }
        this.mSuiteRoot.serialize(kXmlSerializer);
        kXmlSerializer.endTag(ns, TAG);
    }

    private void serializeAttribute(KXmlSerializer kXmlSerializer, String string, String string2) throws IOException {
        string2 = string2 == null ? "" : string2;
        kXmlSerializer.attribute(ns, string, string2);
    }

    @Override
    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(TAG)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", TAG, xmlPullParser.getName()));
        }
        this.setAppPackageName(this.getAttribute(xmlPullParser, APP_PACKAGE_NAME_ATTR));
        this.setName(this.getAttribute(xmlPullParser, NAME_ATTR));
        this.setDigest(this.getAttribute(xmlPullParser, DIGEST_ATTR));
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals("TestSuite")) {
                TestSuite testSuite = new TestSuite();
                testSuite.parse(xmlPullParser);
                this.mSuiteRoot.insertSuite(testSuite);
            }
            if (n == 3 && xmlPullParser.getName().equals(TAG)) {
                return;
            }
            n = xmlPullParser.next();
        }
    }

    public Collection<TestIdentifier> getTestsWithStatus(CtsTestStatus ctsTestStatus) {
        LinkedList<TestIdentifier> linkedList = new LinkedList<TestIdentifier>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        this.mSuiteRoot.addTestsWithStatus(linkedList, linkedList2, ctsTestStatus);
        return linkedList;
    }

    public void populateMetrics(Map<String, String> map) {
        String string;
        String string2 = map.get("packageName");
        if (string2 != null) {
            this.setName(string2);
        }
        if ((string = map.get("packageDigest")) != null) {
            this.setDigest(string);
        }
        if ("android.tests.devicesetup".equals(this.getAppPackageName())) {
            this.storeDeviceMetrics(map);
        } else {
            this.mMetrics.putAll(map);
        }
    }

    private void storeDeviceMetrics(Map<String, String> map) {
        if (this.mMetrics.isEmpty()) {
            this.mMetrics.putAll(map);
            return;
        }
        this.checkMetrics(map, "build_fingerprint", "build_model", "build_brand", "build_manufacturer", "build_board", "build_device", "buildName", "build_abi", "build_abi2", "screen_size");
    }

    private void checkMetrics(Map<String, String> map, String ... stringArray) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = this.mMetrics.get(entry.getKey());
            if (hashSet.contains(entry.getKey()) && string != null && !entry.getValue().equals(string)) {
                LogUtil.CLog.e((String)"Inconsistent info collected from devices. Current result has %s='%s', Received '%s'. Are you sharding or resuming a test run across different devices and/or builds?", (Object[])new Object[]{entry.getKey(), string, entry.getValue()});
                this.mMetrics.put(entry.getKey(), String.format("ERROR: Inconsistent results: %s, %s", entry.getValue(), string));
                continue;
            }
            this.mMetrics.put(entry.getKey(), entry.getValue());
        }
    }

    public void reportTestFailure(TestIdentifier testIdentifier, CtsTestStatus ctsTestStatus, String string) {
        Test test = this.findTest(testIdentifier);
        test.setResultStatus(ctsTestStatus);
        test.setStackTrace(string);
    }

    public void reportPerformanceResult(TestIdentifier testIdentifier, CtsTestStatus ctsTestStatus, String string, String string2) {
        Test test = this.findTest(testIdentifier);
        test.setResultStatus(ctsTestStatus);
        test.setSummary(string);
        test.setDetails(string2);
    }

    public void reportTestEnded(TestIdentifier testIdentifier) {
        Test test = this.findTest(testIdentifier);
        if (!test.getResult().equals((Object)CtsTestStatus.FAIL)) {
            test.setResultStatus(CtsTestStatus.PASS);
        }
        test.updateEndTime();
    }

    public int countTests(CtsTestStatus ctsTestStatus) {
        return this.mSuiteRoot.countTests(ctsTestStatus);
    }

    public Map<String, String> getMetrics() {
        return this.mMetrics;
    }
}

