/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.ITestResultRepo;
import com.android.cts.tradefed.result.ITestSummary;
import com.android.cts.tradefed.result.TestResults;
import com.android.cts.tradefed.result.TestSummaryXml;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultRepo
implements ITestResultRepo {
    private List<File> mResultDirs = new ArrayList<File>();

    public TestResultRepo(File file) {
        File[] fileArray = file.listFiles(new ResultDirFilter());
        if (fileArray != null) {
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, fileArray);
            Collections.sort(arrayList, new FileComparator());
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = new File((File)arrayList.get(i), "testResult.xml");
                if (!file2.exists()) continue;
                this.mResultDirs.add((File)arrayList.get(i));
            }
        }
    }

    @Override
    public File getReportDir(int n) {
        return this.mResultDirs.get(n);
    }

    private ITestSummary parseSummary(int n, File file) {
        TestSummaryXml testSummaryXml = new TestSummaryXml(n, file.getName());
        try {
            testSummaryXml.parse(new BufferedReader(new FileReader(new File(file, "testResult.xml"))));
            return testSummaryXml;
        }
        catch (AbstractXmlParser.ParseException parseException) {
            LogUtil.CLog.e((Throwable)parseException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.CLog.e((Throwable)fileNotFoundException);
        }
        return testSummaryXml;
    }

    @Override
    public List<ITestSummary> getSummaries() {
        ArrayList<ITestSummary> arrayList = new ArrayList<ITestSummary>(this.mResultDirs.size());
        for (int i = 0; i < this.mResultDirs.size(); ++i) {
            arrayList.add(this.parseSummary(i, this.mResultDirs.get(i)));
        }
        return arrayList;
    }

    @Override
    public TestResults getResult(int n) {
        if (this.mResultDirs.size() <= n) {
            LogUtil.CLog.e((String)"Session id %d does not exist", (Object[])new Object[]{n});
            return null;
        }
        try {
            TestResults testResults = new TestResults();
            File file = new File(this.mResultDirs.get(n), "testResult.xml");
            testResults.parse(new BufferedReader(new FileReader(file)));
            return testResults;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.CLog.e((String)"Could not find result file for session %d", (Object[])new Object[]{n});
        }
        catch (AbstractXmlParser.ParseException parseException) {
            LogUtil.CLog.e((String)"Failed to parse result file for session %d", (Object[])new Object[]{n});
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            return file.getName().compareTo(file2.getName());
        }
    }

    private class ResultDirFilter
    implements FileFilter {
        private ResultDirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

