/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.cts.tradefed.result.DeviceInfoResult;
import com.android.cts.tradefed.result.TestPackageResult;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestResults
extends AbstractXmlPullParser {
    private static final String ns = CtsXmlResultReporter.ns;
    static final String SUMMARY_TAG = "Summary";
    static final String PASS_ATTR = "pass";
    static final String TIMEOUT_ATTR = "timeout";
    static final String NOT_EXECUTED_ATTR = "notExecuted";
    static final String FAILED_ATTR = "failed";
    private Map<String, TestPackageResult> mPackageMap = new LinkedHashMap<String, TestPackageResult>();
    private DeviceInfoResult mDeviceInfo = new DeviceInfoResult();

    TestResults() {
    }

    @Override
    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals("DeviceInfo")) {
                this.mDeviceInfo.parse(xmlPullParser);
            }
            if (n == 2 && xmlPullParser.getName().equals("TestPackage")) {
                TestPackageResult testPackageResult = new TestPackageResult();
                testPackageResult.parse(xmlPullParser);
                if (testPackageResult.getAppPackageName() != null) {
                    this.mPackageMap.put(testPackageResult.getAppPackageName(), testPackageResult);
                } else {
                    LogUtil.CLog.w((String)"Found package with no app package name");
                }
            }
            n = xmlPullParser.next();
        }
    }

    public Collection<TestPackageResult> getPackages() {
        return this.mPackageMap.values();
    }

    public int countTests(CtsTestStatus ctsTestStatus) {
        int n = 0;
        for (TestPackageResult testPackageResult : this.mPackageMap.values()) {
            n += testPackageResult.countTests(ctsTestStatus);
        }
        return n;
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        this.mDeviceInfo.serialize(kXmlSerializer);
        this.serializeHostInfo(kXmlSerializer);
        this.serializeTestSummary(kXmlSerializer);
        ArrayList<TestPackageResult> arrayList = new ArrayList<TestPackageResult>(this.mPackageMap.values());
        Collections.sort(arrayList, new PkgComparator());
        for (TestPackageResult testPackageResult : arrayList) {
            testPackageResult.serialize(kXmlSerializer);
        }
    }

    private void serializeHostInfo(KXmlSerializer kXmlSerializer) throws IOException {
        kXmlSerializer.startTag(ns, "HostInfo");
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        kXmlSerializer.attribute(ns, "name", string);
        kXmlSerializer.startTag(ns, "Os");
        kXmlSerializer.attribute(ns, "name", System.getProperty("os.name"));
        kXmlSerializer.attribute(ns, "version", System.getProperty("os.version"));
        kXmlSerializer.attribute(ns, "arch", System.getProperty("os.arch"));
        kXmlSerializer.endTag(ns, "Os");
        kXmlSerializer.startTag(ns, "Java");
        kXmlSerializer.attribute(ns, "name", System.getProperty("java.vendor"));
        kXmlSerializer.attribute(ns, "version", System.getProperty("java.version"));
        kXmlSerializer.endTag(ns, "Java");
        kXmlSerializer.startTag(ns, "Cts");
        kXmlSerializer.attribute(ns, "version", "4.3_r2");
        kXmlSerializer.startTag(ns, "IntValue");
        kXmlSerializer.attribute(ns, "name", "testStatusTimeoutMs");
        kXmlSerializer.attribute(ns, "value", "600000");
        kXmlSerializer.endTag(ns, "IntValue");
        kXmlSerializer.endTag(ns, "Cts");
        kXmlSerializer.endTag(ns, "HostInfo");
    }

    private void serializeTestSummary(KXmlSerializer kXmlSerializer) throws IOException {
        kXmlSerializer.startTag(ns, SUMMARY_TAG);
        kXmlSerializer.attribute(ns, FAILED_ATTR, Integer.toString(this.countTests(CtsTestStatus.FAIL)));
        kXmlSerializer.attribute(ns, NOT_EXECUTED_ATTR, Integer.toString(this.countTests(CtsTestStatus.NOT_EXECUTED)));
        kXmlSerializer.attribute(ns, TIMEOUT_ATTR, "0");
        kXmlSerializer.attribute(ns, PASS_ATTR, Integer.toString(this.countTests(CtsTestStatus.PASS)));
        kXmlSerializer.endTag(ns, SUMMARY_TAG);
    }

    public TestPackageResult getOrCreatePackage(String string) {
        TestPackageResult testPackageResult = this.mPackageMap.get(string);
        if (testPackageResult == null) {
            testPackageResult = new TestPackageResult();
            testPackageResult.setAppPackageName(string);
            this.mPackageMap.put(string, testPackageResult);
        }
        return testPackageResult;
    }

    public void populateDeviceInfoMetrics(Map<String, String> map) {
        this.mDeviceInfo.populateMetrics(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PkgComparator
    implements Comparator<TestPackageResult> {
        private PkgComparator() {
        }

        @Override
        public int compare(TestPackageResult testPackageResult, TestPackageResult testPackageResult2) {
            return testPackageResult.getAppPackageName().compareTo(testPackageResult2.getAppPackageName());
        }
    }
}

