/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.ITestSummary;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TestSummaryXml
extends AbstractXmlPullParser
implements ITestSummary {
    private final int mId;
    private final String mTimestamp;
    private int mNumFailed = 0;
    private int mNumNotExecuted = 0;
    private int mNumPassed = 0;
    private String mPlan = "NA";
    private String mStartTime = "unknown";
    private String mDeviceSerials = "unknown";

    public TestSummaryXml(int n, String string) {
        this.mId = n;
        this.mTimestamp = string;
    }

    public int getId() {
        return this.mId;
    }

    public String getTimestamp() {
        return this.mTimestamp;
    }

    public int getNumIncomplete() {
        return this.mNumNotExecuted;
    }

    public int getNumFailed() {
        return this.mNumFailed;
    }

    public int getNumPassed() {
        return this.mNumPassed;
    }

    public String getTestPlan() {
        return this.mPlan;
    }

    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals("TestResult")) {
                this.mPlan = this.getAttribute(xmlPullParser, "testPlan");
                this.mStartTime = this.getAttribute(xmlPullParser, "starttime");
            } else if (n == 2 && xmlPullParser.getName().equals("BuildInfo")) {
                this.mDeviceSerials = this.getAttribute(xmlPullParser, "deviceID");
            } else if (n == 2 && xmlPullParser.getName().equals("Summary")) {
                this.mNumFailed = this.parseIntAttr(xmlPullParser, "failed") + this.parseIntAttr(xmlPullParser, "timeout");
                this.mNumNotExecuted = this.parseIntAttr(xmlPullParser, "notExecuted");
                this.mNumPassed = this.parseIntAttr(xmlPullParser, "pass");
                return;
            }
            n = xmlPullParser.next();
        }
        throw new XmlPullParserException("Could not find Summary tag");
    }

    public String getStartTime() {
        return this.mStartTime;
    }

    public String getDeviceSerials() {
        return this.mDeviceSerials;
    }
}

