/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.targetprep;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.targetprep.SettingsToggler;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.FileNotFoundException;

public class CtsRootDeviceSetup
implements ITargetPreparer {
    private static final String DEVICE_ADMIN_APK_FILE_NAME = "CtsDeviceAdmin.apk";

    public void setUp(ITestDevice iTestDevice, IBuildInfo iBuildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(iBuildInfo instanceof IFolderBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a IFolderBuildInfo");
        }
        LogUtil.CLog.i((String)"Setting up %s to run CTS tests", (Object[])new Object[]{iTestDevice.getSerialNumber()});
        IFolderBuildInfo iFolderBuildInfo = (IFolderBuildInfo)iBuildInfo;
        try {
            CtsBuildHelper ctsBuildHelper = new CtsBuildHelper(iFolderBuildInfo.getRootDir());
            if (!iTestDevice.enableAdbRoot()) {
                throw new TargetSetupError(String.format("Failed to set root on device %s.", iTestDevice.getSerialNumber()));
            }
            SettingsToggler.setSecureInt(iTestDevice, "mock_location", 1);
            this.enableDeviceAdmin(iTestDevice, ctsBuildHelper);
            iTestDevice.executeShellCommand("echo \"chrome --disable-fre\" > /data/local/chrome-command-line");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TargetSetupError("Invalid CTS installation", (Throwable)fileNotFoundException);
        }
    }

    private void enableDeviceAdmin(ITestDevice iTestDevice, CtsBuildHelper ctsBuildHelper) throws DeviceNotAvailableException, TargetSetupError, FileNotFoundException {
        String string = iTestDevice.installPackage(ctsBuildHelper.getTestApp(DEVICE_ADMIN_APK_FILE_NAME), true, new String[0]);
        if (string != null) {
            throw new TargetSetupError(String.format("Failed to install %s on device %s. Reason: %s", DEVICE_ADMIN_APK_FILE_NAME, iTestDevice.getSerialNumber(), string));
        }
    }
}

