/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.device.DeviceInfoCollector;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.PlanCreator;
import com.android.cts.tradefed.testtype.ITestPackageDef;
import com.android.cts.tradefed.testtype.ITestPackageRepo;
import com.android.cts.tradefed.testtype.ITestPlan;
import com.android.cts.tradefed.testtype.ResultFilter;
import com.android.cts.tradefed.testtype.TestPackageRepo;
import com.android.cts.tradefed.testtype.TestPlan;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtsTest
implements IDeviceTest,
IResumableTest,
IShardableTest,
IBuildReceiver {
    private static final String LOG_TAG = "CtsTest";
    public static final String PLAN_OPTION = "plan";
    private static final String PACKAGE_OPTION = "package";
    private static final String CLASS_OPTION = "class";
    private static final String METHOD_OPTION = "method";
    public static final String CONTINUE_OPTION = "continue-session";
    public static final String RUN_KNOWN_FAILURES_OPTION = "run-known-failures";
    public static final String PACKAGE_NAME_METRIC = "packageName";
    public static final String PACKAGE_DIGEST_METRIC = "packageDigest";
    private ITestDevice mDevice;
    @Option(name="plan", description="the test plan to run.", importance=Option.Importance.IF_UNSET)
    private String mPlanName = null;
    @Option(name="package", shortName=112, description="the test packages(s) to run.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mPackageNames = new ArrayList<String>();
    @Option(name="exclude-package", description="the test packages(s) to exclude from the run.")
    private Collection<String> mExcludedPackageNames = new ArrayList<String>();
    @Option(name="class", shortName=99, description="run a specific test class.", importance=Option.Importance.IF_UNSET)
    private String mClassName = null;
    @Option(name="method", shortName=109, description="run a specific test method, from given --class.", importance=Option.Importance.IF_UNSET)
    private String mMethodName = null;
    @Option(name="continue-session", description="continue a previous test session.", importance=Option.Importance.IF_UNSET)
    private Integer mContinueSessionId = null;
    @Option(name="skip-device-info", shortName=100, description="flag to control whether to collect info from device. Providing this flag will speed up test execution for short test runs but will result in required data being omitted from the test report.")
    private boolean mSkipDeviceInfo = false;
    @Option(name="resume", description="flag to attempt to automatically resume aborted test run on another connected device. ")
    private boolean mResume = false;
    @Option(name="shards", description="shard the tests to run into separately runnable chunks to execute on multiple devices concurrently.")
    private int mShards = 1;
    @Option(name="screenshot", description="flag for taking a screenshot of the device when test execution is complete.")
    private boolean mScreenshot = false;
    @Option(name="bugreport", shortName=98, description="take a bugreport after each failed test. Warning: can potentially use a lot of disk space.")
    private boolean mBugreport = false;
    @Option(name="run-known-failures", shortName=107, description="run tests including known failures")
    private boolean mIncludeKnownFailures;
    @Option(name="disable-reboot", description="Do not reboot device after running some amount of tests. Default behavior is to reboot.")
    private boolean mDisableReboot = false;
    @Option(name="reboot-wait-time", description="Additional wait time in ms after boot complete.")
    private int mRebootWaitTimeMSec = 120000;
    @Option(name="reboot-interval", description="Interval between each reboot in min.")
    private int mRebootIntervalMin = 30;
    @Option(name="screenshot-on-failure", description="take a screenshot on every test failure.")
    private boolean mScreenshotOnFailures = false;
    @Option(name="logcat-on-failure", description="take a logcat snapshot on every test failure. Unlike --bugreport, this can capturelogs even if connection with device has been lost, as well as being much more performant.")
    private boolean mLogcatOnFailures = false;
    @Option(name="logcat-on-failure-size", description="The max number of logcat data in bytes to capture when --logcat-on-failure is on. Should be an amount that can comfortably fit in memory.")
    private int mMaxLogcatBytes = 512000;
    private long mPrevRebootTime;
    private List<TestPackage> mRemainingTestPkgs = null;
    private CtsBuildHelper mCtsBuild = null;
    private IBuildInfo mBuildInfo = null;

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    void setPlanName(String string) {
        this.mPlanName = string;
    }

    void setSkipDeviceInfo(boolean bl) {
        this.mSkipDeviceInfo = bl;
    }

    void addPackageName(String string) {
        this.mPackageNames.add(string);
    }

    void addExcludedPackageName(String string) {
        this.mExcludedPackageNames.add(string);
    }

    void setClassName(String string) {
        this.mClassName = string;
    }

    void setMethodName(String string) {
        this.mMethodName = string;
    }

    void setContinueSessionId(int n) {
        this.mContinueSessionId = n;
    }

    public boolean isResumable() {
        return this.mResume;
    }

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
        this.mBuildInfo = iBuildInfo;
    }

    void setBuildHelper(CtsBuildHelper ctsBuildHelper) {
        this.mCtsBuild = ctsBuildHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ITestInvocationListener object) throws DeviceNotAvailableException {
        Object object2;
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("missing device");
        }
        if (this.mRemainingTestPkgs == null) {
            this.checkFields();
            this.mRemainingTestPkgs = this.buildTestsToRun();
        }
        if (this.mBugreport) {
            object2 = new FailedTestBugreportGenerator((ITestInvocationListener)object, this.getDevice());
            object = object2;
        }
        if (this.mScreenshotOnFailures) {
            object2 = new FailedTestScreenshotGenerator((ITestInvocationListener)object, this.getDevice());
            object = object2;
        }
        if (this.mLogcatOnFailures) {
            object2 = new FailedTestLogcatGenerator((ITestInvocationListener)object, this.getDevice(), this.mMaxLogcatBytes);
            object = object2;
        }
        object2 = this.getPrerequisiteApks(this.mRemainingTestPkgs);
        Collection<String> collection = this.getPrerequisitePackageNames(this.mRemainingTestPkgs);
        ResultFilter resultFilter = new ResultFilter((ITestInvocationListener)object, this.mRemainingTestPkgs);
        try {
            TestPackage testPackage;
            this.installPrerequisiteApks((Collection<String>)object2);
            this.collectDeviceInfo(this.getDevice(), this.mCtsBuild, (ITestInvocationListener)object);
            if (this.mRemainingTestPkgs.size() > 1 && !this.mDisableReboot) {
                Log.i((String)LOG_TAG, (String)"Initial reboot for multiple packages");
                this.rebootDevice();
            }
            this.mPrevRebootTime = System.currentTimeMillis();
            while (!this.mRemainingTestPkgs.isEmpty()) {
                testPackage = this.mRemainingTestPkgs.get(0);
                IRemoteTest iRemoteTest = testPackage.getTestForPackage();
                if (iRemoteTest instanceof IDeviceTest) {
                    ((IDeviceTest)iRemoteTest).setDevice(this.getDevice());
                }
                if (iRemoteTest instanceof IBuildReceiver) {
                    ((IBuildReceiver)iRemoteTest).setBuild(this.mBuildInfo);
                }
                this.forwardPackageDetails(testPackage.getPackageDef(), (ITestInvocationListener)object);
                iRemoteTest.run((ITestInvocationListener)resultFilter);
                this.mRemainingTestPkgs.remove(0);
                if (this.mRemainingTestPkgs.size() <= 0) continue;
                this.rebootIfNecessary(testPackage, this.mRemainingTestPkgs.get(0));
                this.changeToHomeScreen();
            }
            if (this.mScreenshot) {
                testPackage = this.getDevice().getScreenshot();
                try {
                    object.testLog("screenshot", LogDataType.PNG, (InputStreamSource)testPackage);
                }
                finally {
                    testPackage.cancel();
                }
            }
            this.uninstallPrequisiteApks(collection);
        }
        finally {
            resultFilter.reportUnexecutedTests();
        }
    }

    private void rebootIfNecessary(TestPackage testPackage, TestPackage testPackage2) throws DeviceNotAvailableException {
        long l;
        List<String> list = Arrays.asList("CtsMediaTestCases", "CtsAccessibilityTestCases");
        List<String> list2 = Arrays.asList("CtsAnimationTestCases", "CtsGraphicsTestCases", "CtsViewTestCases", "CtsWidgetTestCases");
        long l2 = this.mRebootIntervalMin * 60 * 1000;
        if (this.mDevice.getSerialNumber().startsWith("emulator-")) {
            return;
        }
        if (!this.mDisableReboot && ((l = System.currentTimeMillis()) - this.mPrevRebootTime > l2 || list.contains(testPackage.getPackageDef().getName()) || list2.contains(testPackage2.getPackageDef().getName()))) {
            Log.i((String)LOG_TAG, (String)String.format("Rebooting after running package %s, before package %s", testPackage.getPackageDef().getName(), testPackage2.getPackageDef().getName()));
            this.rebootDevice();
            this.mPrevRebootTime = System.currentTimeMillis();
        }
    }

    private void rebootDevice() throws DeviceNotAvailableException {
        TestDeviceOptions testDeviceOptions = this.mDevice.getOptions();
        int n = testDeviceOptions.getRebootTimeout();
        long l = testDeviceOptions.getOnlineTimeout();
        testDeviceOptions.setRebootTimeout(600000);
        testDeviceOptions.setOnlineTimeout(600000L);
        this.mDevice.setOptions(testDeviceOptions);
        this.mDevice.reboot();
        testDeviceOptions.setRebootTimeout(n);
        testDeviceOptions.setOnlineTimeout(l);
        this.mDevice.setOptions(testDeviceOptions);
        Log.i((String)LOG_TAG, (String)"Rebooting done");
        try {
            Thread.sleep(this.mRebootWaitTimeMSec);
        }
        catch (InterruptedException interruptedException) {
            Log.i((String)LOG_TAG, (String)"Boot wait interrupted");
        }
    }

    private void changeToHomeScreen() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand("input keyevent 3");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<TestPackage> buildTestsToRun() {
        LinkedList<TestPackage> linkedList = new LinkedList<TestPackage>();
        try {
            ITestPackageRepo iTestPackageRepo = this.createTestCaseRepo();
            Collection<ITestPackageDef> collection = this.getTestPackagesToRun(iTestPackageRepo);
            for (ITestPackageDef iTestPackageDef : collection) {
                this.addTestPackage(linkedList, iTestPackageDef);
            }
            if (linkedList.isEmpty()) {
                Log.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)LOG_TAG, (String)"No tests to run");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("failed to find CTS plan file", fileNotFoundException);
        }
        catch (AbstractXmlParser.ParseException parseException) {
            throw new IllegalArgumentException("failed to parse CTS plan file", parseException);
        }
        catch (ConfigurationException configurationException) {
            throw new IllegalArgumentException("failed to process arguments", configurationException);
        }
        return linkedList;
    }

    private void addTestPackage(List<TestPackage> list, ITestPackageDef iTestPackageDef) {
        IRemoteTest iRemoteTest = iTestPackageDef.createTest(this.mCtsBuild.getTestCasesDir());
        if (iRemoteTest != null) {
            Collection<TestIdentifier> collection = iTestPackageDef.getTests();
            list.add(new TestPackage(iTestPackageDef, iRemoteTest, collection));
        }
    }

    private Collection<ITestPackageDef> getTestPackagesToRun(ITestPackageRepo iTestPackageRepo) throws AbstractXmlParser.ParseException, FileNotFoundException, ConfigurationException {
        LinkedHashSet<ITestPackageDef> linkedHashSet = new LinkedHashSet<ITestPackageDef>();
        if (this.mPlanName != null) {
            Log.i((String)LOG_TAG, (String)String.format("Executing CTS test plan %s", this.mPlanName));
            File file = this.mCtsBuild.getTestPlanFile(this.mPlanName);
            ITestPlan iTestPlan = this.createPlan(this.mPlanName);
            iTestPlan.parse(this.createXmlStream(file));
            for (String string : iTestPlan.getTestUris()) {
                if (this.mExcludedPackageNames.contains(string)) continue;
                ITestPackageDef iTestPackageDef = iTestPackageRepo.getTestPackage(string);
                iTestPackageDef.setExcludedTestFilter(iTestPlan.getExcludedTestFilter(string));
                linkedHashSet.add(iTestPackageDef);
            }
        } else if (this.mPackageNames.size() > 0) {
            Log.i((String)LOG_TAG, (String)String.format("Executing CTS test packages %s", this.mPackageNames));
            for (String string : this.mPackageNames) {
                ITestPackageDef iTestPackageDef = iTestPackageRepo.getTestPackage(string);
                if (iTestPackageDef != null) {
                    linkedHashSet.add(iTestPackageDef);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Could not find test package %s. Use 'list packages' to see available packages.", string));
            }
        } else if (this.mClassName != null) {
            Log.i((String)LOG_TAG, (String)String.format("Executing CTS test class %s", this.mClassName));
            String string = iTestPackageRepo.findPackageForTest(this.mClassName);
            if (string != null) {
                ITestPackageDef iTestPackageDef = iTestPackageRepo.getTestPackage(string);
                iTestPackageDef.setClassName(this.mClassName, this.mMethodName);
                linkedHashSet.add(iTestPackageDef);
            } else {
                Log.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)LOG_TAG, (String)String.format("Could not find package for test class %s", this.mClassName));
            }
        } else if (this.mContinueSessionId != null) {
            String string = Long.toString(System.currentTimeMillis());
            PlanCreator planCreator = new PlanCreator(string, this.mContinueSessionId, CtsTestStatus.NOT_EXECUTED);
            ITestPlan iTestPlan = this.createPlan(planCreator);
            for (String string2 : iTestPlan.getTestUris()) {
                if (this.mExcludedPackageNames.contains(string2)) continue;
                ITestPackageDef iTestPackageDef = iTestPackageRepo.getTestPackage(string2);
                iTestPackageDef.setExcludedTestFilter(iTestPlan.getExcludedTestFilter(string2));
                linkedHashSet.add(iTestPackageDef);
            }
        } else {
            throw new IllegalStateException("nothing to run?");
        }
        return linkedHashSet;
    }

    private Collection<String> getPrerequisitePackageNames(List<TestPackage> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TestPackage testPackage : list) {
            String string = testPackage.mPackageDef.getTargetPackageName();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private Collection<String> getPrerequisiteApks(List<TestPackage> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TestPackage testPackage : list) {
            String string = testPackage.mPackageDef.getTargetApkName();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private void installPrerequisiteApks(Collection<String> collection) throws DeviceNotAvailableException {
        for (String string : collection) {
            try {
                File file = this.mCtsBuild.getTestApp(string);
                String string2 = this.getDevice().installPackage(file, true, new String[0]);
                if (string2 == null) continue;
                LogUtil.CLog.e((String)"Failed to install %s. Reason: %s", (Object[])new Object[]{string, string2});
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogUtil.CLog.e((String)"Could not find test apk %s", (Object[])new Object[]{string});
            }
        }
    }

    private void uninstallPrequisiteApks(Collection<String> collection) throws DeviceNotAvailableException {
        for (String string : collection) {
            this.getDevice().uninstallPackage(string);
        }
    }

    public Collection<IRemoteTest> split() {
        CtsTest ctsTest;
        if (this.mShards <= 1) {
            return null;
        }
        this.checkFields();
        List<TestPackage> list = this.buildTestsToRun();
        if (list.size() <= 1) {
            Log.w((String)LOG_TAG, (String)"no tests to shard!");
            return null;
        }
        LinkedList<IRemoteTest> linkedList = new LinkedList<IRemoteTest>();
        for (int i = 0; i < this.mShards && i < list.size(); ++i) {
            ctsTest = new CtsTest();
            ctsTest.mRemainingTestPkgs = new LinkedList<TestPackage>();
            linkedList.add((IRemoteTest)ctsTest);
        }
        while (!list.isEmpty()) {
            TestPackage testPackage = list.remove(0);
            ctsTest = (CtsTest)linkedList.poll();
            ctsTest.mRemainingTestPkgs.add(testPackage);
            linkedList.add((IRemoteTest)ctsTest);
        }
        return linkedList;
    }

    void collectDeviceInfo(ITestDevice iTestDevice, CtsBuildHelper ctsBuildHelper, ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (!this.mSkipDeviceInfo) {
            DeviceInfoCollector.collectDeviceInfo(iTestDevice, ctsBuildHelper.getTestCasesDir(), iTestInvocationListener);
        }
    }

    ITestPackageRepo createTestCaseRepo() {
        return new TestPackageRepo(this.mCtsBuild.getTestCasesDir(), this.mIncludeKnownFailures);
    }

    ITestPlan createPlan(String string) {
        return new TestPlan(string);
    }

    ITestPlan createPlan(PlanCreator planCreator) throws ConfigurationException {
        return planCreator.createDerivedPlan(this.mCtsBuild);
    }

    InputStream createXmlStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    private void checkFields() {
        boolean bl = this.xor(this.mPlanName != null, this.mPackageNames.size() > 0, this.mClassName != null, this.mContinueSessionId != null);
        if (!bl) {
            throw new IllegalArgumentException(String.format("Ambiguous or missing arguments. One and only one of --%s --%s(s), --%s or --%s to run can be specified", PLAN_OPTION, PACKAGE_OPTION, CLASS_OPTION, CONTINUE_OPTION));
        }
        if (this.mMethodName != null && this.mClassName == null) {
            throw new IllegalArgumentException(String.format("Must specify --%s when --%s is used", CLASS_OPTION, METHOD_OPTION));
        }
        if (this.mCtsBuild == null) {
            throw new IllegalArgumentException("missing CTS build");
        }
    }

    private boolean xor(boolean ... blArray) {
        boolean bl = blArray[0];
        for (int i = 1; i < blArray.length; ++i) {
            if (bl && blArray[i]) {
                return false;
            }
            bl |= blArray[i];
        }
        return bl;
    }

    private void forwardPackageDetails(ITestPackageDef iTestPackageDef, ITestInvocationListener iTestInvocationListener) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(PACKAGE_NAME_METRIC, iTestPackageDef.getName());
        hashMap.put(PACKAGE_DIGEST_METRIC, iTestPackageDef.getDigest());
        iTestInvocationListener.testRunStarted(iTestPackageDef.getUri(), 0);
        iTestInvocationListener.testRunEnded(0L, hashMap);
    }

    private static class FailedTestScreenshotGenerator
    extends ResultForwarder {
        private ITestDevice mDevice;

        public FailedTestScreenshotGenerator(ITestInvocationListener iTestInvocationListener, ITestDevice iTestDevice) {
            super(new ITestInvocationListener[]{iTestInvocationListener});
            this.mDevice = iTestDevice;
        }

        public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
            super.testFailed(testFailure, testIdentifier, string);
            try {
                InputStreamSource inputStreamSource = this.mDevice.getScreenshot();
                super.testLog(String.format("screenshot-%s_%s", testIdentifier.getClassName(), testIdentifier.getTestName()), LogDataType.PNG, inputStreamSource);
                inputStreamSource.cancel();
            }
            catch (DeviceNotAvailableException deviceNotAvailableException) {
                LogUtil.CLog.e((String)"Device %s became unavailable while capturing screenshot, %s", (Object[])new Object[]{this.mDevice.getSerialNumber(), deviceNotAvailableException.toString()});
            }
        }
    }

    private static class FailedTestLogcatGenerator
    extends ResultForwarder {
        private ITestDevice mDevice;
        private int mNumLogcatBytes;

        public FailedTestLogcatGenerator(ITestInvocationListener iTestInvocationListener, ITestDevice iTestDevice, int n) {
            super(new ITestInvocationListener[]{iTestInvocationListener});
            this.mDevice = iTestDevice;
            this.mNumLogcatBytes = n;
        }

        public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
            super.testFailed(testFailure, testIdentifier, string);
            RunUtil.getDefault().sleep(10L);
            InputStreamSource inputStreamSource = this.mDevice.getLogcat(this.mNumLogcatBytes);
            super.testLog(String.format("logcat-%s_%s", testIdentifier.getClassName(), testIdentifier.getTestName()), LogDataType.TEXT, inputStreamSource);
            inputStreamSource.cancel();
        }
    }

    private static class FailedTestBugreportGenerator
    extends ResultForwarder {
        private ITestDevice mDevice;

        public FailedTestBugreportGenerator(ITestInvocationListener iTestInvocationListener, ITestDevice iTestDevice) {
            super(new ITestInvocationListener[]{iTestInvocationListener});
            this.mDevice = iTestDevice;
        }

        public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
            super.testFailed(testFailure, testIdentifier, string);
            InputStreamSource inputStreamSource = this.mDevice.getBugreport();
            super.testLog(String.format("bug-%s_%s", testIdentifier.getClassName(), testIdentifier.getTestName()), LogDataType.TEXT, inputStreamSource);
            inputStreamSource.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestPackage {
        private final IRemoteTest mTestForPackage;
        private final Collection<TestIdentifier> mKnownTests;
        private final ITestPackageDef mPackageDef;

        TestPackage(ITestPackageDef iTestPackageDef, IRemoteTest iRemoteTest, Collection<TestIdentifier> collection) {
            this.mPackageDef = iTestPackageDef;
            this.mTestForPackage = iRemoteTest;
            this.mKnownTests = collection;
        }

        IRemoteTest getTestForPackage() {
            return this.mTestForPackage;
        }

        Collection<TestIdentifier> getKnownTests() {
            return this.mKnownTests;
        }

        ITestPackageDef getPackageDef() {
            return this.mPackageDef;
        }

        String getTestRunName() {
            return this.mPackageDef.getUri();
        }
    }
}

