/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.InstrumentationTest;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;

public class InstrumentationApkTest
extends InstrumentationTest
implements IBuildReceiver {
    private static final String LOG_TAG = "InstrumentationApkTest";
    private Collection<String> mInstallFileNames = new ArrayList<String>();
    private Collection<String> mUninstallPackages = new ArrayList<String>();
    private CtsBuildHelper mCtsBuild = null;

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    public void addInstallApk(String string, String string2) {
        this.mInstallFileNames.add(string);
        this.mUninstallPackages.add(string2);
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull((String)"missing device", (Object)this.getDevice());
        Assert.assertNotNull((String)"missing build", (Object)this.mCtsBuild);
        for (String string : this.mInstallFileNames) {
            Log.d((String)LOG_TAG, (String)String.format("Installing %s on %s", string, this.getDevice().getSerialNumber()));
            try {
                String string2 = this.getDevice().installPackage(this.mCtsBuild.getTestApp(string), true, new String[0]);
                Assert.assertNull((String)String.format("Failed to install %s on %s. Reason: %s", string, this.getDevice().getSerialNumber(), string2), (Object)string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Assert.fail((String)String.format("Could not find file %s", string));
            }
        }
        super.run(iTestInvocationListener);
        for (String string : this.mUninstallPackages) {
            Log.d((String)LOG_TAG, (String)String.format("Uninstalling %s on %s", string, this.getDevice().getSerialNumber()));
            this.getDevice().uninstallPackage(string);
        }
    }
}

