/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.ddmlib.testrunner.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFilter {
    private final Set<String> mExcludedClasses = new HashSet<String>();
    private final Set<TestIdentifier> mExcludedTests = new HashSet<TestIdentifier>();
    private String mIncludedClass = null;
    private String mIncludedMethod = null;

    public void addExcludedClass(String string) {
        this.mExcludedClasses.add(string);
    }

    public void addExcludedTest(TestIdentifier testIdentifier) {
        this.mExcludedTests.add(testIdentifier);
    }

    Set<String> getExcludedClasses() {
        return this.mExcludedClasses;
    }

    Set<TestIdentifier> getExcludedTests() {
        return this.mExcludedTests;
    }

    public void setTestInclusion(String string, String string2) {
        this.mIncludedClass = string;
        this.mIncludedMethod = string2;
    }

    public Collection<TestIdentifier> filter(Collection<TestIdentifier> collection) {
        ArrayList<TestIdentifier> arrayList = new ArrayList<TestIdentifier>(collection.size());
        for (TestIdentifier testIdentifier : collection) {
            if (this.mIncludedClass != null && !testIdentifier.getClassName().equals(this.mIncludedClass) || this.mIncludedMethod != null && !testIdentifier.getTestName().equals(this.mIncludedMethod) || this.mExcludedClasses.contains(testIdentifier.getClassName()) || this.mExcludedTests.contains(testIdentifier)) continue;
            arrayList.add(testIdentifier);
        }
        Collections.sort(arrayList, new TestIdComparator());
        return arrayList;
    }

    public boolean hasExclusion() {
        return !this.mExcludedClasses.isEmpty() || !this.mExcludedTests.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestIdComparator
    implements Comparator<TestIdentifier> {
        private TestIdComparator() {
        }

        @Override
        public int compare(TestIdentifier testIdentifier, TestIdentifier testIdentifier2) {
            return testIdentifier.toString().compareTo(testIdentifier2.toString());
        }
    }
}

