/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.ITestPackageDef;
import com.android.cts.tradefed.testtype.ITestPackageRepo;
import com.android.cts.tradefed.testtype.TestPackageDef;
import com.android.cts.tradefed.testtype.TestPackageXmlParser;
import com.android.ddmlib.Log;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPackageRepo
implements ITestPackageRepo {
    private static final String LOG_TAG = "TestCaseRepo";
    private final File mTestCaseDir;
    private final Map<String, TestPackageDef> mTestMap;
    private final boolean mIncludeKnownFailures;

    public TestPackageRepo(File file, boolean bl) {
        this.mTestCaseDir = file;
        this.mTestMap = new Hashtable<String, TestPackageDef>();
        this.mIncludeKnownFailures = bl;
        this.parse(this.mTestCaseDir);
    }

    private void parse(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles(new XmlFilter())) {
            this.parseTestFromXml(file2);
        }
    }

    private void parseTestFromXml(File file) {
        TestPackageXmlParser testPackageXmlParser = new TestPackageXmlParser(this.mIncludeKnownFailures);
        try {
            testPackageXmlParser.parse(this.createStreamFromFile(file));
            TestPackageDef testPackageDef = testPackageXmlParser.getTestPackageDef();
            if (testPackageDef != null) {
                this.mTestMap.put(testPackageDef.getUri(), testPackageDef);
            } else {
                Log.w((String)LOG_TAG, (String)String.format("Could not find test package info in xml file %s", file.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find test case xml file %s", file.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)fileNotFoundException);
        }
        catch (AbstractXmlParser.ParseException parseException) {
            Log.e((String)LOG_TAG, (String)String.format("Failed to parse test case xml file %s", file.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)parseException);
        }
    }

    InputStream createStreamFromFile(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public ITestPackageDef getTestPackage(String string) {
        return this.mTestMap.get(string);
    }

    @Override
    public String findPackageForTest(String string) {
        for (Map.Entry<String, TestPackageDef> entry : this.mTestMap.entrySet()) {
            if (!entry.getValue().isKnownTestClass(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Collection<String> getPackageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.mTestMap.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    private static class XmlFilter
    implements FilenameFilter {
        private XmlFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".xml");
        }
    }
}

