/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.TestPackageDef;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class TestPackageXmlParser
extends AbstractXmlParser {
    private static final String LOG_TAG = "TestPackageXmlParser";
    private final boolean mIncludeKnownFailures;
    private TestPackageDef mPackageDef;

    public TestPackageXmlParser(boolean bl) {
        this.mIncludeKnownFailures = bl;
    }

    protected DefaultHandler createXmlHandler() {
        return new TestPackageHandler();
    }

    public TestPackageDef getTestPackageDef() {
        return this.mPackageDef;
    }

    private class TestPackageHandler
    extends DefaultHandler {
        private static final String TEST_PACKAGE_TAG = "TestPackage";
        private static final String TEST_SUITE_TAG = "TestSuite";
        private static final String TEST_CASE_TAG = "TestCase";
        private static final String TEST_TAG = "Test";
        private Stack<String> mClassNameStack = new Stack();

        private TestPackageHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (TEST_PACKAGE_TAG.equals(string2)) {
                String string4 = attributes.getValue("appPackageName");
                String string5 = attributes.getValue("appNameSpace");
                String string6 = attributes.getValue("name");
                String string7 = attributes.getValue("runner");
                String string8 = attributes.getValue("jarPath");
                String string9 = attributes.getValue("signatureCheck");
                String string10 = attributes.getValue("javaPackageFilter");
                String string11 = attributes.getValue("targetBinaryName");
                String string12 = attributes.getValue("targetNameSpace");
                TestPackageXmlParser.this.mPackageDef = new TestPackageDef();
                TestPackageXmlParser.this.mPackageDef.setUri(string4);
                TestPackageXmlParser.this.mPackageDef.setAppNameSpace(string5);
                TestPackageXmlParser.this.mPackageDef.setName(string6);
                TestPackageXmlParser.this.mPackageDef.setRunner(string7);
                TestPackageXmlParser.this.mPackageDef.setTestType(this.getTestType(attributes));
                TestPackageXmlParser.this.mPackageDef.setJarPath(string8);
                TestPackageXmlParser.this.mPackageDef.setIsSignatureCheck(this.parseBoolean(string9));
                TestPackageXmlParser.this.mPackageDef.setTestPackageName(string10);
                TestPackageXmlParser.this.mPackageDef.setTargetBinaryName(string11);
                TestPackageXmlParser.this.mPackageDef.setTargetNameSpace(string12);
                this.mClassNameStack = new Stack();
            } else if (TEST_SUITE_TAG.equals(string2)) {
                String string13 = attributes.getValue("name");
                if (string13 != null) {
                    this.mClassNameStack.push(string13);
                } else {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: missing 'name' attribute for '%s'", TEST_SUITE_TAG));
                }
            } else if (TEST_CASE_TAG.equals(string2)) {
                String string14 = attributes.getValue("name");
                if (string14 != null) {
                    this.mClassNameStack.push(string14);
                } else {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: missing 'name' attribute for '%s'", TEST_CASE_TAG));
                }
            } else if (TEST_TAG.equals(string2)) {
                String string15 = attributes.getValue("name");
                if (TestPackageXmlParser.this.mPackageDef == null) {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: encountered a '%s' tag not enclosed within a '%s' tag", TEST_TAG, TEST_PACKAGE_TAG));
                } else if (string15 == null) {
                    Log.e((String)TestPackageXmlParser.LOG_TAG, (String)String.format("Invalid XML: missing 'name' attribute for '%s'", TEST_TAG));
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Iterator iterator = this.mClassNameStack.iterator();
                    while (iterator.hasNext()) {
                        stringBuilder.append((String)iterator.next());
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(".");
                    }
                    int n = -1;
                    String string16 = attributes.getValue("timeout");
                    if (string16 != null) {
                        n = Integer.parseInt(string16);
                    }
                    TestIdentifier testIdentifier = new TestIdentifier(stringBuilder.toString(), string15);
                    boolean bl = "failure".equals(attributes.getValue("expectation"));
                    if (!bl || TestPackageXmlParser.this.mIncludeKnownFailures) {
                        TestPackageXmlParser.this.mPackageDef.addTest(testIdentifier, n);
                    }
                }
            }
        }

        private String getTestType(Attributes attributes) {
            if (this.parseBoolean(attributes.getValue("hostSideOnly"))) {
                return "hostSideOnly";
            }
            if (this.parseBoolean(attributes.getValue("vmHostTest"))) {
                return "vmHostTest";
            }
            return attributes.getValue("testType");
        }

        public void endElement(String string, String string2, String string3) {
            if (TEST_SUITE_TAG.equals(string2) || TEST_CASE_TAG.equals(string2)) {
                this.mClassNameStack.pop();
            }
        }

        private boolean parseBoolean(String string) {
            return string != null && Boolean.parseBoolean(string);
        }
    }
}

