/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.testtype.WrappedGTestResultParser;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import java.io.File;
import java.io.FileNotFoundException;

public class WrappedGTest
implements IBuildReceiver,
IDeviceTest,
IRemoteTest {
    private int mMaxTestTimeMs = 60000;
    private CtsBuildHelper mCtsBuild;
    private ITestDevice mDevice;
    private final String mAppNameSpace;
    private final String mRunner;
    private final String mName;
    private final String mUri;

    public WrappedGTest(String string, String string2, String string3, String string4) {
        this.mAppNameSpace = string;
        this.mRunner = string4;
        this.mName = string3;
        this.mUri = string2;
    }

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.installTest()) {
            this.runTest((ITestRunListener)iTestInvocationListener);
            this.uninstallTest();
        } else {
            LogUtil.CLog.e((String)"Failed to install test");
        }
    }

    private boolean installTest() throws DeviceNotAvailableException {
        try {
            File file = this.mCtsBuild.getTestApp(String.format("%s.apk", this.mName));
            String string = this.mDevice.installPackage(file, true, new String[0]);
            if (string != null) {
                LogUtil.CLog.e((String)"Failed to install %s.apk on %s. Reason: %s", (Object[])new Object[]{this.mName, this.mDevice.getSerialNumber(), string});
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.CLog.e((String)"Package %s.apk not found", (Object[])new Object[]{this.mName});
            return false;
        }
        return true;
    }

    private void runTest(ITestRunListener iTestRunListener) throws DeviceNotAvailableException {
        WrappedGTestResultParser wrappedGTestResultParser = new WrappedGTestResultParser(this.mUri, iTestRunListener);
        wrappedGTestResultParser.setFakePackagePrefix(this.mUri + ".");
        try {
            String string = String.format("am instrument -w %s/.%s", this.mAppNameSpace, this.mRunner);
            this.mDevice.executeShellCommand(string, (IShellOutputReceiver)wrappedGTestResultParser, this.mMaxTestTimeMs, 0);
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            wrappedGTestResultParser.flush();
            throw deviceNotAvailableException;
        }
        catch (RuntimeException runtimeException) {
            wrappedGTestResultParser.flush();
            throw runtimeException;
        }
    }

    private void uninstallTest() throws DeviceNotAvailableException {
        this.mDevice.uninstallPackage(this.mAppNameSpace);
    }
}

