/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IAppBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppBuildInfo
extends BuildInfo
implements IAppBuildInfo {
    private List<VersionedFile> mAppPackageFiles = new ArrayList<VersionedFile>();

    public AppBuildInfo(String buildId, String testTarget, String buildName) {
        super(buildId, testTarget, buildName);
    }

    public AppBuildInfo(BuildInfo buildToCopy) {
        super(buildToCopy);
    }

    @Override
    public List<VersionedFile> getAppPackageFiles() {
        ArrayList<VersionedFile> listCopy = new ArrayList<VersionedFile>(this.mAppPackageFiles.size());
        listCopy.addAll(this.mAppPackageFiles);
        return listCopy;
    }

    @Override
    public void addAppPackageFile(File appPackageFile, String version) {
        this.mAppPackageFiles.add(new VersionedFile(appPackageFile, version));
    }

    @Override
    public void cleanUp() {
        for (VersionedFile appPackageFile : this.mAppPackageFiles) {
            appPackageFile.getFile().delete();
        }
        this.mAppPackageFiles.clear();
    }

    @Override
    public IBuildInfo clone() {
        AppBuildInfo copy = new AppBuildInfo(this.getBuildId(), this.getTestTag(), this.getBuildTargetName());
        copy.addAllBuildAttributes(this);
        try {
            for (VersionedFile origVerFile : this.mAppPackageFiles) {
                File origFile = origVerFile.getFile();
                File copyFile = FileUtil.createTempFile(FileUtil.getBaseName(origFile.getName()), FileUtil.getExtension(origFile.getName()));
                copyFile.delete();
                FileUtil.hardlinkFile(origFile, copyFile);
                copy.addAppPackageFile(copyFile, origVerFile.getVersion());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        copy.setBuildBranch(this.getBuildBranch());
        copy.setBuildFlavor(this.getBuildFlavor());
        return copy;
    }
}

