/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IAppBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.NullUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDeviceBuildInfo
extends BuildInfo
implements IDeviceBuildInfo,
IAppBuildInfo {
    private IDeviceBuildInfo mDeviceBuild;
    private IAppBuildInfo mAppBuildInfo;

    public AppDeviceBuildInfo(String buildId, String testTarget, String buildName) {
        super(buildId, testTarget, buildName);
    }

    public IDeviceBuildInfo getDeviceBuildInfo() {
        return this.mDeviceBuild;
    }

    public IAppBuildInfo getAppBuildInfo() {
        return this.mAppBuildInfo;
    }

    @Override
    public String getDeviceBuildId() {
        return this.mDeviceBuild.getDeviceBuildId();
    }

    @Override
    public File getDeviceImageFile() {
        return this.mDeviceBuild.getDeviceImageFile();
    }

    @Override
    public String getDeviceImageVersion() {
        return this.mDeviceBuild.getDeviceImageVersion();
    }

    @Override
    public void setDeviceImageFile(File deviceImageFile, String version) {
        this.mDeviceBuild.setDeviceImageFile(deviceImageFile, version);
    }

    @Override
    public File getUserDataImageFile() {
        return this.mDeviceBuild.getUserDataImageFile();
    }

    @Override
    public String getUserDataImageVersion() {
        return this.mDeviceBuild.getUserDataImageVersion();
    }

    @Override
    public void setUserDataImageFile(File userDataFile, String version) {
        this.mDeviceBuild.setUserDataImageFile(userDataFile, version);
    }

    @Override
    public File getTestsDir() {
        return this.mDeviceBuild.getTestsDir();
    }

    @Override
    public String getTestsDirVersion() {
        return this.mDeviceBuild.getTestsDirVersion();
    }

    @Override
    public void setTestsDir(File testsDir, String version) {
        this.mDeviceBuild.setTestsDir(testsDir, version);
    }

    @Override
    public File getBasebandImageFile() {
        return this.mDeviceBuild.getBasebandImageFile();
    }

    @Override
    public String getBasebandVersion() {
        return this.mDeviceBuild.getBasebandVersion();
    }

    @Override
    public void setBasebandImage(File basebandFile, String version) {
        this.mDeviceBuild.setBasebandImage(basebandFile, version);
    }

    @Override
    public File getBootloaderImageFile() {
        return this.mDeviceBuild.getBootloaderImageFile();
    }

    @Override
    public String getBootloaderVersion() {
        return this.mDeviceBuild.getBootloaderVersion();
    }

    @Override
    public void setBootloaderImageFile(File bootloaderImgFile, String version) {
        this.mDeviceBuild.setBootloaderImageFile(bootloaderImgFile, version);
    }

    @Override
    public File getOtaPackageFile() {
        return this.mDeviceBuild.getOtaPackageFile();
    }

    @Override
    public String getOtaPackageVersion() {
        return this.mDeviceBuild.getOtaPackageVersion();
    }

    @Override
    public void setOtaPackageFile(File otaFile, String version) {
        this.mDeviceBuild.setOtaPackageFile(otaFile, version);
    }

    @Override
    public File getMkbootimgFile() {
        return this.mDeviceBuild.getMkbootimgFile();
    }

    @Override
    public String getMkbootimgVersion() {
        return this.mDeviceBuild.getMkbootimgVersion();
    }

    @Override
    public void setMkbootimgFile(File mkbootimg, String version) {
        this.mDeviceBuild.setMkbootimgFile(mkbootimg, version);
    }

    @Override
    public File getRamdiskFile() {
        return this.mDeviceBuild.getRamdiskFile();
    }

    @Override
    public String getRamdiskVersion() {
        return this.mDeviceBuild.getRamdiskVersion();
    }

    @Override
    public void setRamdiskFile(File ramdisk, String version) {
        this.mDeviceBuild.setRamdiskFile(ramdisk, version);
    }

    public void setDeviceBuild(IDeviceBuildInfo deviceBuild) {
        this.mDeviceBuild = deviceBuild;
    }

    @Override
    public void addAppPackageFile(File appPackageFile, String version) {
        this.mAppBuildInfo.addAppPackageFile(appPackageFile, version);
    }

    @Override
    public List<VersionedFile> getAppPackageFiles() {
        return this.mAppBuildInfo.getAppPackageFiles();
    }

    public void setAppBuild(IAppBuildInfo appBuild) {
        this.mAppBuildInfo = appBuild;
    }

    @Override
    public void cleanUp() {
        if (this.mDeviceBuild != null) {
            this.mDeviceBuild.cleanUp();
        }
        if (this.mAppBuildInfo != null) {
            this.mAppBuildInfo.cleanUp();
        }
    }

    @Override
    public File getFile(String name) {
        File localRecord = super.getFile(name);
        File deviceFileRecord = this.mDeviceBuild.getFile(name);
        File appFileRecord = this.mAppBuildInfo.getFile(name);
        if (NullUtil.countNonNulls(localRecord, deviceFileRecord, appFileRecord) > 1) {
            LogUtil.CLog.e("Found duplicate records while fetching file with name \"%s\"", name);
            return null;
        }
        if (localRecord != null) {
            return localRecord;
        }
        if (deviceFileRecord != null) {
            return deviceFileRecord;
        }
        return appFileRecord;
    }

    @Override
    public String getVersion(String name) {
        String localFileVersion = super.getVersion(name);
        String deviceFileVersion = this.mDeviceBuild.getVersion(name);
        String appFileVersion = this.mAppBuildInfo.getVersion(name);
        if (NullUtil.countNonNulls(localFileVersion, deviceFileVersion, appFileVersion) > 1) {
            LogUtil.CLog.e("Found duplicate records while fetching file version for \"%s\"", name);
            return null;
        }
        if (localFileVersion != null) {
            return localFileVersion;
        }
        if (deviceFileVersion != null) {
            return deviceFileVersion;
        }
        return appFileVersion;
    }

    @Override
    public IBuildInfo clone() {
        AppDeviceBuildInfo copy = new AppDeviceBuildInfo(this.getBuildId(), this.getTestTag(), this.getBuildTargetName());
        copy.addAllBuildAttributes(this);
        IDeviceBuildInfo deviceBuildClone = (IDeviceBuildInfo)this.mDeviceBuild.clone();
        copy.setDeviceBuild(deviceBuildClone);
        IAppBuildInfo appBuildClone = (IAppBuildInfo)this.mAppBuildInfo.clone();
        copy.setAppBuild(appBuildClone);
        return copy;
    }
}

