/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.UniqueMultiMap;
import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildInfo
implements IBuildInfo {
    private String mBuildId = "0";
    private String mTestTag = "stub";
    private String mBuildTargetName = "stub";
    private final UniqueMultiMap<String, String> mBuildAttributes = new UniqueMultiMap();
    private Map<String, VersionedFile> mVersionedFileMap;
    private String mBuildFlavor = null;
    private String mBuildBranch = null;
    private String mDeviceSerial = null;

    public BuildInfo() {
        this.mVersionedFileMap = new Hashtable<String, VersionedFile>();
    }

    public BuildInfo(String buildId, String testTag, String buildTargetName) {
        this.mBuildId = buildId;
        this.mTestTag = testTag;
        this.mBuildTargetName = buildTargetName;
        this.mVersionedFileMap = new Hashtable<String, VersionedFile>();
    }

    BuildInfo(BuildInfo buildToCopy) {
        this(buildToCopy.getBuildId(), buildToCopy.getTestTag(), buildToCopy.getBuildTargetName());
        this.addAllBuildAttributes(buildToCopy);
        try {
            this.addAllFiles(buildToCopy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getBuildId() {
        return this.mBuildId;
    }

    @Override
    public String getTestTag() {
        return this.mTestTag;
    }

    @Override
    public String getDeviceSerial() {
        return this.mDeviceSerial;
    }

    @Override
    public Map<String, String> getBuildAttributes() {
        return this.mBuildAttributes.getUniqueMap();
    }

    @Override
    public String getBuildTargetName() {
        return this.mBuildTargetName;
    }

    @Override
    public void addBuildAttribute(String attributeName, String attributeValue) {
        this.mBuildAttributes.put(attributeName, attributeValue);
    }

    protected void addAllBuildAttributes(BuildInfo build) {
        this.mBuildAttributes.putAll(build.getAttributesMultiMap());
        this.setBuildFlavor(build.getBuildFlavor());
        this.setBuildBranch(build.getBuildBranch());
    }

    protected MultiMap<String, String> getAttributesMultiMap() {
        return this.mBuildAttributes;
    }

    protected void addAllFiles(BuildInfo build) throws IOException {
        for (Map.Entry<String, VersionedFile> fileEntry : build.getVersionedFileMap().entrySet()) {
            File copyFile;
            File origFile = fileEntry.getValue().getFile();
            if (origFile.isDirectory()) {
                copyFile = FileUtil.createTempDir(fileEntry.getKey());
                FileUtil.recursiveHardlink(origFile, copyFile);
            } else {
                copyFile = FileUtil.createTempFile(fileEntry.getKey(), FileUtil.getExtension(origFile.getName()));
                copyFile.delete();
                FileUtil.hardlinkFile(origFile, copyFile);
            }
            this.setFile(fileEntry.getKey(), copyFile, fileEntry.getValue().getVersion());
        }
    }

    protected Map<String, VersionedFile> getVersionedFileMap() {
        return this.mVersionedFileMap;
    }

    @Override
    public File getFile(String name) {
        VersionedFile fileRecord = this.mVersionedFileMap.get(name);
        if (fileRecord != null) {
            return fileRecord.getFile();
        }
        return null;
    }

    @Override
    public Collection<VersionedFile> getFiles() {
        return this.mVersionedFileMap.values();
    }

    @Override
    public String getVersion(String name) {
        VersionedFile fileRecord = this.mVersionedFileMap.get(name);
        if (fileRecord != null) {
            return fileRecord.getVersion();
        }
        return null;
    }

    @Override
    public void setFile(String name, File file, String version) {
        if (this.mVersionedFileMap.containsKey(name)) {
            LogUtil.CLog.e("Device build already contains a file for %s in thread %s", name, Thread.currentThread().getName());
            return;
        }
        this.mVersionedFileMap.put(name, new VersionedFile(file, version));
    }

    @Override
    public void cleanUp() {
        for (VersionedFile fileRecord : this.mVersionedFileMap.values()) {
            FileUtil.recursiveDelete(fileRecord.getFile());
        }
        this.mVersionedFileMap.clear();
    }

    @Override
    public IBuildInfo clone() {
        BuildInfo copy = new BuildInfo(this.mBuildId, this.mTestTag, this.mBuildTargetName);
        copy.addAllBuildAttributes(this);
        try {
            copy.addAllFiles(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        copy.setBuildBranch(this.mBuildBranch);
        copy.setBuildFlavor(this.mBuildFlavor);
        return copy;
    }

    @Override
    public String getBuildFlavor() {
        return this.mBuildFlavor;
    }

    @Override
    public void setBuildFlavor(String buildFlavor) {
        this.mBuildFlavor = buildFlavor;
    }

    @Override
    public String getBuildBranch() {
        return this.mBuildBranch;
    }

    @Override
    public void setBuildBranch(String branch) {
        this.mBuildBranch = branch;
    }

    @Override
    public void setDeviceSerial(String serial) {
        this.mDeviceSerial = serial;
    }

    public int hashCode() {
        return Objects.hashCode(this.mBuildAttributes, this.mBuildBranch, this.mBuildFlavor, this.mBuildId, this.mBuildTargetName, this.mTestTag, this.mDeviceSerial);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildInfo other = (BuildInfo)obj;
        return Objects.equal(this.mBuildAttributes, other.mBuildAttributes) && Objects.equal(this.mBuildBranch, other.mBuildBranch) && Objects.equal(this.mBuildFlavor, other.mBuildFlavor) && Objects.equal(this.mBuildId, other.mBuildId) && Objects.equal(this.mBuildTargetName, other.mBuildTargetName) && Objects.equal(this.mTestTag, other.mTestTag) && Objects.equal(this.mDeviceSerial, other.mDeviceSerial);
    }
}

