/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDownloadCache {
    private static final String LOG_TAG = "FileDownloadCache";
    private static final char REL_PATH_SEPARATOR = '/';
    private final File mCacheRoot;
    private final Map<String, File> mCacheMap = new LinkedHashMap<String, File>();
    private final ReentrantLock mCacheMapLock = new ReentrantLock();
    private long mCurrentCacheSize = 0L;
    private long mMaxFileCacheSize = 0x80000000L;

    FileDownloadCache(File cacheRoot) {
        this.mCacheRoot = cacheRoot;
        if (!this.mCacheRoot.exists()) {
            Log.d((String)LOG_TAG, (String)String.format("Creating file cache at %s", this.mCacheRoot.getAbsolutePath()));
            if (!this.mCacheRoot.mkdirs()) {
                throw new FatalHostError(String.format("Could not create cache directory at %s", this.mCacheRoot.getAbsolutePath()));
            }
        } else {
            Log.d((String)LOG_TAG, (String)String.format("Building file cache from contents at %s", this.mCacheRoot.getAbsolutePath()));
            LinkedList<FilePair> cacheEntryList = new LinkedList<FilePair>();
            this.addFiles(this.mCacheRoot, new Stack<String>(), cacheEntryList);
            Collections.sort(cacheEntryList, new FileTimeComparator());
            for (FilePair cacheEntry : cacheEntryList) {
                this.mCacheMap.put(cacheEntry.mRelPath, cacheEntry.mFile);
                this.mCurrentCacheSize += cacheEntry.mFile.length();
            }
            if (this.mCurrentCacheSize > this.getMaxFileCacheSize()) {
                this.incrementAndAdjustCache(0L);
            }
        }
    }

    private void addFiles(File dir, Stack<String> relPathSegments, List<FilePair> cacheEntryList) {
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            LogUtil.CLog.e("Unable to list files in cache dir %s", dir.getAbsolutePath());
            return;
        }
        for (File childFile : fileList) {
            if (childFile.isDirectory()) {
                relPathSegments.push(childFile.getName());
                this.addFiles(childFile, relPathSegments, cacheEntryList);
                relPathSegments.pop();
                continue;
            }
            if (childFile.isFile()) {
                StringBuffer relPath = new StringBuffer();
                for (String pathSeg : relPathSegments) {
                    relPath.append(pathSeg);
                    relPath.append('/');
                }
                relPath.append(childFile.getName());
                cacheEntryList.add(new FilePair(relPath.toString(), childFile));
                continue;
            }
            Log.w((String)LOG_TAG, (String)String.format("Unrecognized file type %s in cache", childFile.getAbsolutePath()));
        }
    }

    public void setMaxCacheSize(long numBytes) {
        this.mCacheMapLock.lock();
        this.mMaxFileCacheSize = numBytes;
        this.mCacheMapLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File fetchRemoteFile(IFileDownloader downloader, String remotePath) throws BuildRetrievalError {
        boolean download = false;
        this.mCacheMapLock.lock();
        File cachedFile = this.mCacheMap.remove(remotePath);
        if (cachedFile == null) {
            String localRelativePath = this.convertPath(remotePath);
            cachedFile = new File(this.mCacheRoot, localRelativePath);
            cachedFile.getParentFile().mkdirs();
            download = true;
        }
        File copyFile = null;
        try {
            File file = cachedFile;
            synchronized (file) {
                this.mCacheMap.put(remotePath, cachedFile);
                this.mCacheMapLock.unlock();
                if (download) {
                    this.downloadFile(downloader, remotePath, cachedFile);
                } else {
                    Log.d((String)LOG_TAG, (String)String.format("Retrieved remote file %s from cached file %s", remotePath, cachedFile.getAbsolutePath()));
                }
                copyFile = this.copyFile(remotePath, cachedFile);
            }
        }
        catch (BuildRetrievalError e) {
            this.mCacheMapLock.lock();
            this.mCacheMap.remove(remotePath);
            this.mCacheMapLock.unlock();
            throw e;
        }
        if (download) {
            this.incrementAndAdjustCache(cachedFile.length());
        }
        return copyFile;
    }

    private void downloadFile(IFileDownloader downloader, String remotePath, File cachedFile) throws BuildRetrievalError {
        try {
            Log.d((String)LOG_TAG, (String)String.format("Downloading %s to cache", remotePath));
            downloader.downloadFile(remotePath, cachedFile);
        }
        catch (BuildRetrievalError e) {
            cachedFile.delete();
            throw e;
        }
    }

    private File copyFile(String remotePath, File cachedFile) throws BuildRetrievalError {
        File hardlinkFile = null;
        try {
            hardlinkFile = FileUtil.createTempFileForRemote(remotePath, null);
            hardlinkFile.delete();
            FileUtil.hardlinkFile(cachedFile, hardlinkFile);
            return hardlinkFile;
        }
        catch (IOException e) {
            if (hardlinkFile != null) {
                hardlinkFile.delete();
            }
            cachedFile.delete();
            throw new BuildRetrievalError(String.format("Failed to copy cached file %s", cachedFile), e);
        }
    }

    private String convertPath(String remotePath) {
        if ('/' != File.separatorChar) {
            return remotePath.replace('/', File.separatorChar);
        }
        return remotePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementAndAdjustCache(long length) {
        this.mCacheMapLock.lock();
        try {
            this.mCurrentCacheSize += length;
            Iterator<Map.Entry<String, File>> mapIterator = this.mCacheMap.entrySet().iterator();
            LinkedList<String> keysToDelete = new LinkedList<String>();
            while (this.mCurrentCacheSize > this.getMaxFileCacheSize() && mapIterator.hasNext()) {
                Map.Entry<String, File> currentEntry = mapIterator.next();
                keysToDelete.add(currentEntry.getKey());
                this.mCurrentCacheSize -= currentEntry.getValue().length();
            }
            for (String deleteKey : keysToDelete) {
                File deleteFile;
                File file = deleteFile = this.mCacheMap.remove(deleteKey);
                synchronized (file) {
                    deleteFile.delete();
                }
            }
            if (this.mCurrentCacheSize < 0L) {
                Log.e((String)LOG_TAG, (String)"Cache size is less than 0!");
            }
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getCachedFile(String remoteFilePath) {
        this.mCacheMapLock.lock();
        try {
            File file = this.mCacheMap.get(remoteFilePath);
            return file;
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    void empty() {
        long currentMax = this.getMaxFileCacheSize();
        this.setMaxCacheSize(0L);
        this.incrementAndAdjustCache(0L);
        this.setMaxCacheSize(currentMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOldestEntry() {
        this.mCacheMapLock.lock();
        try {
            if (!this.mCacheMap.isEmpty()) {
                String string = this.mCacheMap.keySet().iterator().next();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.mCacheMapLock.unlock();
        }
    }

    long getMaxFileCacheSize() {
        return this.mMaxFileCacheSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTimeComparator
    implements Comparator<FilePair> {
        private FileTimeComparator() {
        }

        @Override
        public int compare(FilePair o1, FilePair o2) {
            Long timestamp1 = new Long(o1.mFile.lastModified());
            Long timestamp2 = o2.mFile.lastModified();
            return timestamp1.compareTo(timestamp2);
        }
    }

    private static class FilePair {
        final String mRelPath;
        final File mFile;

        FilePair(String relPath, File file) {
            this.mRelPath = relPath;
            this.mFile = file;
        }
    }
}

