/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.AppBuildInfo;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import java.io.File;

@OptionClass(alias="local-app")
public class LocalAppBuildProvider
extends StubBuildProvider {
    private static final String APP_OPTION_NAME = "app-path";
    @Option(name="app-path", description="the local filesystem path to apk.", importance=Option.Importance.IF_UNSET, mandatory=true)
    private File mApkPath = null;

    public IBuildInfo getBuild() throws BuildRetrievalError {
        if (!this.mApkPath.exists()) {
            throw new IllegalArgumentException(String.format("path '%s' does not exist. Please provide a valid file via --%s", this.mApkPath.getAbsolutePath(), APP_OPTION_NAME));
        }
        IBuildInfo parentBuild = super.getBuild();
        AppBuildInfo appBuild = new AppBuildInfo((BuildInfo)parentBuild);
        appBuild.addAppPackageFile(this.mApkPath, parentBuild.getBuildId());
        return appBuild;
    }

    public void buildNotTested(IBuildInfo info) {
    }

    public void cleanUp(IBuildInfo info) {
    }
}

