/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OtaZipfileBuildProvider
implements IBuildProvider {
    @Option(name="ota-path", description="path to the OTA zipfile", importance=Option.Importance.IF_UNSET)
    private String mOtaZipPath = null;

    public IBuildInfo getBuild() throws BuildRetrievalError {
        Properties buildProp = null;
        try {
            buildProp = new Properties();
            buildProp.load(new StringReader(this.getBuildPropContents()));
        }
        catch (IOException e) {
            throw new BuildRetrievalError("Error processing build.prop contents from file: " + this.getOtaPath(), e);
        }
        String bid = buildProp.getProperty("ro.build.version.incremental");
        DeviceBuildInfo buildInfo = new DeviceBuildInfo(bid, "flasher", bid);
        buildInfo.setOtaPackageFile(new File(this.getOtaPath()), bid);
        return buildInfo;
    }

    String getBuildPropContents() throws BuildRetrievalError {
        String string;
        ZipFile otaZip = null;
        try {
            otaZip = new ZipFile(this.getOtaPath());
            ZipEntry buildPropEntry = otaZip.getEntry("system/build.prop");
            if (buildPropEntry == null) {
                throw new BuildRetrievalError("Couldn't find a build.prop file in OTA zip file " + this.getOtaPath());
            }
            StringBuilder body = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(otaZip.getInputStream(buildPropEntry)));
            String line = reader.readLine();
            while (line != null) {
                body.append(line).append("\n");
                line = reader.readLine();
            }
            string = body.toString();
        }
        catch (IOException e) {
            try {
                throw new BuildRetrievalError("Failure while getting build.prop from OTA zipfile", e);
            }
            catch (Throwable throwable) {
                FileUtil.closeZip(otaZip);
                throw throwable;
            }
        }
        FileUtil.closeZip(otaZip);
        return string;
    }

    public void buildNotTested(IBuildInfo info) {
    }

    public void cleanUp(IBuildInfo info) {
    }

    String getOtaPath() {
        if (this.mOtaZipPath == null || this.mOtaZipPath.isEmpty()) {
            throw new IllegalArgumentException("Please pass ota-path");
        }
        return this.mOtaZipPath;
    }
}

