/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandFileParser {
    private static final Pattern mMacroPattern = Pattern.compile("([a-z][a-z0-9_-]*)\\(\\)", 2);
    private Map<String, CommandLine> mMacros = new HashMap<String, CommandLine>();
    private Map<String, List<CommandLine>> mLongMacros = new HashMap<String, List<CommandLine>>();
    private List<CommandLine> mLines = new LinkedList<CommandLine>();
    private Collection<String> mIncludedFiles = new HashSet<String>();

    CommandFileParser() {
    }

    private static boolean isLineMacro(CommandLine line) {
        return line.size() >= 4 && "MACRO".equals(line.get(0)) && "=".equals(line.get(2));
    }

    private static boolean isLineLongMacro(CommandLine line) {
        return line.size() == 3 && "LONG".equals(line.get(0)) && "MACRO".equals(line.get(1));
    }

    private static boolean isLineIncludeDirective(CommandLine line) {
        return line.size() == 2 && "INCLUDE".equals(line.get(0));
    }

    private static boolean shouldParseLine(String line) {
        return !(line = line.trim()).isEmpty() && !line.startsWith("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File file) throws IOException, ConfigurationException {
        if (this.mIncludedFiles.contains(file.getAbsolutePath())) {
            LogUtil.CLog.v("Skipping repeated include of file %s.", file.toString());
            return;
        }
        this.mIncludedFiles.add(file.getAbsolutePath());
        BufferedReader fileReader = this.createCommandFileReader(file);
        String inputLine = null;
        try {
            while ((inputLine = fileReader.readLine()) != null) {
                List<String> prev;
                CommandLine expansion;
                String name;
                if (!CommandFileParser.shouldParseLine(inputLine = inputLine.trim())) continue;
                CommandLine lArgs = null;
                try {
                    String[] args = QuotationAwareTokenizer.tokenizeLine(inputLine);
                    lArgs = new CommandLine(Arrays.asList(args));
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException(e.getMessage());
                }
                if (CommandFileParser.isLineMacro(lArgs)) {
                    name = (String)lArgs.get(1);
                    prev = this.mMacros.put(name, expansion = new CommandLine(lArgs.subList(3, lArgs.size())));
                    if (prev == null) continue;
                    LogUtil.CLog.e("Overwrote short macro '%s' while parsing file %s", name, file);
                    LogUtil.CLog.e("value '%s' replaced previous value '%s'", expansion, prev);
                    continue;
                }
                if (CommandFileParser.isLineLongMacro(lArgs)) {
                    name = (String)lArgs.get(2);
                    expansion = new LinkedList();
                    inputLine = fileReader.readLine();
                    while (!"END MACRO".equals(inputLine)) {
                        if (inputLine == null) {
                            throw new ConfigurationException(String.format("Syntax error: Unexpected EOF while reading definition for LONG MACRO %s.", name));
                        }
                        if (CommandFileParser.shouldParseLine(inputLine)) {
                            CommandLine line = new CommandLine(Arrays.asList(QuotationAwareTokenizer.tokenizeLine(inputLine)));
                            expansion.add(line);
                        }
                        inputLine = fileReader.readLine();
                    }
                    LogUtil.CLog.d("Parsed %d-line definition for long macro %s", expansion.size(), name);
                    prev = this.mLongMacros.put(name, expansion);
                    if (prev == null) continue;
                    LogUtil.CLog.e("Overwrote long macro %s while parsing file %s", name, file);
                    LogUtil.CLog.e("%d-line definition replaced previous %d-line definition", expansion.size(), prev.size());
                    continue;
                }
                if (CommandFileParser.isLineIncludeDirective(lArgs)) {
                    File toScan = new File((String)lArgs.get(1));
                    if (toScan.isAbsolute()) {
                        LogUtil.CLog.d("Got an include directive for absolute path %s.", lArgs.get(1));
                    } else {
                        File parent = file.getParentFile();
                        toScan = new File(parent, (String)lArgs.get(1));
                        LogUtil.CLog.d("Got an include directive for relative path %s, using '%s' for parent dir", lArgs.get(1), parent);
                    }
                    this.scanFile(toScan);
                    continue;
                }
                this.mLines.add(lArgs);
            }
        }
        finally {
            fileReader.close();
        }
    }

    public void parseFile(File file, ICommandScheduler scheduler) throws IOException, ConfigurationException {
        List<String> empty = Collections.emptyList();
        this.parseFile(file, scheduler, empty);
    }

    public void parseFile(File file, ICommandScheduler scheduler, List<String> args) throws IOException, ConfigurationException {
        this.scanFile(file);
        Bitmask inputBitmask = new Bitmask(this.mLines.size(), true);
        for (int iCount = 0; iCount < 10 && inputBitmask.getSetCount() > 0; ++iCount) {
            LogUtil.CLog.d("### Expansion iteration %d", iCount);
            int inputIdx = 0;
            while (inputIdx < this.mLines.size()) {
                CommandLine line;
                if (!inputBitmask.get(inputIdx)) {
                    LogUtil.CLog.d("skipping input line %s", this.mLines.get(inputIdx));
                    ++inputIdx;
                    continue;
                }
                boolean sawMacro = this.expandMacro(line = this.mLines.get(inputIdx));
                List<CommandLine> longMacroExpansion = this.expandLongMacro(line, !sawMacro);
                if (longMacroExpansion == null) {
                    if (!sawMacro) {
                        inputBitmask.unset(inputIdx);
                    }
                    ++inputIdx;
                    continue;
                }
                this.mLines.remove(inputIdx);
                inputBitmask.remove(inputIdx);
                this.mLines.addAll(inputIdx, longMacroExpansion);
                inputBitmask.addN(inputIdx, longMacroExpansion.size(), true);
                inputIdx += longMacroExpansion.size();
            }
        }
        for (CommandLine commandLine : this.mLines) {
            int outIdx;
            LogUtil.CLog.v("Adding line with parts: %s + %s", commandLine.toString(), args.toString());
            Object[] aryCmdLine = new String[commandLine.size() + args.size()];
            for (outIdx = 0; outIdx < commandLine.size(); ++outIdx) {
                aryCmdLine[outIdx] = (String)commandLine.get(outIdx);
            }
            for (int i = 0; i < args.size(); ++i) {
                aryCmdLine[outIdx] = args.get(i);
                ++outIdx;
            }
            LogUtil.CLog.d("Adding line: %s", Arrays.toString(aryCmdLine));
            scheduler.addCommand((String[])aryCmdLine);
        }
    }

    private List<CommandLine> expandLongMacro(CommandLine line, boolean checkMissingMacro) throws ConfigurationException {
        for (int idx = 0; idx < line.size(); ++idx) {
            String token = (String)line.get(idx);
            Matcher matchMacro = mMacroPattern.matcher(token);
            if (!matchMacro.matches()) continue;
            LinkedList<CommandLine> expansion = new LinkedList<CommandLine>();
            String name = matchMacro.group(1);
            List<CommandLine> longMacro = this.mLongMacros.get(name);
            if (longMacro == null) {
                if (checkMissingMacro) {
                    throw new ConfigurationException(String.format("Macro call '%s' does not match any macro definitions.", name));
                }
                LogUtil.CLog.d("Macro call '%s' doesn't match any long macro definitions.", name);
                return null;
            }
            CommandLine prefix = new CommandLine(line.subList(0, idx));
            CommandLine suffix = new CommandLine(line.subList(idx, line.size()));
            suffix.remove(0);
            for (CommandLine macroLine : longMacro) {
                CommandLine expanded = new CommandLine();
                expanded.addAll(prefix);
                expanded.addAll(macroLine);
                expanded.addAll(suffix);
                expansion.add(expanded);
            }
            return expansion;
        }
        return null;
    }

    private boolean expandMacro(CommandLine line) {
        boolean sawMacro = false;
        int idx = 0;
        while (idx < line.size()) {
            String token = (String)line.get(idx);
            Matcher matchMacro = mMacroPattern.matcher(token);
            if (matchMacro.matches() && this.mMacros.containsKey(matchMacro.group(1))) {
                String name = matchMacro.group(1);
                CommandLine macro = this.mMacros.get(name);
                LogUtil.CLog.d("Gotcha!  Expanding macro '%s' to '%s'", name, macro);
                line.remove(idx);
                line.addAll(idx, macro);
                idx += macro.size();
                sawMacro = true;
                continue;
            }
            ++idx;
        }
        return sawMacro;
    }

    BufferedReader createCommandFileReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    static class Bitmask {
        private List<Boolean> mBitmask = new LinkedList<Boolean>();
        private int mNumBitsSet = 0;

        public Bitmask(int nBits) {
            this(nBits, false);
        }

        public Bitmask(int nBits, boolean initialValue) {
            for (int i = 0; i < nBits; ++i) {
                this.mBitmask.add(initialValue);
            }
            if (initialValue) {
                this.mNumBitsSet = nBits;
            }
        }

        public int getSetCount() {
            return this.mNumBitsSet;
        }

        public boolean get(int idx) {
            return this.mBitmask.get(idx);
        }

        public boolean set(int idx) {
            boolean retVal = this.mBitmask.set(idx, true);
            if (!retVal) {
                ++this.mNumBitsSet;
            }
            return retVal;
        }

        public boolean unset(int idx) {
            boolean retVal = this.mBitmask.set(idx, false);
            if (retVal) {
                --this.mNumBitsSet;
            }
            return retVal;
        }

        public boolean remove(int idx) {
            boolean retVal = this.mBitmask.remove(idx);
            if (retVal) {
                --this.mNumBitsSet;
            }
            return retVal;
        }

        public void add(int idx, boolean val) {
            this.mBitmask.add(idx, val);
            if (val) {
                ++this.mNumBitsSet;
            }
        }

        public void addN(int idx, int count, boolean val) {
            for (int i = 0; i < count; ++i) {
                this.add(idx, val);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommandLine
    extends LinkedList<String> {
        CommandLine() {
        }

        CommandLine(Collection<? extends String> c) {
            super(c);
        }
    }
}

