/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.log.LogUtil;

public class CommandOptions
implements ICommandOptions {
    @Option(name="help", description="display the help text for the most important/critical options.", importance=Option.Importance.ALWAYS)
    private boolean mHelpMode = false;
    @Option(name="help-all", description="display the full help text for all options.", importance=Option.Importance.ALWAYS)
    private boolean mFullHelpMode = false;
    @Option(name="dry-run", description="build but don't actually run the command; for debugging", importance=Option.Importance.ALWAYS)
    private boolean mDryRunMode = false;
    @Option(name="min-loop-time", description="the minimum invocation time in ms when in loop mode.")
    private long mMinLoopTime = 600000L;
    @Option(name="loop", description="keep running continuously.", importance=Option.Importance.ALWAYS)
    private boolean mLoopMode = false;
    @Option(name="all-devices", description="fork this command to run on all connected devices.")
    private boolean mAllDevices = false;

    void setHelpMode(boolean helpMode) {
        this.mHelpMode = helpMode;
    }

    public boolean isHelpMode() {
        return this.mHelpMode;
    }

    public boolean isFullHelpMode() {
        return this.mFullHelpMode;
    }

    void setDryRunMode(boolean dryRunMode) {
        this.mDryRunMode = dryRunMode;
    }

    public boolean isDryRunMode() {
        return this.mDryRunMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.mLoopMode = loopMode;
    }

    public boolean isLoopMode() {
        return this.mLoopMode;
    }

    void setMinLoopTime(long loopTime) {
        this.mMinLoopTime = loopTime;
    }

    public long getMinLoopTime() {
        return this.mMinLoopTime;
    }

    public ICommandOptions clone() {
        CommandOptions clone = new CommandOptions();
        try {
            OptionCopier.copyOptions(this, clone);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e("failed to clone command options", e);
        }
        return clone;
    }

    public boolean runOnAllDevices() {
        return this.mAllDevices;
    }
}

