/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.command;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.command.RemoteClient;
import com.android.tradefed.command.RemoteManager;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.ConditionPriorityBlockingQueue;
import com.android.tradefed.util.TableFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandScheduler
extends Thread
implements ICommandScheduler {
    private ConditionPriorityBlockingQueue<ExecutableCommand> mCommandQueue;
    private List<ExecutableCommand> mAllCommands;
    private Set<InvocationThread> mInvocationThreads;
    private ScheduledThreadPoolExecutor mCommandTimer;
    private RemoteClient mRemoteClient = null;
    private RemoteManager mRemoteManager = null;
    private final CountDownLatch mRunLatch;
    private static final int NO_DEVICE_DELAY_TIME = 20;
    private int mCurrentCommandId = 0;
    private boolean mShutdownOnEmpty = false;

    public CommandScheduler() {
        this.initLogging();
        this.initDeviceManager();
        this.mCommandQueue = new ConditionPriorityBlockingQueue<ExecutableCommand>(new ExecutableCommandComparator());
        this.mAllCommands = Collections.synchronizedList(new LinkedList());
        this.mInvocationThreads = new HashSet<InvocationThread>();
        this.mCommandTimer = new ScheduledThreadPoolExecutor(1);
        this.mRunLatch = new CountDownLatch(1);
    }

    void initDeviceManager() {
        this.getDeviceManager().init();
    }

    ITestInvocation createRunInstance() {
        return new TestInvocation();
    }

    IDeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    IConfigurationFactory getConfigFactory() {
        return ConfigurationFactory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ArrayList<InvocationThread> threadListCopy;
            Object device;
            this.mRunLatch.countDown();
            IDeviceManager manager = this.getDeviceManager();
            while (!this.isShutdown()) {
                ExecutableCommand cmd = this.dequeueConfigCommand();
                if (cmd == null) continue;
                device = manager.allocateDevice(0L, cmd.getConfiguration().getDeviceRequirements());
                if (device != null) {
                    InvocationThread invThread = this.startInvocation(manager, (ITestDevice)device, cmd);
                    this.addInvocationThread(invThread);
                    if (!cmd.isLoopMode()) continue;
                    this.addNewExecCommandToQueue(cmd.getCommandTracker());
                    continue;
                }
                cmd.getCommandTracker().incrementExecTime(1L);
                this.addExecCommandToQueue(cmd, 20L);
            }
            this.mCommandTimer.shutdown();
            LogUtil.CLog.i("Waiting for invocation threads to complete");
            device = this;
            synchronized (device) {
                threadListCopy = new ArrayList<InvocationThread>(this.mInvocationThreads.size());
                threadListCopy.addAll(this.mInvocationThreads);
            }
            for (InvocationThread thread : threadListCopy) {
                this.waitForThread(thread);
            }
            this.closeRemoteClient();
            if (this.mRemoteManager != null) {
                this.mRemoteManager.cancel();
            }
            this.exit(manager);
            this.cleanUp();
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "All done", new Object[0]);
        }
        finally {
            System.err.flush();
            System.out.flush();
        }
    }

    @Override
    public void await() throws InterruptedException {
        while (this.mRunLatch.getCount() > 0L) {
            this.mRunLatch.await();
        }
    }

    private void closeRemoteClient() {
        if (this.mRemoteClient != null) {
            try {
                this.mRemoteClient.sendUnfilterAll();
                this.mRemoteClient.sendClose();
                this.mRemoteClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void waitForThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            this.waitForThread(thread);
        }
    }

    private void exit(IDeviceManager manager) {
        if (manager != null) {
            manager.terminate();
        }
    }

    @Override
    public boolean addCommand(String[] args) {
        return this.addCommand(args, 0L);
    }

    @Override
    public boolean addCommand(String[] args, long totalExecTime) {
        block7: {
            try {
                IConfiguration config = this.getConfigFactory().createConfigurationFromArgs(args);
                if (config.getCommandOptions().isHelpMode()) {
                    this.getConfigFactory().printHelpForConfig(args, true, System.out);
                    break block7;
                }
                if (config.getCommandOptions().isFullHelpMode()) {
                    this.getConfigFactory().printHelpForConfig(args, false, System.out);
                    break block7;
                }
                if (config.getCommandOptions().isDryRunMode()) {
                    LogUtil.CLog.v("Dry run mode; not adding command: %s", Arrays.toString(args));
                    break block7;
                }
                config.validateOptions();
                if (config.getCommandOptions().runOnAllDevices()) {
                    this.addCommandForAllDevices(totalExecTime, args);
                } else {
                    CommandTracker cmdTracker = this.createCommandTracker(args);
                    cmdTracker.incrementExecTime(totalExecTime);
                    ExecutableCommand cmdInstance = this.createExecutableCommand(cmdTracker, config, false);
                    this.addExecCommandToQueue(cmdInstance, 0L);
                }
                return true;
            }
            catch (ConfigurationException e) {
                System.out.println(String.format("Error while processing args: %s", Arrays.toString(args)));
                System.out.println(e.getMessage());
                System.out.println();
            }
        }
        return false;
    }

    private void addCommandForAllDevices(long totalExecTime, String[] args) throws ConfigurationException {
        HashSet<String> devices = new HashSet<String>();
        devices.addAll(this.getDeviceManager().getAvailableDevices());
        devices.addAll(this.getDeviceManager().getAllocatedDevices());
        devices.addAll(this.getDeviceManager().getUnavailableDevices());
        for (String device : devices) {
            String[] argsWithDevice = Arrays.copyOf(args, args.length + 2);
            argsWithDevice[argsWithDevice.length - 2] = "-s";
            argsWithDevice[argsWithDevice.length - 1] = device;
            CommandTracker cmdTracker = this.createCommandTracker(argsWithDevice);
            cmdTracker.incrementExecTime(totalExecTime);
            IConfiguration config = this.getConfigFactory().createConfigurationFromArgs(cmdTracker.getArgs());
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Scheduling '%s' on '%s'", cmdTracker.getArgs()[0], device);
            config.getDeviceRequirements().setSerial(device);
            ExecutableCommand execCmd = this.createExecutableCommand(cmdTracker, config, false);
            this.addExecCommandToQueue(execCmd, 0L);
        }
    }

    private synchronized CommandTracker createCommandTracker(String[] args) {
        ++this.mCurrentCommandId;
        return new CommandTracker(this.mCurrentCommandId, args);
    }

    private ExecutableCommand createExecutableCommand(CommandTracker cmdTracker, IConfiguration config, boolean rescheduled) {
        ExecutableCommand cmd = new ExecutableCommand(cmdTracker, config, rescheduled);
        this.mAllCommands.add(cmd);
        return cmd;
    }

    private ExecutableCommand dequeueConfigCommand() {
        try {
            return this.mCommandQueue.poll(this.getCommandPollTimeMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LogUtil.CLog.i("Waiting for command interrupted");
            return null;
        }
    }

    long getCommandPollTimeMs() {
        return 1000L;
    }

    private void addNewExecCommandToQueue(CommandTracker commandTracker) {
        try {
            IConfiguration config = this.getConfigFactory().createConfigurationFromArgs(commandTracker.getArgs());
            ExecutableCommand execCmd = this.createExecutableCommand(commandTracker, config, false);
            this.addExecCommandToQueue(execCmd, config.getCommandOptions().getMinLoopTime());
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e(e);
        }
    }

    private synchronized boolean addExecCommandToQueue(final ExecutableCommand cmd, long delayTime) {
        if (this.isShutdown()) {
            return false;
        }
        if (delayTime > 0L) {
            cmd.setSleepState(delayTime);
            Runnable delayCommand = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CommandScheduler commandScheduler = CommandScheduler.this;
                    synchronized (commandScheduler) {
                        cmd.setWaitState();
                        CommandScheduler.this.mCommandQueue.add(cmd);
                    }
                }
            };
            this.mCommandTimer.schedule(delayCommand, delayTime, TimeUnit.MILLISECONDS);
        } else {
            this.mCommandQueue.add(cmd);
        }
        return true;
    }

    private String getArgString(String[] args) {
        return ArrayUtil.join(" ", args);
    }

    private InvocationThread startInvocation(IDeviceManager manager, ITestDevice device, ExecutableCommand cmd) {
        String invocationName = String.format("Invocation-%s", device.getSerialNumber());
        InvocationThread invocationThread = new InvocationThread(invocationName, manager, device, cmd);
        invocationThread.start();
        return invocationThread;
    }

    private synchronized void removeInvocationThread(InvocationThread invThread) {
        this.mInvocationThreads.remove(invThread);
    }

    private synchronized void addInvocationThread(InvocationThread invThread) {
        this.mInvocationThreads.add(invThread);
    }

    private synchronized boolean isShutdown() {
        return this.mCommandTimer.isShutdown() || this.mShutdownOnEmpty && this.mAllCommands.isEmpty();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.clearWaitingCommands();
            if (this.mCommandTimer != null) {
                this.mCommandTimer.shutdownNow();
            }
        }
    }

    @Override
    public synchronized void shutdownOnEmpty() {
        if (!this.isShutdown()) {
            this.mShutdownOnEmpty = true;
        }
    }

    @Override
    public synchronized void removeAllCommands() {
        if (this.mCommandTimer != null) {
            for (Runnable task : this.mCommandTimer.getQueue()) {
                this.mCommandTimer.remove(task);
            }
        }
        this.clearWaitingCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWaitingCommands() {
        this.mCommandQueue.clear();
        List<ExecutableCommand> list = this.mAllCommands;
        synchronized (list) {
            ListIterator<ExecutableCommand> cmdIter = this.mAllCommands.listIterator();
            while (cmdIter.hasNext()) {
                ExecutableCommand cmd = cmdIter.next();
                if (cmd.getState().equals((Object)CommandState.EXECUTING)) continue;
                cmdIter.remove();
            }
        }
    }

    @Override
    public synchronized boolean handoverShutdown(int handoverPort) {
        if (this.mRemoteClient != null) {
            LogUtil.CLog.e("A handover has already been initiated");
            return false;
        }
        try {
            this.mRemoteClient = RemoteClient.connect(handoverPort);
            LogUtil.CLog.d("connected to remote manager at %d", handoverPort);
            for (String deviceInUse : this.getDeviceManager().getAllocatedDevices()) {
                if (!this.mRemoteClient.sendFilterDevice(deviceInUse)) {
                    LogUtil.CLog.e("Failed to send command to remote manager");
                    return false;
                }
                LogUtil.CLog.d("Sent filter device %s command", deviceInUse);
            }
            List<CommandTracker> cmdCopy = this.getCommandTrackers();
            Collections.sort(cmdCopy, new CommandTrackerTimeComparator());
            for (CommandTracker cmd : cmdCopy) {
                this.mRemoteClient.sendAddCommand(cmd.getTotalExecTime(), cmd.mArgs);
            }
            this.shutdown();
            return true;
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to connect to remote manager at port %d", handoverPort);
            return false;
        }
    }

    private List<CommandTracker> getCommandTrackers() {
        ArrayList<ExecutableCommand> cmdCopy = new ArrayList<ExecutableCommand>(this.mAllCommands);
        LinkedHashSet<CommandTracker> cmdTrackers = new LinkedHashSet<CommandTracker>();
        for (ExecutableCommand cmd : cmdCopy) {
            cmdTrackers.add(cmd.getCommandTracker());
        }
        return new ArrayList<CommandTracker>(cmdTrackers);
    }

    private void remoteFreeDevice(ITestDevice device) {
        if (this.mRemoteClient != null) {
            try {
                this.mRemoteClient.sendUnfilterDevice(device.getSerialNumber());
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to send unfilter device %s to remote manager", device.getSerialNumber());
            }
        }
    }

    @Override
    public synchronized void shutdownHard() {
        this.shutdown();
        LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, "Force killing adb connection", new Object[0]);
        this.getDeviceManager().terminateHard();
    }

    void initLogging() {
        DdmPreferences.setLogLevel((String)Log.LogLevel.VERBOSE.getStringValue());
        Log.setLogOutput((Log.ILogOutput)LogRegistry.getLogRegistry());
    }

    void cleanUp() {
        LogRegistry.getLogRegistry().closeAndRemoveAllLogs();
    }

    @Override
    public void displayInvocationsInfo(PrintWriter printWriter) {
        if (this.mInvocationThreads == null || this.mInvocationThreads.size() == 0) {
            return;
        }
        ArrayList<InvocationThread> copy = new ArrayList<InvocationThread>(this.mInvocationThreads);
        ArrayList<List<String>> displayRows = new ArrayList<List<String>>();
        displayRows.add(Arrays.asList("Command Id", "Exec Time", "Device", "State"));
        long curTime = System.currentTimeMillis();
        for (InvocationThread invThread : copy) {
            displayRows.add(Arrays.asList(Integer.toString(invThread.mCmd.getCommandTracker().getId()), this.getTimeString(curTime - invThread.getStartTime()), invThread.getDevice().getSerialNumber(), invThread.getInvocation().toString()));
        }
        new TableFormatter().displayTable(displayRows, printWriter);
    }

    private String getTimeString(long elapsedTime) {
        long duration = elapsedTime / 1000L;
        long secs = duration % 60L;
        long mins = duration / 60L % 60L;
        long hrs = duration / 3600L;
        String time = "unknown";
        time = hrs > 0L ? String.format("%dh:%02d:%02d", hrs, mins, secs) : String.format("%dm:%02d", mins, secs);
        return time;
    }

    @Override
    public boolean stopInvocation(ITestInvocation invocation) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayCommandsInfo(PrintWriter printWriter) {
        List<CommandTracker> cmds = this.getCommandTrackers();
        Collections.sort(cmds, new CommandTrackerIdComparator());
        for (CommandTracker cmd : cmds) {
            String cmdDesc = String.format("Command %d: [%s] %s", cmd.getId(), this.getTimeString(cmd.getTotalExecTime()), this.getArgString(cmd.getArgs()));
            printWriter.println(cmdDesc);
        }
    }

    @Override
    public void displayCommandQueue(PrintWriter printWriter) {
        if (this.mAllCommands.isEmpty()) {
            return;
        }
        ArrayList<List<String>> displayRows = new ArrayList<List<String>>();
        displayRows.add(Arrays.asList("Id", "Config", "Created", "State", "Sleep time", "Rescheduled", "Loop"));
        long curTime = System.currentTimeMillis();
        ArrayList<ExecutableCommand> cmdCopy = new ArrayList<ExecutableCommand>(this.mAllCommands);
        for (ExecutableCommand cmd : cmdCopy) {
            this.dumpCommand(curTime, cmd, displayRows);
        }
        new TableFormatter().displayTable(displayRows, printWriter);
    }

    private void dumpCommand(long curTime, ExecutableCommand cmd, ArrayList<List<String>> displayRows) {
        String sleepTime = cmd.getSleepTime() == null ? "N/A" : this.getTimeString(cmd.getSleepTime());
        displayRows.add(Arrays.asList(Integer.toString(cmd.getCommandTracker().getId()), cmd.getCommandTracker().getArgs()[0], this.getTimeString(curTime - cmd.getCreationTime()), cmd.getState().getDisplayName(), sleepTime, Boolean.toString(cmd.isRescheduled()), Boolean.toString(cmd.isLoopMode())));
    }

    @Override
    public int startRemoteManager() {
        if (this.mRemoteManager != null && !this.mRemoteManager.isCanceled()) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "A remote manager is already running at port %d", this.mRemoteManager.getPort());
            return -1;
        }
        this.mRemoteManager = new RemoteManager(this.getDeviceManager(), this);
        this.mRemoteManager.start();
        int port = this.mRemoteManager.getPort();
        if (port == -1) {
            this.mRemoteManager = null;
        }
        return port;
    }

    @Override
    public void stopRemoteManager() {
        if (this.mRemoteManager == null) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "A remote manager is not running", new Object[0]);
            return;
        }
        this.mRemoteManager.cancel();
        this.mRemoteManager = null;
    }

    static /* synthetic */ String access$400(CommandScheduler x0, String[] x1) {
        return x0.getArgString(x1);
    }

    static /* synthetic */ void access$500(CommandScheduler x0, ITestDevice x1) {
        x0.remoteFreeDevice(x1);
    }

    static /* synthetic */ void access$600(CommandScheduler x0, InvocationThread x1) {
        x0.removeInvocationThread(x1);
    }

    private class InvocationThread
    extends Thread {
        private final IDeviceManager mManager;
        private final ITestDevice mDevice;
        private final ExecutableCommand mCmd;
        private final ITestInvocation mInvocation;
        private long mStartTime;

        public InvocationThread(String name, IDeviceManager manager, ITestDevice device, ExecutableCommand command) {
            super(new ThreadGroup(name), name);
            this.mStartTime = -1L;
            this.mManager = manager;
            this.mDevice = device;
            this.mCmd = command;
            this.mInvocation = CommandScheduler.this.createRunInstance();
        }

        public long getStartTime() {
            return this.mStartTime;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        ITestInvocation getInvocation() {
            return this.mInvocation;
        }

        ITestDevice getDevice() {
            return this.mDevice;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandTrackerIdComparator
    implements Comparator<CommandTracker> {
        private CommandTrackerIdComparator() {
        }

        @Override
        public int compare(CommandTracker c1, CommandTracker c2) {
            if (c1.getId() == c2.getId()) {
                return 0;
            }
            if (c1.getId() < c2.getId()) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandTrackerTimeComparator
    implements Comparator<CommandTracker> {
        private CommandTrackerTimeComparator() {
        }

        @Override
        public int compare(CommandTracker c1, CommandTracker c2) {
            if (c1.getTotalExecTime() == c2.getTotalExecTime()) {
                return 0;
            }
            if (c1.getTotalExecTime() < c2.getTotalExecTime()) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableCommandComparator
    implements Comparator<ExecutableCommand> {
        CommandTrackerTimeComparator mTrackerComparator = new CommandTrackerTimeComparator();

        private ExecutableCommandComparator() {
        }

        @Override
        public int compare(ExecutableCommand c1, ExecutableCommand c2) {
            return this.mTrackerComparator.compare(c1.getCommandTracker(), c2.getCommandTracker());
        }
    }

    private class Rescheduler
    implements IRescheduler {
        private CommandTracker mCmdTracker;

        Rescheduler(CommandTracker cmdTracker) {
            this.mCmdTracker = cmdTracker;
        }

        public boolean scheduleConfig(IConfiguration config) {
            config.getCommandOptions().setLoopMode(false);
            ExecutableCommand rescheduledCmd = CommandScheduler.this.createExecutableCommand(this.mCmdTracker, config, true);
            return CommandScheduler.this.addExecCommandToQueue(rescheduledCmd, 0L);
        }

        public boolean rescheduleCommand() {
            try {
                IConfiguration config = CommandScheduler.this.getConfigFactory().createConfigurationFromArgs(this.mCmdTracker.getArgs());
                ExecutableCommand execCmd = CommandScheduler.this.createExecutableCommand(this.mCmdTracker, config, true);
                return CommandScheduler.this.addExecCommandToQueue(execCmd, 0L);
            }
            catch (ConfigurationException e) {
                System.out.println(String.format("Error while processing args: %s", Arrays.toString(this.mCmdTracker.getArgs())));
                System.out.println(e.getMessage());
                System.out.println();
                return false;
            }
        }
    }

    private class ExecutableCommand {
        private final CommandTracker mCmdTracker;
        private final IConfiguration mConfig;
        private final boolean mRescheduled;
        private final long mCreationTime;
        private CommandState mState;
        private Long mSleepTime;

        private ExecutableCommand(CommandTracker tracker, IConfiguration config, boolean rescheduled) {
            this.mConfig = config;
            this.mCmdTracker = tracker;
            this.mRescheduled = rescheduled;
            this.mCreationTime = System.currentTimeMillis();
            this.mState = CommandState.WAITING_FOR_DEVICE;
        }

        public IConfiguration getConfiguration() {
            return this.mConfig;
        }

        CommandTracker getCommandTracker() {
            return this.mCmdTracker;
        }

        void commandStarted() {
            this.mState = CommandState.EXECUTING;
            this.mSleepTime = null;
        }

        public void commandFinished(long elapsedTime) {
            this.getCommandTracker().incrementExecTime(elapsedTime);
            CommandScheduler.this.mAllCommands.remove(this);
        }

        public boolean isRescheduled() {
            return this.mRescheduled;
        }

        public long getCreationTime() {
            return this.mCreationTime;
        }

        public boolean isLoopMode() {
            return this.mConfig.getCommandOptions().isLoopMode();
        }

        public CommandState getState() {
            return this.mState;
        }

        public void setSleepState(Long delayTime) {
            this.mSleepTime = delayTime;
            this.mState = CommandState.SLEEPING;
        }

        public void setWaitState() {
            this.mState = CommandState.WAITING_FOR_DEVICE;
            this.mSleepTime = null;
        }

        public Long getSleepTime() {
            return this.mSleepTime;
        }
    }

    private static class CommandTracker {
        private final int mId;
        private final String[] mArgs;
        private long mTotalExecTime = 0L;

        CommandTracker(int id, String[] args) {
            this.mId = id;
            this.mArgs = args;
        }

        synchronized void incrementExecTime(long execTime) {
            this.mTotalExecTime += execTime;
        }

        synchronized long getTotalExecTime() {
            return this.mTotalExecTime;
        }

        String[] getArgs() {
            return this.mArgs;
        }

        int getId() {
            return this.mId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CommandState {
        WAITING_FOR_DEVICE("Wait_for_device"),
        EXECUTING("Executing"),
        SLEEPING("Sleeping");

        private String mDisplayName;

        private CommandState(String displayName) {
            this.mDisplayName = displayName;
        }

        public String getDisplayName() {
            return this.mDisplayName;
        }
    }
}

