/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationXmlParser;
import com.android.tradefed.config.IConfigDefLoader;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.util.ClassPathScanner;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFactory
implements IConfigurationFactory {
    private static final String LOG_TAG = "ConfigurationFactory";
    private static IConfigurationFactory sInstance = null;
    private static final String CONFIG_SUFFIX = ".xml";
    private static final String CONFIG_PREFIX = "config/";
    private Map<String, ConfigurationDef> mConfigDefMap = new Hashtable<String, ConfigurationDef>();

    ConfigurationFactory() {
    }

    public static IConfigurationFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ConfigurationFactory();
        }
        return sInstance;
    }

    private ConfigurationDef getConfigurationDef(String name, boolean isGlobal) throws ConfigurationException {
        return new ConfigLoader(isGlobal).getConfigurationDef(name);
    }

    @Override
    public IConfiguration createConfigurationFromArgs(String[] arrayArgs) throws ConfigurationException {
        ArrayList<String> listArgs = new ArrayList<String>(arrayArgs.length);
        IConfiguration config = this.internalCreateConfigurationFromArgs(arrayArgs, listArgs);
        config.setOptionsFromCommandLineArgs(listArgs);
        return config;
    }

    private IConfiguration internalCreateConfigurationFromArgs(String[] arrayArgs, List<String> optionArgsRef) throws ConfigurationException {
        if (arrayArgs.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified");
        }
        optionArgsRef.addAll(Arrays.asList(arrayArgs));
        String configName = optionArgsRef.remove(0);
        ConfigurationDef configDef = this.getConfigurationDef(configName, false);
        return configDef.createConfiguration();
    }

    @Override
    public IGlobalConfiguration createGlobalConfigurationFromArgs(String[] arrayArgs, List<String> remainingArgs) throws ConfigurationException {
        ArrayList<String> listArgs = new ArrayList<String>(arrayArgs.length);
        IGlobalConfiguration config = this.internalCreateGlobalConfigurationFromArgs(arrayArgs, listArgs);
        remainingArgs.addAll(config.setOptionsFromCommandLineArgs(listArgs));
        return config;
    }

    private IGlobalConfiguration internalCreateGlobalConfigurationFromArgs(String[] arrayArgs, List<String> optionArgsRef) throws ConfigurationException {
        if (arrayArgs.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified");
        }
        optionArgsRef.addAll(Arrays.asList(arrayArgs));
        String configName = optionArgsRef.remove(0);
        ConfigurationDef configDef = this.getConfigurationDef(configName, false);
        return configDef.createGlobalConfiguration();
    }

    @Override
    public void printHelp(PrintStream out) {
        out.println("Use 'run command <configuration_name> --help' to get list of options for a configuration");
        out.println("Use 'dump config <configuration_name>' to display the configuration's XML content.");
        out.println();
        out.println("Available configurations include:");
        try {
            this.loadAllConfigs(true);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        TreeSet<ConfigurationDef> configDefs = new TreeSet<ConfigurationDef>(new ConfigDefComparator());
        configDefs.addAll(this.mConfigDefMap.values());
        for (ConfigurationDef def : configDefs) {
            out.printf("  %s: %s", def.getName(), def.getDescription());
            out.println();
        }
    }

    void loadAllConfigs(boolean discardExceptions) throws ConfigurationException {
        ClassPathScanner cpScanner = new ClassPathScanner();
        Set<String> configNames = cpScanner.getClassPathEntries(new ConfigClasspathFilter());
        for (String configName : configNames) {
            try {
                ConfigurationDef configDef = this.getConfigurationDef(configName, false);
                this.mConfigDefMap.put(configName, configDef);
            }
            catch (ConfigurationException e) {
                Log.e((String)LOG_TAG, (String)String.format("Failed to load configuration '%s'. Reason: %s", configName, e.toString()));
                if (discardExceptions) continue;
                throw e;
            }
        }
    }

    @Override
    public void printHelpForConfig(String[] args, boolean importantOnly, PrintStream out) {
        try {
            IConfiguration config = this.internalCreateConfigurationFromArgs(args, new ArrayList<String>(args.length));
            config.printCommandUsage(importantOnly, out);
        }
        catch (ConfigurationException e) {
            this.printHelp(out);
        }
    }

    @Override
    public void dumpConfig(String configName, PrintStream out) {
        try {
            BufferedInputStream configStream = this.getConfigStream(configName);
            StreamUtil.copyStreams(configStream, out);
        }
        catch (ConfigurationException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
        }
    }

    String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    private BufferedInputStream getConfigStream(String name) throws ConfigurationException {
        InputStream configStream = this.getClass().getResourceAsStream(String.format("/%s%s%s", this.getConfigPrefix(), name, CONFIG_SUFFIX));
        if (configStream == null) {
            try {
                configStream = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(String.format("Could not find configuration '%s'", name));
            }
        }
        return new BufferedInputStream(configStream);
    }

    class ConfigLoader
    implements IConfigDefLoader {
        private final boolean mIsGlobalConfig;
        private Set<String> mIncludedConfigs = new HashSet<String>();

        public ConfigLoader(boolean isGlobalConfig) {
            this.mIsGlobalConfig = isGlobalConfig;
        }

        public ConfigurationDef getConfigurationDef(String name) throws ConfigurationException {
            if (this.mIncludedConfigs.contains(name)) {
                throw new ConfigurationException(String.format("Circular configuration include: config '%s' is already included", name));
            }
            this.mIncludedConfigs.add(name);
            ConfigurationDef def = (ConfigurationDef)ConfigurationFactory.this.mConfigDefMap.get(name);
            if (def == null) {
                def = this.loadConfiguration(name);
                ConfigurationFactory.this.mConfigDefMap.put(name, def);
            }
            return def;
        }

        ConfigurationDef loadConfiguration(String name) throws ConfigurationException {
            Log.i((String)ConfigurationFactory.LOG_TAG, (String)String.format("Loading configuration '%s'", name));
            BufferedInputStream bufStream = ConfigurationFactory.this.getConfigStream(name);
            ConfigurationXmlParser parser = new ConfigurationXmlParser(this);
            return parser.parse(name, bufStream);
        }

        public boolean isGlobalConfig() {
            return this.mIsGlobalConfig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigDefComparator
    implements Comparator<ConfigurationDef> {
        private ConfigDefComparator() {
        }

        @Override
        public int compare(ConfigurationDef d1, ConfigurationDef d2) {
            return d1.getName().compareTo(d2.getName());
        }
    }

    private class ConfigClasspathFilter
    implements ClassPathScanner.IClassPathFilter {
        private ConfigClasspathFilter() {
        }

        public boolean accept(String pathName) {
            return pathName.startsWith(ConfigurationFactory.CONFIG_PREFIX) && pathName.endsWith(ConfigurationFactory.CONFIG_SUFFIX) && !ConfigurationFactory.this.mConfigDefMap.containsKey(pathName);
        }

        public String transform(String pathName) {
            int pathStartIndex = ConfigurationFactory.CONFIG_PREFIX.length();
            int pathEndIndex = pathName.length() - ConfigurationFactory.CONFIG_SUFFIX.length();
            return pathName.substring(pathStartIndex, pathEndIndex);
        }
    }
}

