/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfigDefLoader;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigurationXmlParser {
    private static final String LOG_TAG = "ConfigurationDef";
    private final IConfigDefLoader mConfigDefLoader;

    ConfigurationXmlParser(IConfigDefLoader loader) {
        this.mConfigDefLoader = loader;
    }

    ConfigurationDef parse(String name, InputStream xmlInput) throws ConfigurationException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            ConfigHandler configHandler = new ConfigHandler(name, this.mConfigDefLoader);
            parser.parse(new InputSource(xmlInput), (DefaultHandler)configHandler);
            return configHandler.getParsedDef();
        }
        catch (ParserConfigurationException e) {
            this.throwConfigException(name, e);
        }
        catch (SAXException e) {
            this.throwConfigException(name, e);
        }
        catch (IOException e) {
            this.throwConfigException(name, e);
        }
        throw new ConfigurationException("should never reach here");
    }

    private void throwConfigException(String configName, Throwable e) throws ConfigurationException {
        if (e.getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)e.getCause();
        }
        throw new ConfigurationException(String.format("Failed to parse config xml '%s'", configName), e);
    }

    private static class ConfigHandler
    extends DefaultHandler {
        private static final String OBJECT_TAG = "object";
        private static final String OPTION_TAG = "option";
        private static final String INCLUDE_TAG = "include";
        private static final String CONFIG_TAG = "configuration";
        private ConfigurationDef mConfigDef;
        private String mCurrentConfigObject;
        private final IConfigDefLoader mConfigDefLoader;
        private Boolean isLocalConfig = null;

        ConfigHandler(String name, IConfigDefLoader loader) {
            this.mConfigDef = new ConfigurationDef(name);
            this.mConfigDefLoader = loader;
        }

        ConfigurationDef getParsedDef() {
            return this.mConfigDef;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (OBJECT_TAG.equals(localName)) {
                String objectTypeName = attributes.getValue("type");
                this.addObject(objectTypeName, attributes);
            } else if (Configuration.isBuiltInObjType(localName)) {
                if (this.isLocalConfig == null) {
                    this.isLocalConfig = true;
                } else if (!this.isLocalConfig.booleanValue()) {
                    this.throwException(String.format("Attempted to specify local object '%s' for global config!", localName));
                }
                this.addObject(localName, attributes);
            } else if (GlobalConfiguration.isBuiltInObjType(localName)) {
                if (this.isLocalConfig == null) {
                    this.isLocalConfig = false;
                } else if (this.isLocalConfig.booleanValue()) {
                    this.throwException(String.format("Attempted to specify global object '%s' for local config!", localName));
                }
                this.addObject(localName, attributes);
            } else if (OPTION_TAG.equals(localName)) {
                String optionName = attributes.getValue("name");
                if (optionName == null) {
                    this.throwException("Missing 'name' attribute for option");
                }
                String optionKey = attributes.getValue("key");
                String optionValue = attributes.getValue("value");
                if (optionValue == null) {
                    this.throwException("Missing 'value' attribute for option");
                }
                if (this.mCurrentConfigObject != null) {
                    optionName = String.format("%s%c%s", this.mCurrentConfigObject, Character.valueOf(':'), optionName);
                }
                this.mConfigDef.addOptionDef(optionName, optionKey, optionValue);
            } else if (CONFIG_TAG.equals(localName)) {
                String description = attributes.getValue("description");
                if (description != null) {
                    this.mConfigDef.setDescription(description);
                }
            } else if (INCLUDE_TAG.equals(localName)) {
                String includeName = attributes.getValue("name");
                if (includeName == null) {
                    this.throwException("Missing 'name' attribute for include");
                }
                try {
                    ConfigurationDef includedDef = this.mConfigDefLoader.getConfigurationDef(includeName);
                    this.mConfigDef.includeConfigDef(includedDef);
                }
                catch (ConfigurationException e) {
                    throw new SAXException(e);
                }
            } else {
                Log.w((String)ConfigurationXmlParser.LOG_TAG, (String)String.format("Unrecognized tag '%s' in configuration", localName));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (OBJECT_TAG.equals(localName) || Configuration.isBuiltInObjType(localName)) {
                this.mCurrentConfigObject = null;
            }
        }

        void addObject(String objectTypeName, Attributes attributes) throws SAXException {
            String className = attributes.getValue("class");
            if (className == null) {
                this.throwException(String.format("Missing class attribute for object %s", objectTypeName));
            }
            int classCount = this.mConfigDef.addConfigObjectDef(objectTypeName, className);
            this.mCurrentConfigObject = String.format("%s%c%d", className, Character.valueOf(':'), classCount);
        }

        private void throwException(String reason) throws SAXException {
            throw new SAXException(new ConfigurationException(String.format("Failed to parse config xml '%s'. Reason: %s", this.mConfigDef.getName(), reason)));
        }
    }
}

