/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.util.ArrayUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfiguration
implements IGlobalConfiguration {
    public static final String DEVICE_MONITOR_TYPE_NAME = "device_monitor";
    public static final String HOST_OPTIONS_TYPE_NAME = "host_options";
    public static final String DEVICE_REQUIREMENTS_TYPE_NAME = "device_requirements";
    private static Map<String, ObjTypeInfo> sObjTypeMap = null;
    private static IGlobalConfiguration sInstance = null;
    private static final Object sInstanceLock = new Object();
    private static final String GLOBAL_CONFIG_VARIABLE = "TF_GLOBAL_CONFIG";
    private static final String GLOBAL_CONFIG_FILENAME = "tf_global_config.xml";
    private Map<String, List<Object>> mConfigMap;
    private final String mName;
    private final String mDescription;

    public static IGlobalConfiguration getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("GlobalConfiguration has not yet been initialized!");
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> createGlobalConfiguration(String[] args) throws ConfigurationException {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance != null) {
                throw new IllegalStateException("GlobalConfiguration is already initialized!");
            }
            ArrayList<String> nonGlobalArgs = new ArrayList(args.length);
            IConfigurationFactory configFactory = ConfigurationFactory.getInstance();
            String globalConfigPath = GlobalConfiguration.getGlobalConfigPath();
            if (globalConfigPath != null) {
                sInstance = configFactory.createGlobalConfigurationFromArgs(ArrayUtil.buildArray({globalConfigPath}, args), nonGlobalArgs);
                System.err.format("Success!  Using global config \"%s\"\n", globalConfigPath);
            } else {
                sInstance = new GlobalConfiguration();
                nonGlobalArgs = Arrays.asList(args);
            }
            return nonGlobalArgs;
        }
    }

    private static String getGlobalConfigPath() throws ConfigurationException {
        String path = System.getenv(GLOBAL_CONFIG_VARIABLE);
        if (path != null) {
            System.err.format("Attempting to use global config \"%s\" from variable $%s.\n", path, GLOBAL_CONFIG_VARIABLE);
            return path;
        }
        File file = new File(GLOBAL_CONFIG_FILENAME);
        if (file.exists()) {
            path = file.getPath();
            System.err.format("Attempting to use autodetected global config \"%s\".\n", path);
            return path;
        }
        return null;
    }

    static boolean isBuiltInObjType(String typeName) {
        return GlobalConfiguration.getObjTypeMap().containsKey(typeName);
    }

    private static synchronized Map<String, ObjTypeInfo> getObjTypeMap() {
        if (sObjTypeMap == null) {
            sObjTypeMap = new HashMap<String, ObjTypeInfo>();
            sObjTypeMap.put(DEVICE_MONITOR_TYPE_NAME, new ObjTypeInfo(IDeviceMonitor.class, false));
            sObjTypeMap.put(DEVICE_REQUIREMENTS_TYPE_NAME, new ObjTypeInfo(IDeviceSelection.class, false));
        }
        return sObjTypeMap;
    }

    private GlobalConfiguration() {
        this("default", "default global configuration");
    }

    GlobalConfiguration(String name, String description) {
        this.mName = name;
        this.mDescription = description;
        this.mConfigMap = new LinkedHashMap<String, List<Object>>();
        this.setDeviceRequirements(new DeviceSelectionOptions());
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public IDeviceMonitor getDeviceMonitor() {
        return (IDeviceMonitor)this.getConfigurationObject(DEVICE_MONITOR_TYPE_NAME);
    }

    @Override
    public IDeviceSelection getDeviceRequirements() {
        return (IDeviceSelection)this.getConfigurationObject(DEVICE_REQUIREMENTS_TYPE_NAME);
    }

    public List<?> getConfigurationObjectList(String typeName) {
        return this.mConfigMap.get(typeName);
    }

    public Object getConfigurationObject(String typeName) {
        List<?> configObjects = this.getConfigurationObjectList(typeName);
        if (configObjects == null) {
            return null;
        }
        ObjTypeInfo typeInfo = GlobalConfiguration.getObjTypeMap().get(typeName);
        if (typeInfo != null && typeInfo.mIsListSupported) {
            throw new IllegalStateException(String.format("Wrong method call. Used getConfigurationObject() for a config object that is stored as a list", typeName));
        }
        if (configObjects.size() != 1) {
            throw new IllegalStateException(String.format("Attempted to retrieve single object for %s, but %d are present", typeName, configObjects.size()));
        }
        return configObjects.get(0);
    }

    private Collection<Object> getAllConfigurationObjects() {
        ArrayList<Object> objectsCopy = new ArrayList<Object>();
        for (List<Object> objectList : this.mConfigMap.values()) {
            objectsCopy.addAll(objectList);
        }
        return objectsCopy;
    }

    @Override
    public void injectOptionValue(String optionName, String optionValue) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionValue(optionName, optionValue);
    }

    @Override
    public void injectOptionValue(String optionName, String optionKey, String optionValue) throws ConfigurationException {
        OptionSetter optionSetter = new OptionSetter(this.getAllConfigurationObjects());
        optionSetter.setOptionMapValue(optionName, optionKey, optionValue);
    }

    @Override
    public void setDeviceMonitor(IDeviceMonitor monitor) {
        this.setConfigurationObjectNoThrow(DEVICE_MONITOR_TYPE_NAME, monitor);
    }

    @Override
    public void setDeviceRequirements(IDeviceSelection devRequirements) {
        this.setConfigurationObjectNoThrow(DEVICE_REQUIREMENTS_TYPE_NAME, devRequirements);
    }

    public void setConfigurationObject(String typeName, Object configObject) throws ConfigurationException {
        if (configObject == null) {
            throw new IllegalArgumentException("configObject cannot be null");
        }
        this.mConfigMap.remove(typeName);
        this.addObject(typeName, configObject);
    }

    @Override
    public void setConfigurationObjectList(String typeName, List<?> configList) throws ConfigurationException {
        if (configList == null) {
            throw new IllegalArgumentException("configList cannot be null");
        }
        this.mConfigMap.remove(typeName);
        for (Object configObject : configList) {
            this.addObject(typeName, configObject);
        }
    }

    private void addObject(String typeName, Object configObject) throws ConfigurationException {
        ObjTypeInfo typeInfo;
        List<Object> objList = this.mConfigMap.get(typeName);
        if (objList == null) {
            objList = new ArrayList<Object>(1);
            this.mConfigMap.put(typeName, objList);
        }
        if ((typeInfo = GlobalConfiguration.getObjTypeMap().get(typeName)) != null && !typeInfo.mExpectedType.isInstance(configObject)) {
            throw new ConfigurationException(String.format("The config object %s is not the correct type. Expected %s, received %s", typeName, typeInfo.mExpectedType.getCanonicalName(), configObject.getClass().getCanonicalName()));
        }
        if (typeInfo != null && !typeInfo.mIsListSupported && objList.size() > 0) {
            throw new ConfigurationException(String.format("Only one config object allowed for %s, but multiple were specified.", typeName));
        }
        objList.add(configObject);
    }

    private void setConfigurationObjectNoThrow(String typeName, Object configObject) {
        try {
            this.setConfigurationObject(typeName, configObject);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public List<String> setOptionsFromCommandLineArgs(List<String> listArgs) throws ConfigurationException {
        ArgsOptionParser parser = new ArgsOptionParser(this.getAllConfigurationObjects());
        return parser.parse(listArgs);
    }

    public void printCommandUsage(boolean importantOnly, PrintStream out) throws ConfigurationException {
        out.println(String.format("'%s' configuration: %s", this.getName(), this.getDescription()));
        out.println();
        if (importantOnly) {
            out.println("Printing help for only the important options. To see help for all options, use the --help-all flag");
            out.println();
        }
        for (Map.Entry<String, List<Object>> configObjectsEntry : this.mConfigMap.entrySet()) {
            for (Object configObject : configObjectsEntry.getValue()) {
                String optionHelp = this.printOptionsForObject(importantOnly, configObjectsEntry.getKey(), configObject);
                if (optionHelp.length() <= 0) continue;
                String classAlias = "";
                if (configObject.getClass().isAnnotationPresent(OptionClass.class)) {
                    OptionClass classAnnotation = configObject.getClass().getAnnotation(OptionClass.class);
                    classAlias = String.format("'%s' ", classAnnotation.alias());
                }
                out.printf("  %s%s options:", classAlias, configObjectsEntry.getKey());
                out.println();
                out.print(optionHelp);
                out.println();
            }
        }
    }

    private String printOptionsForObject(boolean importantOnly, String objectTypeName, Object configObject) throws ConfigurationException {
        return ArgsOptionParser.getOptionHelp(importantOnly, configObject);
    }

    public void validateOptions() throws ConfigurationException {
        new ArgsOptionParser(this.getAllConfigurationObjects()).validateMandatoryOptions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjTypeInfo {
        final Class<?> mExpectedType;
        final boolean mIsListSupported;

        ObjTypeInfo(Class<?> expectedType, boolean isList) {
            this.mExpectedType = expectedType;
            this.mIsListSupported = isList;
        }
    }
}

